<?php
/*
 * NP_AccessAnalyze
 * NP_AccessAnalyze_MngPage.php
 * Ver:1.4
 * Auther:Reine
 */
class NP_AccessAnalyze_MngPage {
	function __construct($oPluginAdmin, $blogs) {
		$this->admin = $oPluginAdmin->plugin;
		
		$this->blogs = $blogs;
		$this->blogid = $this->blogs[0];
		$this->period = date('Y').date('m');
		$this->category = 'Summary';
		$this->itemid = '';
		$this->filter = '';
	}
	
	function action() {
		$param = array();
		if ($this->blogid) $param['b'] = $this->blogid;
		if ($this->period) {
			if (intval(substr($this->period, 0, 4)) < 1970)
				$param['p'] = date('Y').date('m');
			else
				$param['p'] = $this->period;
		}
		if ($this->category) $param['c'] = $this->category;
		$param_f = $this->filter ? array_merge($param, array('f' => $this->filter)) : $param;
		
		$compResult = '';
		if ($this->category == 'Compress_log' && $this->filter
			&& (substr($this->filter, 0, 1) == 'c' || substr($this->filter, 0, 1) == 'd')) {
			$compResult = $this->doCompress($param_f);
			$param_f = $param;
		}
		
		echo sprintf("<h3><b>%s</b></h3>\n", $this->translated('Criteria'));
		echo "<div style=\"margin-left:1em;\">\n";
		$this->showBlogCriteria($param);
		$this->showDateCriteria($param_f);
		echo "</div>";
		
		echo "<h3><b>";
		if (!$this->period) {
			echo $this->translated('Total summary log');
		} elseif (strlen($this->period) == 4) {
			echo sprintf($this->translated('%1$d summary log'), $this->period);
		} elseif (strlen($this->period) == 6) {
			echo sprintf($this->translated('%1$d-%2$d summary log'), substr($this->period, 0, 4), substr($this->period, 4, 2));
		} else {
			echo sprintf($this->translated('%1$d-%2$d-%3$d day log'), substr($this->period, 0, 4), substr($this->period, 4, 2), substr($this->period, 6, 2));
		}
		echo "</b></h3>\n";
		echo "<div style=\"margin-left:1em;\">\n";
		$this->showCategory($param);
		if ($this->category == 'Compress_log') {
			if ($compResult) echo sprintf('<p style="font-size:larger;font-weight:bold;">%s</p>', htmlspecialchars($this->translated($compResult)));
			$this->showCompress($param);
		} else {
			$this->showSiteCount($param, TRUE);
			echo "<br/>\n";
			switch ($this->category) {
				case 'Site_access':
					$this->showSiteCount($param, FALSE);
					break;
				case 'Hourly':
					$this->showHourlyCount($param);
					break;
				case 'Item':
					if ($this->filter && stripos($this->filter, 'i') == 0) {
						$this->showItem($param_f);
						echo  sprintf("<h3>%s&nbsp;<a href=\"%s\">%s</a></h3>\n"
							, $this->translated('Item detail')
							, $this->createLink($param)
							, htmlspecialchars($this->translated('<to Ranking>')));
						$this->showItemCount($param_f);
						$this->showRefererRank($param_f, array('referer'), 10);
					} else {
						$this->showItemRank($param, 30);
					}
					break;
				case 'Referer':
					$this->showRefererRank($param, array('referer'), 30);
					break;
				case 'Search':
					$this->showSearchRank($param, array('source', 'searchword'));
					$this->showSearchRank($param, array('source'));
					$this->showSearchRank($param, array('searchword'));
					break;
				case 'Agent':
					$this->showAgentRank($param, array('os', 'browser', 'engine'));
					$this->showAgentRank($param, array('os'));
					$this->showAgentRank($param, array('browser', 'engine'));
					break;
				default: // Summary
					$this->showItemRank($param, 3);
					$this->showRefererRank($param, array('referer'), 3);
					$this->showSearchRank($param, array('searchword'), 3);
					$this->showAgentRank($param, array('os', 'browser'), 3);
			}
		}
		echo "</div>";
	}

	private function createLink($params) {
		$query = array();
		foreach ($params as $param => $value) {
			$query[] = $param . '=' . urlencode($value);
		}
		return $this->admin->getAdminURL().'?'.implode('&amp;', $query);
	}

	private function translated($val) {
		return $this->admin->translated($val);
	}

	private function tablePrefix($tablename) {
		return $this->admin->tablePrefix($tablename);
	}

	private function showCategory($param) {
		// show category
		$types = array('Summary', 'Site_access', 'Hourly', 'Item', 'Referer', 'Search', 'Agent', 'Compress_log');
		echo "<div style=\"margin-bottom:10px;\">";
		for ($i = 0 ; $i < count($types); $i++) {
			if ($i > 0) echo '&nbsp;';
			$wkarr = array_merge($param, array('c' => $types[$i]));
			if ($types[$i] == $param['c']) {
				echo sprintf('<span style="border:1px solid gray;">&nbsp;%s&nbsp;</span>', htmlspecialchars($this->translated($types[$i])));
			} else {
				echo sprintf('<a style="border:1px solid gray;background-color:gainsboro;" href="%s">&nbsp;%s&nbsp;</a>'
					, $this->createLink($wkarr)
					, htmlspecialchars($this->translated($types[$i])));
			}
		}
		echo "</div>\n";
	}
	
	// show blog links
	private function showBlogCriteria($param) {
		echo sprintf('<div>%s&nbsp;', htmlspecialchars($this->translated('Blog:')));
		for ($i = 0 ; $i < count($this->blogs); $i++) {
			if ($i > 0) echo '&nbsp;|&nbsp;';
			if ($this->blogs[$i] == $param['b']) {
				echo sprintf('<span style="text-decoration:underline;">%s</span>', htmlspecialchars(getBlogNameFromID($this->blogs[$i])));
			} else {
				$wkarr = array_merge($param, array('b' => $this->blogs[$i]));
				echo sprintf('<a href="%s">%s</a>', $this->createLink($wkarr), htmlspecialchars(getBlogNameFromID($this->blogs[$i])));
			}
		}
		echo "</div>\n";
	}
	
	// show date links
	private function showDateCriteria($param) {
		$year = substr($param['p'],0,4) ? substr($param['p'],0,4) : date('Y');
		$month = substr($param['p'],4,2) ? substr($param['p'],4,2) : '';
		$day = substr($param['p'],6,2) ? substr($param['p'],6,2) : '';
		
		// year
		echo sprintf('<div>%s&nbsp;', htmlspecialchars($this->translated('Period[Year]:')));
		$wkarr = array_merge($param, array('p' => intval($year) - 1));
		echo '<a href="'.$this->createLink($wkarr).'">&nbsp;&lt;</a>&nbsp;';
		$wkarr = array_merge($param, array('p' => $year));
		if (!$month) {
			echo sprintf('<span style="text-decoration:underline;">%s</span>&nbsp;', $year);
		} else {
			echo sprintf('<a href="%s">%s</a>&nbsp;'
				, $this->createLink($wkarr), $year);
		}
		if ($year != date('Y')) {
			$wkarr = array_merge($param, array('p' => intval($year) + 1));
			echo '<a href="'.$this->createLink($wkarr).'">&gt;&nbsp;</a>';
		}
		echo "</div>\n";
		// month
		if ($this->isDetailLogExist($param['b'], $year)) {
			$q = sprintf("SELECT DISTINCT LEFT(period, 6) AS period FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND CHAR_LENGTH(period)>=6 ORDER BY period ASC LIMIT 12"
				, $this->tablePrefix('SiteCount')
				, intval($param['b'])
				, sql_real_escape_string($year));
			$result = sql_query($q);
			$data = array();
			if (sql_num_rows($result)) {
				while($o = sql_fetch_object($result)) $data[] = intval(substr($o->period, -2, 2));
			}
			$j = 0;
			echo sprintf('<div style="padding-left:30px;">%s&nbsp;', htmlspecialchars($this->translated('[Month]:')));
			for ($i = 1 ; $i <= 12; $i++) {
				if ($i > 1) echo '&nbsp;';
				$wkarr = array_merge($param, array('p' => $year.sprintf('%02d', $i)));
				$s_mon = date('M', strtotime(sprintf('%s-%02d-01', $year, $i)));
				if ($j < count($data) && $i == $data[$j]) {
					if (!$day && intval($month) == $i) {
						echo sprintf('<span style="text-decoration:underline;">%s</span>', htmlspecialchars($this->translated($s_mon)));
					} else {
						echo sprintf('<a href="%s">%s</a>'
							, $this->createLink($wkarr), htmlspecialchars($this->translated($s_mon)));
					}
					$j++;
				} else {
					echo sprintf('<span style="color:gray;">%s</span>', htmlspecialchars($this->translated($s_mon)));
				}
			}
			echo "</div>\n";
		}
		// day
		if ($year && $month && $this->isDetailLogExist($param['b'], $year.$month)) {
			$q = sprintf("SELECT DISTINCT period FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND CHAR_LENGTH(period)=8 ORDER BY period ASC LIMIT 31"
				, $this->tablePrefix('SiteCount')
				, intval($param['b'])
				, sql_real_escape_string($year.$month));
			$result = sql_query($q);
			$data = array();
			if (sql_num_rows($result)) {
				while($o = sql_fetch_object($result)) $data[] = intval(substr($o->period, -2, 2));
			}
			$j = 0;
			echo sprintf('<div style="padding-left:30px;">%s&nbsp;', htmlspecialchars($this->translated('[Day]:')));
			for ($i = 1 ; $i <= 31; $i++) {
				$wk_date = strtotime(sprintf('%s-%02d-%02d', $year, $month, $i));
				if (date('m', $wk_date) != $month) break;
				if ($i > 1) echo '&nbsp;';
				$wkarr = array_merge($param, array('p' => $year.$month.sprintf('%02d', $i)));
				if ($j < count($data) && $i == $data[$j]) {
					if (intval($day) == $i) {
						echo sprintf('<span style="text-decoration:underline;">%s</span>', $i);
					} else {
						echo sprintf('<a href="%s">%s</a>'
							, $this->createLink($wkarr), htmlspecialchars($i));
					}
					$j++;
				} else {
					echo sprintf('<span style="color:gray;">%s</span>', $i);
				}
			}
			echo "</div>\n";
		}
		
	}
	
	private function showSiteCount($param, $summary = FALSE) {
		$period = $param['p'];
		if ($summary) {
			switch (strlen($period)) {
				case 4:
					$period = '';
					break;
				case 6:
					$period = substr($period, 0, 4);
					break;
				case 8:
					$period = substr($period, 0, 6);
					break;
				default:
					$period = null;
			}
		}
		if ($period === null) {
			$qStr = "SELECT 'total' AS s_period, SUM(userview) AS userview, SUM(pageview) AS pageview, SUM(rssview) AS rssview FROM %s"
				." WHERE blogid=%s GROUP BY s_period LIMIT 1";
		} elseif (!$period) { // Annual summary
			$qStr = "SELECT LEFT(period, 4) AS s_period, SUM(userview) AS userview, SUM(pageview) AS pageview, SUM(rssview) AS rssview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' GROUP BY s_period ORDER BY s_period DESC LIMIT 10";
		} elseif (strlen($period) == 4) { // Monthly Summary
			$qStr = "SELECT LEFT(period, 6) AS s_period, SUM(userview) AS userview, SUM(pageview) AS pageview, SUM(rssview) AS rssview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' GROUP BY s_period ORDER BY s_period ASC LIMIT 12";
		} else { // Day list
			$qStr = "SELECT period AS s_period, userview, pageview, rssview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' ORDER BY s_period ASC LIMIT 31";
		}
		$q = sprintf($qStr
			, $this->tablePrefix('SiteCount')
			, intval($param['b'])
			, sql_real_escape_string($param['p']));
		$result = sql_query($q);
		
		$data = array();
		if (sql_num_rows($result)) {
			while($o = sql_fetch_object($result)) {
				$data[] = array($this->getDateStr($o->s_period, $param, (!$summary && strlen($period) < 8))
					, $o->userview, $o->pageview, $o->rssview);
			}
		}
		
		$title = $summary ? 'Total access' : 'Access count';
		$cnf = array();
		$cnf[] = array('text' , 'period'  , 100);
		$cnf[] = array('count', 'userview', 200);
		$cnf[] = array('count', 'pageview', 200);
		$cnf[] = array('count', 'rssview' , 200);
		$this->showTable($title, $cnf, $data);
	}
	
	private function showHourlyCount($param) {
		$qcol = '';
		for ($i = 0; $i < 24; $i++) {
			$qcol .= sprintf(', SUM(pageview%1$02d) AS pageview%1$02d', $i);
		}
		if (!$param['p']) { // Total summary
			$qStr = "SELECT ".substr($qcol, 2)." FROM %s WHERE blogid=%s LIMIT 1";
		} elseif (strlen($param['p']) == 4) { // Annual summary
			$qStr = "SELECT LEFT(period, 4) AS s_period ".$qcol." FROM %s WHERE blogid=%s AND period LIKE '%s%%' GROUP BY s_period LIMIT 1";
		} elseif (strlen($param['p']) == 6) { // Monthly Summary
			$qStr = "SELECT LEFT(period, 6) AS s_period ".$qcol." FROM %s WHERE blogid=%s AND period LIKE '%s%%' GROUP BY s_period LIMIT 1";
		} else { // Day list
			$qStr = "SELECT period AS s_period ".$qcol." FROM %s WHERE blogid=%s AND period LIKE '%s%%' GROUP BY s_period LIMIT 1";
		}
		$q = sprintf($qStr
			, $this->tablePrefix('HourlyCount')
			, intval($param['b'])
			, sql_real_escape_string($param['p']));
		$result = sql_query($q);
		
		$data = array();
		if (sql_num_rows($result)) {
			while($o = sql_fetch_assoc($result)) {
				for ($i = 0; $i < 24; $i++) {
					$data[] = array(sprintf("%02d:00-%02d:00", $i, $i+1), $o[sprintf("pageview%02d", $i)]);
				}
			}
		}
		
		$title = 'Hourly count';
		$cnf = array();
		$cnf[] = array('text' , 'time zone', 100);
		$cnf[] = array('count', 'pageview' , 200);
		$this->showTable($title, $cnf, $data);
	}
	
	private function showItemRank($param, $limit = 10) {
		global $manager;
		
		$q = sprintf("SELECT itemid, SUM(pageview) AS pageview FROM %s"
			." WHERE blogid=%s AND period LIKE '%s%%' GROUP BY itemid ORDER BY pageview DESC, itemid DESC LIMIT %s"
			, $this->tablePrefix('ItemCount')
			, intval($param['b'])
			, sql_real_escape_string($param['p'])
			, intval($limit));
		$result = sql_query($q);
		
		$data = array();
		if (sql_num_rows($result)) {
			while($o = sql_fetch_object($result)) {
				$wkarr = array_merge($param, array('i' => $o->itemid));
				$item = $manager->getItem($o->itemid, TRUE, TRUE);
				$data[] = array(date('Y-m-d', $item['timestamp'])
					, array(mb_substr($item['title'], 0, 30, _CHARSET)
						, $this->createLink(array_merge($param, array('f' => 'i'.$o->itemid, 'c' => 'Item'))))
					, $o->pageview);
			}
		}
		unset($item);
		
		$title = sprintf($this->translated('Item access ranking [Top %s]'), $limit);
		$cnf = array();
		$cnf[] = array('text' , 'posted date', 100);
		$cnf[] = array('text' , 'title'      , 400);
		$cnf[] = array('count', 'pageview'   , 200);
		$this->showTable($title, $cnf, $data);
	}
	
	private function showItem($param) {
		global $manager;
		
		if (!$param['f'] || stripos($param['f'], 'i') === FALSE) return;
		$itemid = intval(substr($param['f'], 1));
		$item = $manager->getItem($itemid, TRUE, TRUE);
		
		$data = array(array(date('Y-m-d', $item['timestamp']), mb_substr($item['title'], 0, 50, _CHARSET)));
		
		$title = 'Selected item';
		$cnf = array();
		$cnf[] = array('text', 'posted date', 100);
		$cnf[] = array('text', 'title'      , 600);
		$this->showTable($title, $cnf, $data);
	}
	
	private function showItemCount($param) {
		if (!$param['f'] || stripos($param['f'], 'i') === FALSE) return;
		$itemid = intval(substr($param['f'], 1));
		
		if (!$param['p']) { // Annual summary
			$qStr = "SELECT LEFT(period, 4) AS s_period, SUM(pageview) AS pageview FROM %s"
				." WHERE blogid=%s AND itemid=%s AND period LIKE '%s%%' GROUP BY s_period ORDER BY s_period ASC LIMIT 10";
		} elseif (strlen($param['p']) == 4) { // Monthly Summary
			$qStr = "SELECT LEFT(period, 6) AS s_period, SUM(pageview) AS pageview FROM %s"
				." WHERE blogid=%s AND itemid=%s AND period LIKE '%s%%' GROUP BY s_period ORDER BY s_period ASC LIMIT 12";
		} else { // Day list
			$qStr = "SELECT period AS s_period, pageview FROM %s WHERE blogid=%s AND itemid=%s AND period LIKE '%s%%' LIMIT 31";
		}
		$q = sprintf($qStr
			, $this->tablePrefix('ItemCount')
			, intval($param['b'])
			, intval($itemid)
			, sql_real_escape_string($param['p']));
		$result = sql_query($q);
		
		$data = array();
		if (sql_num_rows($result)) {
			while($o = sql_fetch_object($result)) {
				$data[] = array($this->getDateStr($o->s_period, $param, (strlen($param['p']) < 8)), $o->pageview);
			}
		}
		
		$title = 'Item count';
		$cnf = array();
		$cnf[] = array('text' , 'period'  , 100);
		$cnf[] = array('count', 'pageview', 200);
		$this->showTable($title, $cnf, $data);
	}
	
	private function showRefererRank($param, $showcol = array('itemid', 'referer'), $limit = 10) {
		global $manager;
		
		if (!is_array($showcol) || count($showcol) == 0) $showcol = array('itemid', 'referer');
		if (array_key_exists('f', $param) && stripos($param['f'], 'i') !== FALSE) {
			$itemid = intval(substr($param['f'], 1));
			$q = sprintf("SELECT ".implode(',', $showcol).", SUM(pageview) AS pageview FROM %s"
				." WHERE blogid=%s AND itemid=%s AND period LIKE '%s%%' GROUP BY ".implode(',', $showcol)." ORDER BY pageview DESC LIMIT %s"
				, $this->tablePrefix('RefererCount')
				, intval($param['b'])
				, intval($itemid)
				, sql_real_escape_string($param['p'])
				, intval($limit));
		} else {
			$q = sprintf("SELECT ".implode(',', $showcol).", SUM(pageview) AS pageview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' GROUP BY ".implode(',', $showcol)." ORDER BY pageview DESC, itemid DESC LIMIT %s"
				, $this->tablePrefix('RefererCount')
				, intval($param['b'])
				, sql_real_escape_string($param['p'])
				, intval($limit));
		}
		$result = sql_query($q);
		
		$data = array();
		if (sql_num_rows($result)) {
			while($o = sql_fetch_assoc($result)) {
				$row = array();
				foreach ($showcol as $col) {
					switch ($col) {
						case 'itemid':
							$item = $manager->getItem($o['itemid'], TRUE, TRUE);
							$row[] = mb_substr($item['title'], 0, 20, _CHARSET);
							break;
						case 'referer':
							$row[] = mb_substr($o['referer'], 0, 70, _CHARSET);
							break;
					}
				}
				unset($col);
				$row[] = $o['pageview'];
				$data[] = $row;
			}
		}
		
		$showcol_tr = $showcol;
		foreach ($showcol_tr as $col) $col = $this->translated($col);
		$title = sprintf($this->translated('%s ranking [Top %s]'), ucwords(implode(', ', $showcol_tr)), $limit);
		$cnf = array();
		foreach ($showcol as $col) {
			switch ($col) {
				case 'itemid':	$cnf[] = array('text', 'title', 200);	break;
				case 'referer':	$cnf[] = array('text', 'referer', 400);	break;
			}
		}
		$cnf[] = array('count', 'pageview', 100);
		$this->showTable($title, $cnf, $data);
	}
	
	private function showSearchRank($param, $showcol = array('source', 'searchword'), $limit = 10) {
		if (!is_array($showcol) || count($showcol) == 0) $showcol = array('source', 'searchword');
		$q = sprintf("SELECT ".implode(',', $showcol).", SUM(pageview) AS pageview FROM %s"
			." WHERE blogid=%s AND period LIKE '%s%%' GROUP BY ".implode(',', $showcol)." ORDER BY pageview DESC LIMIT %s"
			, $this->tablePrefix('SearchCount')
			, intval($param['b'])
			, sql_real_escape_string($param['p'])
			, intval($limit));
		$result = sql_query($q);
		
		$data = array();
		if (sql_num_rows($result)) {
			while($o = sql_fetch_assoc($result)) {
				$row = array();
				foreach ($showcol as $col) $row[] = $o[$col];
				unset($col);
				$row[] = $o['pageview'];
				$data[] = $row;
			}
		}
		
		$showcol_tr = $showcol;
		foreach ($showcol_tr as $col) $col = $this->translated($col);
		$title = sprintf($this->translated('%s ranking [Top %s]'), ucwords(implode(', ', $showcol_tr)), $limit);
		$cnf = array();
		foreach ($showcol as $col) {
			switch ($col) {
				case 'source':		$cnf[] = array('text', 'source', 150);		break;
				case 'searchword':	$cnf[] = array('text', 'searchword', 300);	break;
			}
		}
		$cnf[] = array('count', 'pageview', 100);
		$this->showTable($title, $cnf, $data);
	}
	
	private function showAgentRank($param, $showcol = array('os', 'browser', 'engine'), $limit = 10) {
		if (!is_array($showcol) || count($showcol) == 0) $showcol = array('os', 'browser', 'engine');
		$q = sprintf("SELECT ".implode(',', $showcol).", SUM(userview) AS userview FROM %s"
			." WHERE blogid=%s AND period LIKE '%s%%' GROUP BY ".implode(',', $showcol)." ORDER BY userview DESC LIMIT %s"
			, $this->tablePrefix('AgentCount')
			, intval($param['b'])
			, sql_real_escape_string($param['p'])
			, intval($limit));
		$result = sql_query($q);
		
		$data = array();
		if (sql_num_rows($result)) {
			while($o = sql_fetch_assoc($result)) {
				$row = array();
				foreach ($showcol as $col) $row[] = $o[$col];
				unset($col);
				$row[] = $o['userview'];
				$data[] = $row;
			}
		}
		
		$showcol_tr = $showcol;
		foreach ($showcol_tr as $col) $col = $this->translated($col);
		$title = sprintf($this->translated('%s ranking [Top %s]'), ucwords(implode(', ', $showcol_tr)), $limit);
		$cnf = array();
		foreach ($showcol as $col) {
			switch ($col) {
				case 'os':		$cnf[] = array('text', 'os', 150);		break;
				case 'engine':	$cnf[] = array('text', 'engine', 200);	break;
				case 'browser':	$cnf[] = array('text', 'browser', 200);	break;
			}
		}
		$cnf[] = array('count', 'userview', 100);
		$this->showTable($title, $cnf, $data);
	}
	
	private function isDetailLogExist($blogid, $period) {
		$q = sprintf("SELECT period FROM %s WHERE blogid=%s AND period LIKE '%s%%'"
			, $this->tablePrefix('SiteCount')
			, intval($blogid)
			, sql_real_escape_string($period));
		$result = sql_query($q);
		if (sql_num_rows($result)) {
			while($o = sql_fetch_assoc($result)) {
				if (strlen($o['period']) > strlen($period)) return TRUE;
			}
		}
		return FALSE;
	}
	
	/*
		Table View function
		$cols = array(array('[text|count]', '#header_text#', #width_px#)[, array()])
		$data = array(array(#value_row1col1#[, #value_row1col2#])[, array()])
		The second element is url if "value_row1col1" is an array.
	*/
	private function showTable($title, $cols, $data) {
		
		// table width
		$table_w = 0;
		foreach ($cols as $col) $table_w += intval($col[2]);
		unset($col);
		echo '<table class="accessanalyze_showtable" style="width:'.htmlspecialchars($table_w).'px;">';
		echo '<caption>'.htmlspecialchars($this->translated($title)).'</caption>';
		
		// write header
		echo '<tr>';
		$left_p = -1;
		foreach ($cols as $col) {
			echo '<th class="textcell" style="width:'.htmlspecialchars($col[2]).'px;">'.htmlspecialchars($this->translated($col[1])).'</th>';
			$left_p += intval($col[2]);
		}
		unset($col);
		echo '</tr>'."\n";
		
		// write body
		//  write data
		if (count($data) == 0) {
			echo '<tr><td class="empty" colspan="'.count($cols).'">'
				.htmlspecialchars($this->translated('No Logs...')).'</td></tr>';
		} else {
			//  max value get
			$tmax = 0;
			$maxval = array_fill(0, count($cols), 10);
			foreach ($data as $row) {
				for ( $i=0; $i<count($row); $i++) {
					if (is_numeric($row[$i]) && $maxval[$i] < intval($row[$i])) $maxval[$i] = intval($row[$i]);
					if (is_numeric($row[$i]) && $tmax < intval($row[$i])) $tmax = intval($row[$i]);
				}
			}
			$rspan = 8 + 9 * strlen($tmax);
			foreach ($data as $row) {
				$left_p = -1;
				echo '<tr>';
				for ( $i=0; $i<count($row); $i++) {
					switch ($cols[$i][0]) {
						case 'count':
							$bar_w = intval((intval($cols[$i][2]) - $rspan) / $maxval[$i] * intval($row[$i]));
							echo sprintf('<td><img src="%sbar.png" alt="count" style="width:%spx;" />&nbsp;%s</td>'
								, $this->admin->getAdminURL(), htmlspecialchars($bar_w), htmlspecialchars($row[$i]));
							break;
						default:
							if (is_array($row[$i])) {
								echo sprintf('<td class="textcell"><a href="%s">%s</a></td>', $row[$i][1], htmlspecialchars(($row[$i][0] ? $row[$i][0] : '-')));
							} else {
								echo sprintf('<td class="textcell">%s</td>', htmlspecialchars(($row[$i] ? $row[$i] : '-')));
							}
					}
					$left_p += intval($cols[$i][2]);
				}
				echo "</tr>\n";
			}
		}
		echo "</table>\n";
	}
	
	private function getDateStr($period, $linkval, $onlink = FALSE) {
		if (!is_numeric($period)) return $period;
		$ret = '';
		if (strlen($period) >= 4) $ret .= substr($period, 0, 4);
		if (strlen($period) >= 6) $ret .= ('-'.substr($period, 4, 2));
		if (strlen($period) == 8) $ret .= ('-'.substr($period, 6, 2));
		
		if ($onlink) {
			$ret = array($ret, $this->createLink(array_merge($linkval, array('p' => $period))));
		}
		return $ret;
	}
	
	private function showCompress($param) {
		$showLink = FALSE;
		$year = substr($param['p'],0,4);
		$month = substr($param['p'],4,2);
		if (strlen($param['p']) >= 6 && $this->isDetailLogExist($param['b'], $year.$month)) {
			echo sprintf('<p>%s</p>', htmlspecialchars($this->translated('Daily log compression at Month')));
			echo sprintf('<div style="padding-left:30px;">%s&nbsp;', htmlspecialchars($this->translated('Range:')));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'cdp')))
				, htmlspecialchars(sprintf($this->translated('Previous %s-%s'), $year, $month)));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'cdi')))
				, htmlspecialchars(sprintf($this->translated('In %s-%s'), $year, $month)));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'cda')))
				, htmlspecialchars($this->translated('All')));
			echo '</div>';
			$showLink = TRUE;
		}
		if (strlen($param['p']) >= 4 && $this->isDetailLogExist($param['b'], $year)) {
			echo sprintf('<p>%s</p>', htmlspecialchars($this->translated('Monthly log compression at Year')));
			echo sprintf('<div style="padding-left:30px;">%s&nbsp;', htmlspecialchars($this->translated('Range:')));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'cmp')))
				, htmlspecialchars(sprintf($this->translated('Previous %s'), $year)));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'cmi')))
				, htmlspecialchars(sprintf($this->translated('In %s'), $year)));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'cma')))
				, htmlspecialchars($this->translated('All')));
			echo '</div>';
			$showLink = TRUE;
			
			echo "<hr/>\n";
			echo sprintf('<p>%s</p>', htmlspecialchars($this->translated('Delete the log of the year')));
			echo sprintf('<div style="padding-left:30px;">%s&nbsp;', htmlspecialchars($this->translated('Range:')));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'dmp')))
				, htmlspecialchars(sprintf($this->translated('Previous %s'), $year)));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'dmi')))
				, htmlspecialchars(sprintf($this->translated('In %s'), $year)));
			echo sprintf('<a href="%s">[%s]</a>&nbsp;&nbsp;'
				, $this->createLink(array_merge($param, array('f' => 'dma')))
				, htmlspecialchars($this->translated('All')));
			echo '</div>';
			$showLink = TRUE;
		}
		if (!$showLink) {
			echo sprintf('<p>%s</p>', htmlspecialchars($this->translated('There is no log that can be compressed.')));
		}
	}
	
	private function doCompress($param) {
		global $manager;
		if (!$manager->checkTicket()) {
			// invalid ticket
			return 'Ticket is invalid.';
		}
		// compress process
		$excludeDate = new DateTime();
		$excludeDate->sub(new DateInterval("P7D"));
		$excludePeriod = $excludeDate->format("Ymd");
		// UserTemp
		$tdate = new DateTime();
		$tdate->sub(new DateInterval("P1M"));
		sql_query(sprintf("DELETE FROM %s WHERE blogid=%s AND accessdate < '%s'"
			, $this->tablePrefix('UserTemp')
			, intval($param['b'])
			, sql_real_escape_string($tdate->format("Ymd"))));
		
		$flgDel = substr($param['f'], 0, 1) == 'd' ? TRUE : FALSE;
		// Extract compress years(or months)
		$periods = Array();
		$q_period = '';
		switch (substr($param['f'], 1, 2)) {
			case 'mp':	$q_period = sprintf(" AND period < '%s'", sql_real_escape_string(substr($param['p'], 0, 4).'13'));
				break;
			case 'mi':	$q_period = sprintf(" AND period LIKE '%s%%'", sql_real_escape_string(substr($param['p'], 0, 4)));
				break;
			case 'dp':	$q_period = sprintf(" AND period < '%s'", sql_real_escape_string(substr($param['p'], 0, 6).'32'));
				break;
			case 'di':	$q_period = sprintf(" AND period LIKE '%s%%'", sql_real_escape_string(substr($param['p'], 0, 6)));
				break;
			case 'ma':
			case 'da':	break;
			default:	return 'Request is invalid.';
		}
		$q_period = str_replace('%', '%%', $q_period);
		switch (substr($param['f'], 1, 1)) {
			case 'm':
				$qStr = "SELECT DISTINCT LEFT(period, 4) AS period FROM %s WHERE blogid=%s AND CHAR_LENGTH(period)>=4".$q_period;
				break;
			case 'd':
				$qStr = "SELECT DISTINCT LEFT(period, 6) AS period FROM %s WHERE blogid=%s AND CHAR_LENGTH(period)>=6".$q_period;
				break;
			default:	return 'Request is invalid.';
		}
		$q = sprintf($qStr
			, $this->tablePrefix('SiteCount')
			, intval($param['b']));
		$result = sql_query($q);
		if (sql_num_rows($result)) {
			while($o = sql_fetch_assoc($result)) {
				$periods[] = $o['period'];
			}
		} else return 'There was no data of interest.';
		unset($result);
		
		// compressing target period
		foreach ($periods as $period) {
			// SiteCount
			$qStr = "SELECT SUM(userview) AS userview, SUM(pageview) AS pageview, SUM(rssview) AS rssview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'";
			$q = sprintf($qStr
				, $this->tablePrefix('SiteCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod));
			$result = sql_query($q);
			if (sql_num_rows($result) && $o = sql_fetch_assoc($result)) {
				$row = Array('userview' => $o['userview'], 'pageview' => $o['pageview'], 'rssview' => $o['rssview']);
			}
			unset($result);
			sql_query(sprintf("DELETE FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'"
				, $this->tablePrefix('SiteCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod)));
			if (!$flgDel) {
				sql_query(sprintf("INSERT INTO %s (blogid, period, userview, pageview, rssview) VALUES(%s, '%s', %s, %s, %s)"
					, $this->tablePrefix('SiteCount')
					, intval($param['b'])
					, sql_real_escape_string($period)
					, intval($row['userview'])
					, intval($row['pageview'])
					, intval($row['rssview'])
					));
			}
			
			// HourlyCount
			$cols = Array();
			for ($i = 0; $i < 24; $i++) $cols[] = sprintf('SUM(pageview%1$02d) AS pageview%1$02d', $i);
			$qStr = "SELECT ".implode(',', $cols)." FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'";
			$q = sprintf($qStr
				, $this->tablePrefix('HourlyCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod));
			$result = sql_query($q);
			$row = Array();
			if (sql_num_rows($result) && $o = sql_fetch_assoc($result)) {
				for ($i = 0; $i < 24; $i++) $row[sprintf("pageview%02d", $i)] = $o[sprintf("pageview%02d", $i)] ? $o[sprintf("pageview%02d", $i)] : 0;
			}
			unset($result);
			sql_query(sprintf("DELETE FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'"
				, $this->tablePrefix('HourlyCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod)));
			if (!$flgDel) {
				sql_query(sprintf("INSERT INTO %s (blogid, period, ".implode(',', array_keys($row)).") VALUES(%s, '%s', ".implode(',', array_values($row)).")"
					, $this->tablePrefix('HourlyCount')
					, intval($param['b'])
					, sql_real_escape_string($period)
					));
			}
			
			// ItemCount
			$qStr = "SELECT itemid, SUM(pageview) AS pageview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s' GROUP BY itemid";
			$q = sprintf($qStr
				, $this->tablePrefix('ItemCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod));
			$result = sql_query($q);
			$rows = Array();
			if (sql_num_rows($result)) {
				while($o = sql_fetch_assoc($result)) {
					$rows[] = Array('itemid' => $o['itemid'], 'pageview' => $o['pageview']);
				}
			}
			unset($result);
			sql_query(sprintf("DELETE FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'"
				, $this->tablePrefix('ItemCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod)));
			if (!$flgDel) {
				foreach ($rows as $row) {
					sql_query(sprintf("INSERT INTO %s (blogid, period, itemid, pageview) VALUES(%s, '%s', %s, %s)"
						, $this->tablePrefix('ItemCount')
						, intval($param['b'])
						, sql_real_escape_string($period)
						, intval($row['itemid'])
						, intval($row['pageview'])
						));
				}
			}
			
			// RefererCount
			$qStr = "SELECT itemid, referer, SUM(pageview) AS pageview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s' GROUP BY itemid, referer";
			$q = sprintf($qStr
				, $this->tablePrefix('RefererCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod));
			$result = sql_query($q);
			$rows = Array();
			if (sql_num_rows($result)) {
				while($o = sql_fetch_assoc($result)) {
					$rows[] = Array('itemid' => $o['itemid'], 'referer' => $o['referer'], 'pageview' => $o['pageview']);
				}
			}
			unset($result);
			sql_query(sprintf("DELETE FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'"
				, $this->tablePrefix('RefererCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod)));
			if (!$flgDel) {
				foreach ($rows as $row) {
					sql_query(sprintf("INSERT INTO %s (blogid, period, itemid, referer, pageview) VALUES(%s, '%s', %s, '%s', %s)"
						, $this->tablePrefix('RefererCount')
						, intval($param['b'])
						, sql_real_escape_string($period)
						, intval($row['itemid'])
						, sql_real_escape_string($row['referer'])
						, intval($row['pageview'])));
				}
			}
			
			// SearchCount
			$qStr = "SELECT source, searchword, SUM(pageview) AS pageview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s' GROUP BY source, searchword";
			$q = sprintf($qStr
				, $this->tablePrefix('SearchCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod));
			$result = sql_query($q);
			$rows = Array();
			if (sql_num_rows($result)) {
				while($o = sql_fetch_assoc($result)) {
					$rows[] = Array('source' => $o['source'], 'searchword' => $o['searchword'], 'pageview' => $o['pageview']);
				}
			}
			unset($result);
			sql_query(sprintf("DELETE FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'"
				, $this->tablePrefix('SearchCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod)));
			if (!$flgDel) {
				foreach ($rows as $row) {
					sql_query(sprintf("INSERT INTO %s (blogid, period, source, searchword, pageview) VALUES(%s, '%s', '%s', '%s', %s)"
						, $this->tablePrefix('SearchCount')
						, intval($param['b'])
						, sql_real_escape_string($period)
						, sql_real_escape_string($row['source'])
						, sql_real_escape_string($row['searchword'])
						, intval($row['pageview'])));
				}
			}
			
			// AgentCount
			$qStr = "SELECT os, engine, browser, SUM(userview) AS userview FROM %s"
				." WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s' GROUP BY os, engine, browser";
			$q = sprintf($qStr
				, $this->tablePrefix('AgentCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod));
			$result = sql_query($q);
			$rows = Array();
			if (sql_num_rows($result)) {
				while($o = sql_fetch_assoc($result)) {
					$rows[] = Array('os' => $o['os'], 'engine' => $o['engine'], 'browser' => $o['browser'], 'userview' => $o['userview']);
				}
			}
			unset($result);
			sql_query(sprintf("DELETE FROM %s WHERE blogid=%s AND period LIKE '%s%%' AND period<'%s'"
				, $this->tablePrefix('AgentCount')
				, intval($param['b'])
				, sql_real_escape_string($period)
				, sql_real_escape_string($excludePeriod)));
			if (!$flgDel) {
				foreach ($rows as $row) {
					sql_query(sprintf("INSERT INTO %s (blogid, period, os, engine, browser, userview) VALUES(%s, '%s', '%s', '%s', '%s', %s)"
						, $this->tablePrefix('AgentCount')
						, intval($param['b'])
						, sql_real_escape_string($period)
						, sql_real_escape_string($row['os'])
						, sql_real_escape_string($row['engine'])
						, sql_real_escape_string($row['browser'])
						, intval($row['userview'])));
				}
			}
		}
		
		return 'Compress has completed.';
	}
}
?>