package littlemaid.network;

import littlemaid.LittleMaidCore;
import littlemaid.entity.EntityLittleMaid;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncEquipHandler implements IMessageHandler<MessageSyncEquip, IMessage> {

	/**
	 * サーバーから装備品同期のメッセージを受け、クライアントのメイドさんの装備品の同期を行う。
	 */
	@Override
	public IMessage onMessage(MessageSyncEquip message, MessageContext ctx) {

		try {
			World worldIn = LittleMaidCore.proxy.getWorld();
			if (worldIn == null) return null;

			EntityLittleMaid maid = (EntityLittleMaid)worldIn.getEntityByID(message.getMaidEntityID());
			if (maid == null) return null;
			ItemStack[] equips = message.getEquipItems();

			// クライアントのメイドさんインスタンスに装備品を設定する
			maid.inventory.setInventorySlotContents(0, equips[0]);
			for (int i = 1; i <= 4; i++) {
				maid.inventory.setInventorySlotContents(maid.inventory.getSizeInventory() - i, equips[i]);
			}
		} catch (NullPointerException e) {
			//開始直後にgetEntityByID()内でぬるぽが出ることがあるのでもみ消しとく
		}

		return null;
	}

}
