package littlemaid.network;

import littlemaid.LittleMaidCore;
import littlemaid.entity.EntityLittleMaid;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageRequestEquipHandler implements IMessageHandler<MessageRequestEquip, IMessage> {

	/**
	 * クライアントから装備品同期の要求を受けて、サーバーから同期メッセージの送信を行う。
	 */
	@Override
	public IMessage onMessage(MessageRequestEquip message, MessageContext ctx) {
		// サーバー側で実行されることになる
		try {
			World worldIn = ctx.getServerHandler().playerEntity.worldObj;
			if (worldIn == null) return null;

			EntityLittleMaid maid = (EntityLittleMaid)worldIn.getEntityByID(message.getMaidEntityID());

			// メッセージの送信元プレイヤーのクライアントへ装備同期メッセージを送る
			LittleMaidCore.MESSAGE.sendTo(new MessageSyncEquip(maid), ctx.getServerHandler().playerEntity);

		} catch (NullPointerException e) {
			//開始直後にgetEntityByID()内でぬるぽが出ることがあるのでもみ消しとく
		}

		return null;
	}

}
