package littlemaid.gui;

import littlemaid.LittleMaidCore;
import littlemaid.entity.EntityLittleMaid;
import littlemaid.inventory.ContainerLittleMaid;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GuiLittleMaidInventory extends GuiContainer {

	/** The location of the inventory background texture */
	protected static final ResourceLocation maidGuiBackground = new ResourceLocation(LittleMaidCore.MODID, "gui/container/littlemaidinventory.png");

	private EntityPlayer playerIn;
	private EntityLittleMaid maidIn;

	public GuiLittleMaidInventory(EntityPlayer player, EntityLittleMaid maid) {
		super(new ContainerLittleMaid(player, maid));
		this.playerIn = player;
		this.maidIn = maid;
		this.xSize = 176;
		this.ySize = 208;

	}

	@Override
	public void initGui() {
		super.initGui();
	}

	@Override
	public void drawScreen(int mouseX, int mouseY, float partialTicks) {
		super.drawScreen(mouseX, mouseY, partialTicks);
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
		GlStateManager.color(1.0F, 1.0F, 1.0F, 1.0F);
		this.mc.getTextureManager().bindTexture(maidGuiBackground);
		int k = this.guiLeft;
		int l = this.guiTop;
		this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);

		int drawX;
		int drawY;

		// テクスチャのバインド
		this.mc.getTextureManager().bindTexture(icons);

		// HealthValue
		boolean var3 = maidIn.hurtResistantTime / 3 % 2 == 1;
		if (maidIn.hurtResistantTime < 10) {
			var3 = false;
		}
		float maxHealth = maidIn.getMaxHealth();
		float health = maidIn.getHealth();
		for (int li = MathHelper.ceiling_float_int((maxHealth + maidIn.getAbsorptionAmount()) / 2.0F) - 1; li >= 0; --li) { // 持っているハート器の数回す
			int imgPosX = 52; //normal:0 (base 52)
			int var25 = (int) (li / 10.0F); // 何行？
			if (var25 > 0) {
				imgPosX += 108;
			} else if (maidIn.isPotionActive(Potion.poison)) { // 毒々しいハートを使う
				imgPosX += 36;
			} else if (maidIn.isPotionActive(Potion.wither)) { // スケスケハートを使う
				imgPosX += 72;
			}

			drawX = guiLeft + li % 10 * 8 + 85;
			drawY = guiTop + 34;

			// healthが4以下の場合はハートがピクピク動く
			if (health <= 4) {
				drawY += maidIn.getRandom().nextInt(2);
			}

			// 被ダメ直後はハートの枠が出たり消えたり（通常は枠付き）
			this.drawTexturedModalRect(drawX, drawY, var3 ? 25 : 16, 0, 9, 9);


			if (var3) { // 薄い赤色ハート
				if (li * 2 + 1 < health) {
					this.drawTexturedModalRect(drawX, drawY, imgPosX + 18, 0, 9, 9); // 一個
				}
				if (li * 2 + 1 == health) {
					this.drawTexturedModalRect(drawX, drawY, imgPosX + 27, 0, 9, 9); // 半個
				}
			} else { // 赤色ハート
				if (li * 2 + 1 < health) {
					this.drawTexturedModalRect(drawX, drawY, imgPosX, 0, 9, 9); // 一個
				}
				if (li * 2 + 1 == health) {
					this.drawTexturedModalRect(drawX, drawY, imgPosX + 9, 0, 9, 9); // 半個
				}
			}
		}

		// ArmorValue
		int armor = maidIn.getTotalArmorValue();
		drawY = guiTop + 43;
		for (int li = 0; li < 10; ++li) {
			if (armor > 0) {
				drawX = guiLeft + li * 8 + 85;
				if (li * 2 + 1 < armor) {
					this.drawTexturedModalRect(drawX, drawY, 34, 9, 9, 9); // 一個
				}
				if (li * 2 + 1 == armor) {
					this.drawTexturedModalRect(drawX, drawY, 25, 9, 9, 9); // 半個
				}
				if (li * 2 + 1 > armor) {
					this.drawTexturedModalRect(drawX, drawY, 16, 9, 9, 9); // 枠だけ
				}
			}
		}

		// AirValue
		drawY = guiTop + 52;
		if (maidIn.isInsideOfMaterial(Material.water)) {
			int air = maidIn.getAir();
			int stockAir = MathHelper.ceiling_double_int((double) (air - 2) * 10.0D / 300.0D);//2少ない空気
			int useAir = MathHelper.ceiling_double_int((double) air * 10.0D / 300.0D) - stockAir;//差分（２？）

			for (int i = 0; i < stockAir + useAir; ++i) {
				drawX = guiLeft + i * 8 + 85;
				if (i < stockAir) {
					this.drawTexturedModalRect(drawX, drawY, 16, 18, 9, 9);
				} else {
					this.drawTexturedModalRect(drawX, drawY, 25, 18, 9, 9);
				}
			}
		}

	}

	@Override
	protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
		super.drawGuiContainerForegroundLayer(mouseX, mouseY);

		// 画面上の文字描画
		this.fontRendererObj.drawString(this.maidIn.inventory.getDisplayName().getUnformattedText(), 8, 64, 0x404040); // メイドインベントリ名
		this.fontRendererObj.drawString(this.playerIn.inventory.getDisplayName().getUnformattedText(), 8, 114, 0x404040); // プレイヤーインベントリ名

		this.fontRendererObj.drawString(StatCollector.translateToLocal("no name"), 100, 7, 0x404040); // 名前
		this.fontRendererObj.drawString(StatCollector.translateToLocal(LittleMaidCore.MODID + ".role." + this.maidIn.getRole().getName()), 100, 16, 0x404040); // ロール名
		this.fontRendererObj.drawString(StatCollector.translateToLocal(LittleMaidCore.MODID + ".inventory.STATUS"), 85, 26, 0x404040); // ステータス名

		GlStateManager.color(1.0F, 1.0F, 1.0F, 1.0F);

		// カーソルを追っかけるちびモデルの描画
		int maidPosX = 51;
		int maidPosY = 55;
		GuiInventory.drawEntityOnScreen(
			maidPosX, maidPosY, 25,
			this.guiLeft + maidPosX - mouseX, this.guiTop + maidPosY - (this.maidIn.getEyeHeight() * 25) - mouseY,
			this.maidIn);
	}

}
