package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAIWait extends EntityAIBase {

	private EntityLittleMaid theEntity;
	/** If the EntityLittleMaid is waiting. */
	private boolean isWaiting;

	public EntityAIWait(EntityLittleMaid entityIn) {
		this.theEntity = entityIn;
		this.setMutexBits(0);
	}

	/**
	 * Returns whether the EntityAIBase should begin execution.
	 */
	@Override
	public boolean shouldExecute()
	{
		if (!this.theEntity.isContract())
		{
			// 契約してなかったら待機しない
			return false;
		}
		else if (this.theEntity.isInWater() || this.theEntity.isInLava() || this.theEntity.isBurning())
		{
			// 水没、足元マグマ、炎上対策
			return false;
		}
		else if (this.theEntity.fallDistance > 3.0F)
		{
			// 落下対策
			return false;
		}
		else
		{
			EntityLivingBase entitylivingbase = this.theEntity.getOwnerEntity();
			// ご主人様がいて、ご主人様から半径12ブロック以内でご主人様が誰かに攻撃されている場合は待機解除
			if (entitylivingbase != null) {
				if (this.theEntity.getDistanceSqToEntity(entitylivingbase) < 144.0D && entitylivingbase.getAITarget() != null) {
					return false;
				}
			}

			return this.isWaiting;
		}
	}

	/**
	 * Execute a one shot task or start executing a continuous task
	 */
	public void startExecuting()
	{
		this.theEntity.getNavigator().clearPathEntity();
		this.theEntity.setWaiting(true);
	}

	/**
	 * Resets the task
	 */
	public void resetTask()
	{
		this.theEntity.setWaiting(false);
	}

	/**
	 * Sets the waiting flag.
	 */
	public void setWaiting(boolean waiting)
	{
		this.isWaiting = waiting;
	}
}
