package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;

public class EntityAIOwnerHurtTarget extends EntityAITarget {

	EntityLittleMaid theMaid;
	EntityLivingBase theTarget;
	private int lastAttackTime;

	/**
	 * タスクの初期化
	 * @param maid このAIタスクを所持するEntityLittleMaidインスタンス
	 */
	public EntityAIOwnerHurtTarget(EntityLittleMaid maid) {
		super(maid, false);
		this.theMaid = maid;
		this.setMutexBits(0);
	}

	@Override
	public boolean shouldExecute() {
		if (this.theMaid.isContract())
		{
			EntityLivingBase player = this.theMaid.getOwnerEntity();

			if (player == null)
			{
				return false;
			}
			else
			{
				this.theTarget = player.getLastAttacker();
				int i = player.getLastAttackerTime();
				return i != this.lastAttackTime && this.isSuitableTarget(this.theTarget, false);
			}
		}

		return false;
	}

	@Override
	public void startExecuting() {
		this.theMaid.setAttackTarget(this.theTarget);
		EntityLivingBase player = this.theMaid.getOwnerEntity();

		if (player != null)
		{
			this.lastAttackTime = player.getLastAttackerTime();
		}

		super.startExecuting();
	}

}
