package littlemaid.entity;

import littlemaid.LittleMaidCore;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class RenderLittleMaid extends RenderBiped {

	private ResourceLocation textureWild = new ResourceLocation(LittleMaidCore.MODID, "textures/entity/original/littlemaid.png");
	private ResourceLocation[] texture = new ResourceLocation[16];

	/**
	 * 描画するモデルと管理先RenderManagerを指定してRenderを作成する。
	 * @param manager Renderの登録先。通常はMinecraft.getMinecraft().getRenderManager()
	 * @param model レンダリングするModelBipedクラス
	 * @param shadowSize 影の大きさ
	 */
	public RenderLittleMaid(RenderManager manager, ModelBiped model, float shadowSize) {
		super(manager, model, shadowSize, 1.0F);

		this.addLayer(new LayerMaidHeldItem(this));
        this.addLayer(new LayerMaidArmor(this));

	}

	/**
	 * Renderがテクスチャを取得するときに呼び出す。
	 * エンティティの状態をみて渡すテクスチャを替えることができる。
	 */
	@Override
	protected ResourceLocation getEntityTexture(Entity entity) {

		if (entity instanceof EntityLittleMaid) {
			EntityLittleMaid maid = (EntityLittleMaid) entity;

			if (!maid.isContract()) {
				return textureWild;
			}
			else {
				if (texture[maid.getFeature().getMetadata()] == null) {
					texture[maid.getFeature().getMetadata()] = new ResourceLocation(LittleMaidCore.MODID,
							String.format("textures/entity/original/littlemaid_%1$02x.png", maid.getFeature().getMetadata()));
				}
				return texture[maid.getFeature().getMetadata()];
			}
		}
		return textureWild;
	}

	@Override
	public void doRender(EntityLiving entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
		super.doRender(entity, x, y, z, p_76986_8_, partialTicks);

		ItemStack itemstack = entity.getHeldItem();

		if (itemstack == null)
		{
			this.modelBipedMain.heldItemRight = 0;
		}
		else
		{
			this.modelBipedMain.heldItemRight = 1;

			EnumAction enumaction = itemstack.getItemUseAction();

			if (enumaction == EnumAction.BLOCK)
			{
				this.modelBipedMain.heldItemRight = 3;
			}
			else if (enumaction == EnumAction.BOW)
			{
				this.modelBipedMain.aimedBow = true;
			}
		}

	}

}
