	.list ON, EXP
	
; Parser definitions for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.03.01


; Monolithic, not separate assembly:
; context.inc must be included before this file.
;	.include	"context.inc"
;
;	.section	parser, code


; DIGIT   ( c base --- ff )
;         ( c base --- n tf )
;         Translate C in base, yielding a translation valid flag.  If the
;         translation is not valid in the specified base, only the false
;         flag is returned.
;
	HEADER	DIGIT, xDIGIT
	mov.l	@(NATURAL_SIZE,fSP), r0	; Vrbg
	mov.b	#"0", r1
	cmp/ge	r1, r0 		; character (r0) >= "0"
	bf	xDIGITno
	add.l	#-"0", r0
	mov.b	#9, r1
	cmp/gt	r1, r0		; digit (r0) > 9
	bf	xDIGITbase
	mov.b	#"A"-"0", r1
	cmp/ge	r1, r0		; was it between "9" and "A"?
	bf	xDIGITno
	add.l	#"9"-"A"+1, r0
xDIGITbase:
	mov.l	@fSP, r1
	cmp/ge	r1, r0		; digit (r0) >= base
	bt xDIGITno
	mov.l	r0, @(NATURAL_SIZE,fSP)
	mov.b	#-1, r0 	; store the converted digit
	rts
	mov.l	r0, @fSP	; set the flag on our way out
;
xDIGITno:
	mov.b	#0, r0
	add.l	#NATURAL_SIZE, fSP
	rts
	mov.l	r0, @fSP	; set the flag on our way out




