
#include "shareCookie.h"
#define WINDEBUGER_NOPRINTING
#define _CRT_SECURE_NO_WARNINGS 1			//vc++̂Ȍx
#define  _CRT_NON_CONFORMING_SWPRINTFS 1	//vc++̂Ȍx
#include <shlobj.h>
#include <time.h>
#include <Wininet.h>
#include <Iepmapi.h>
#include <sqlite3\sqlite3.h>
#include <sqlite3\sqliteManager.h>

#include <qwerty\qwerty_common.h>
#include <qwerty\windebuger.h>

static TCHAR ieCookiePath[_MAX_PATH];					//IẼNbL[pX
static TCHAR ieCookieSecPath[_MAX_PATH];				//IEZLeB[h̃pX
static WCHAR fireFoxCookiePath[_MAX_PATH];				//t@CAtHbNX̃NbL[̃pX
//static sqlite3 *firefoxCookie;						//t@CAtHbNX̃NbL[DB
//static sqlite3_stmt *firefoxCookieStmt;				//t@CAtHbNX̃NbL[擾pXe[gg
//static CRITICAL_SECTION firefoxCs;					//t@CAtHbNX̃NbL[擾pNeBJZNV


static WCHAR googleChromeCookiePath[_MAX_PATH];		//O[ON[̃NbL[̃pX
//static sqlite3 *googleChromeCookie;					//O[ON[̃NbL[DB
//static sqlite3_stmt *googleChromeCookieStmt;		//O[ON[̃NbL[擾pXe[gg
//static CRITICAL_SECTION googleChromeCs;				//O[ON[̃NbL[擾pNeBJZNV


static WCHAR safariCookiePath[_MAX_PATH];			//SafarĩNbL[pX
static WCHAR operaCookiePath[_MAX_PATH];			//OperãNbL[pX

typedef COOKIE_RESULT (*SelfParseCookieCallBack)(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein);

typedef COOKIE_RESULT (*ParseCookieCallBack)(sqlite3_stmt *stmt,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein);

///
///N[ƃt@CAtHbNX̋ʏ
///
static INLINE UINT checkDBAndStmt(sqlite3 **db,sqlite3_stmt **stmt,LPCWSTR path,LPCWSTR sql);
static INLINE VOID cookieStepExec(sqlite3_stmt *stmt,LPWSTR cooki,SIZE_T bufSize,COOKIE_RESULT *result);


///
///K̃uEU^Cv擾
///
static BROWSERTYPE getDefaultBrowserType();


///
///[U[ʂ̋K̃uEU^Cv擾
///
static BROWSERTYPE getDefaultBrowserTypeInvidialUser();

///
///[Ŝ̋K̃uEU^Cv擾
///
static BROWSERTYPE getDefaultBrowserTypeLocalMachine();

///
///͂ŉ͂ꍇ̋ʏ
///
static INLINE COOKIE_RESULT SelfParseCookie(LPCWSTR cookieFilePath,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein,SelfParseCookieCallBack callBack);

///
///C^[lbgGNXv[[̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieInternetExplorer(LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein,BOOL isIE);

///
///C^[lbgGNXv[[̃NbL[t@C͂ŉ
///
static INLINE COOKIE_RESULT GetCookieInternetExplorerSelfParse(LPCWSTR dir,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein);

///
///͉͎̃R[obN֐
///
static COOKIE_RESULT selfParseIECallBack(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein);

static COOKIE_RESULT getCookieSQLite(LPCWSTR path,LPCWSTR sql,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein,ParseCookieCallBack sqlCallBack,SelfParseCookieCallBack selfCallBack);

///
///t@CAtHbNX̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieFireFoxSQLite(sqlite3_stmt *stmt,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein);


///
///t@CAtHbNX͂ŉ
///
static INLINE COOKIE_RESULT GetCookieFireFoxSelf(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein);

///
///O[ON[̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieGoogleChromeSQLite(sqlite3_stmt *stmt,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein);

///
///O[ON[͂ŉ
///
static INLINE COOKIE_RESULT GetCookieGoogleChromeSelf(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein);

///
///IỹNbL[擾
///
static INLINE COOKIE_RESULT GetCookieOpera(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein);

///
///Tt@̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieSafari(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein);


///
///WXgK̃uEU^Cv擾
///
static INLINE BROWSERTYPE getDefaultBrowserReg(HKEY hTopKey,LPCWSTR path,LPCWSTR sectionName);

///
///NbL[Rs[p̃pX擾
///
static INLINE BOOL CookieFileCopy(LPCWSTR sourceFileName,LPWSTR pathBuf,int bufSize);


///
///uEUuEU^Cv擾
///
static INLINE BROWSERTYPE browserNameToBrowserType(LPCWSTR browserName);

const LPCWSTR  FIREFOX_GET_COOKIE_SQL = L"SELECT a.name, a.value FROM moz_cookies a WHERE a.name = ?1 AND a.baseDomain = ?2 ";						//t@CAtHbNXNbL[擾pSQL


const LPCWSTR GOOGLECHROME_GET_COOKIE_SQL = L"SELECT a.name,a.value FROM cookies a WHERE a.name = ?1 AND (a.host_key = ?2 OR a.host_key = ?3)";	//O[ON[NbL[擾pSQL .tĂ̂ƕtĂȂ̂̂łƂ肦EƂɂBK킩΂X}[gɂ


VOID InitializeShareCookie(LPCWSTR appDataPath,LPCWSTR localAppDataPath){

	//IE̐ݒ
	
	//NbL[tH_
	SHGetFolderPathW(0,CSIDL_COOKIES,0,SHGFP_TYPE_CURRENT,ieCookiePath);
	_tcscat(ieCookiePath,TEXT("\\"));
	_stprintf(ieCookieSecPath,TEXT("%s%s"),ieCookiePath,TEXT("Low\\"));
			


	//FireFox̐ݒ
	{

		WCHAR fireFoxProfilesPath[_MAX_PATH];
		WCHAR fireFoxCookieTmp[_MAX_PATH];
		LPWSTR fireFoxCookieFileName = L"cookies.sqlite";
		

	
		LPWSTR index;
		

		wcscpy(fireFoxProfilesPath,appDataPath);
		wcscat(fireFoxProfilesPath,L"Mozilla\\Firefox\\profiles.ini");

		GetPrivateProfileStringW(L"Profile0",L"Path",L"",fireFoxCookieTmp,sizeof(fireFoxCookieTmp) / sizeof(fireFoxCookieTmp[0]),fireFoxProfilesPath);

		for(index = wcsstr(fireFoxCookieTmp,L"/");index != NULL ;index = wcsstr(fireFoxCookieTmp,L"/")){

			index[0] = L'\\';


		}

		switch(GetPrivateProfileIntW(L"Profile0",L"IsRelative",2,fireFoxProfilesPath)){

		case 0:

			wcscpy(fireFoxCookiePath,fireFoxCookieTmp);
			break;

		case 1:
			wcscpy(fireFoxCookiePath,appDataPath);
			wcscat(fireFoxCookiePath,L"Mozilla\\Firefox\\");
			wcscat(fireFoxCookiePath,fireFoxCookieTmp);
			wcscat(fireFoxCookiePath,L"\\");
			wcscat(fireFoxCookiePath,fireFoxCookieFileName);

			break;

		default:
			

			break;




		}
		/*
		if(SqliteManager_open(&firefoxCookie,fireFoxCookiePath,SQLITE_OPEN_READONLY,0) == SQLITE_OK){

			rc = SqliteManager_prepare( firefoxCookie, WTEXT(FIREFOX_GET_COOKIE_SQL), -1, &firefoxCookieStmt,(void**)NULL);
			dumpln(TEXT("firefox̃NbL[t@CJ"));
		}
		*/
		//checkDBAndStmt(&firefoxCookie,&firefoxCookieStmt,fireFoxCookiePath,WTEXT(FIREFOX_GET_COOKIE_SQL));

		//InitializeCriticalSection(&firefoxCs);
	}
	
	//GoogleChrome̐ݒ
	{

		wcscpy(googleChromeCookiePath,localAppDataPath);
		wcscat(googleChromeCookiePath,L"Google\\Chrome\\User Data\\Default\\Cookies");


		
		/*
		if(SqliteManager_open(&googleChromeCookie,googleChromeCookiePath,SQLITE_OPEN_READONLY,0) == SQLITE_OK){


			rc = SqliteManager_prepare( googleChromeCookie, WTEXT(GOOGLECHROME_GET_COOKIE_SQL), -1, &googleChromeCookieStmt,(void**)NULL);
			dumpln(TEXT("chromẽNbL[t@CJ"));
		}
		*/
		//checkDBAndStmt(&googleChromeCookie,&googleChromeCookieStmt,googleChromeCookiePath,WTEXT(GOOGLECHROME_GET_COOKIE_SQL));

		//InitializeCriticalSection(&googleChromeCs);







	}


	//Tt@̐ݒ
	
	wcscpy(safariCookiePath,appDataPath);
	wcscat(safariCookiePath,L"Apple Computer\\Safari\\Cookies\\Cookies.binarycookies");

	//Opera̐ݒ
	//
	wcscpy(operaCookiePath,appDataPath);
	wcscat(operaCookiePath,L"Opera\\Opera\\cookies4.dat");

	return;
}

VOID FinalizeShareCookie(){

	
	
	



	return;
}

VOID ShareCookieUnitTest(){

	TCHAR cookieBuf[_MAX_PATH];
	SIZE_T cookieBufSize = ARRAY_LENGTH(cookieBuf);
	LPCTSTR key = TEXT("user_session");
	LPCTSTR domein = TEXT("nicovideo.jp");
	check(GetCookieInternetExplorerSelfParse(ieCookiePath,cookieBuf,cookieBufSize,key,domein) == COOKIE_ERR_OK,TEXT("ieʏNbL[擾Ɏs܂"));
	dumpln(TEXT("ienormal:%s"),cookieBuf);

	check(GetCookieInternetExplorerSelfParse(ieCookieSecPath,cookieBuf,cookieBufSize,key,domein) == COOKIE_ERR_OK,TEXT("ieZLeB[hNbL[擾Ɏs܂"));
	dumpln(TEXT("iesec:%s"),cookieBuf);


	dumpln(TEXT("test"));

	check(SelfParseCookie(fireFoxCookiePath,cookieBuf,cookieBufSize,key,domein,GetCookieFireFoxSelf) == COOKIE_ERR_OK,TEXT("t@CAtHbNX͉͂Ɏs܂"));
	dumpln(TEXT("firefox:%s"),cookieBuf);


	check(SelfParseCookie(googleChromeCookiePath,cookieBuf,cookieBufSize,key,domein,GetCookieGoogleChromeSelf) == COOKIE_ERR_OK,TEXT("N[͉͂Ɏs܂"));
	dumpln(TEXT("chrome:%s"),cookieBuf);

	return;
}

static INLINE BOOL CookieFileCopy(LPCWSTR sourceFileName,LPWSTR pathBuf,int bufSize){

	WCHAR tempBuff[_MAX_PATH];
	LPWSTR timestartPtr = NULL;
	BOOL result = FALSE;
	int tmpnamesize = 0;
	struct tm nowtm;
	time_t nowtime = time(NULL);
	SHGetFolderPathW(0,CSIDL_TEMPLATES,0,SHGFP_TYPE_CURRENT,tempBuff);
	tmpnamesize = wcslen(tempBuff);
	timestartPtr = tempBuff + tmpnamesize;
	nowtm = *localtime(&nowtime);
	if(_tcsftime(timestartPtr,bufSize - tmpnamesize,L"\\cookie_buff_%Y%m%d%H&M%S",&nowtm) > 0){

		result = CopyFile(sourceFileName,tempBuff,TRUE);

		if(result != FALSE)wcscpy(pathBuf,tempBuff);
	}
	


	return result;
}


COOKIE_RESULT GetCookie(BROWSERTYPE browserType,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein){

	//uEU^Cvɂs֐肷

	switch(browserType){

		//IȄꍇ
	case BT_INTERNET_EXPLORER:


		return GetCookieInternetExplorer(cookie,bufSize,key,domein,TRUE);

		//t@CAtHbNX̏ꍇ
	case BT_FIRE_FOX:

		return  getCookieSQLite(fireFoxCookiePath,FIREFOX_GET_COOKIE_SQL,cookie,bufSize,key,domein,GetCookieFireFoxSQLite,GetCookieFireFoxSelf);

		//O[ON[̏ꍇ
	case BT_GOOGLE_CHROME:


		return  getCookieSQLite(googleChromeCookiePath,GOOGLECHROME_GET_COOKIE_SQL,cookie,bufSize,key,domein,GetCookieGoogleChromeSQLite,GetCookieGoogleChromeSelf);

		//Iy̏ꍇ
	case BT_OPERA:

		return SelfParseCookie(operaCookiePath,cookie,bufSize,key,domein,GetCookieOpera);
		

		//Tt@̏ꍇ
	case BT_SAFARI:
		return SelfParseCookie(safariCookiePath,cookie,bufSize,key,domein,GetCookieSafari);
		

		//IER|[lg̏ꍇ
	case BT_IE_COMPONENT:

		return GetCookieInternetExplorer(cookie,bufSize,key,domein,FALSE);

		//K̃uEU

	case BT_DEFAULT:

		return GetCookie(getDefaultBrowserType(),cookie,bufSize,key,domein);

		//uEU^Cvݒ肳ĂȂꍇ
	case BT_NOSETTING:

		return  COOKIE_ERR_BROWSERTYPE_NOSETTING;




		//`̃uEU^Cvw肳ꂽꍇ
	default:

		return  COOKIE_ERR_UNDEFINED_BROWSERTYPE;

	}





}

///
///C^[lbgGNXv[[̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieInternetExplorer(LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein,BOOL isIE){

#define GET_IE_COOKIE_URL_MAXLENGTH			LENGTH_512		//urlobt@
	
	HKEY hKey = (HKEY)NULL;									//WXgL[
	COOKIE_RESULT result = COOKIE_ERR_OK;						//ʃR[h
	DWORD data;												//WXgli[ϐ
	DWORD size = sizeof(data);								//datãTCY
	HRESULT cookieResult;									//NbL[擾ʃR[h
	BOOL  isProtectedMode = FALSE;							//ی샂[htO
	WCHAR url[GET_IE_COOKIE_URL_MAXLENGTH];					//urlobt@
	SIZE_T bufSizeTemp = bufSize;
	//IEIER|[lg𔻒
	if(isIE){

		//WXgL[ǂݎpŃI[v
		if(RegOpenKeyEx(HKEY_CURRENT_USER,TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\3"),0,KEY_READ,&hKey) != ERROR_SUCCESS){
			return COOKIE_ERR_INTERNETOPTION_NOTOPEN;
		}





		//ی샂[h̏Ԃ擾
		switch(RegQueryValueEx(hKey,TEXT("2500"),(LPDWORD)NULL,(LPDWORD)NULL,(LPBYTE)&data,&size)){


			//ی샂[h擾ɐ
		case ERROR_SUCCESS:

			//擾l0ꍇAی샂[htOTRUEɂ
			isProtectedMode = data == 0;
			
			break;

		
			//ی샂[h擾ɎsꍇłWXglȂG[ł΁AXPȑOOSƔ肳Aی샂[hFALSÊ܂܂ɂ
		case ERROR_FILE_NOT_FOUND:

			break;

			//LG[ȊÕG[ꍇANbL[擾sƂ
		default:
		
			result = COOKIE_ERR_PROTECTIONMODE_READFAILD;
			goto end;

		}//switch(RegQueryValueEx(hKey,TEXT("2500"),(LPDWORD)NULL,(LPDWORD)NULL,(LPBYTE)&data,&size))
	}//if(isIE)



	
	

	//nꂽurl̒GET_IE_COOKIE_URL_MAXLENGTHꍇAURL񂪒G[R[hresultɂ
	if(wcslen(domein) >= GET_IE_COOKIE_URL_MAXLENGTH){
		result = COOKIE_ERR_DETAIL_URL_TOOBIG;


	} else {
		//hCurlݒ
		wcscpy(url,L"http://");
		wcscat(url,domein);

		//ی샂[htOTRUEȂIEGetProtectedModeCookieŃNbL[̒l擾
		if(isProtectedMode == TRUE){

			cookieResult = IEGetProtectedModeCookie(url,key,cookie,&bufSize,0);
			

		//ی샂[htOFALSEȂInternetGetCookieExŃNbL[̒l擾
		}else{
			
			

			if(InternetGetCookie(url,key,cookie,&bufSize)== TRUE){

				cookieResult = S_OK;
			}else {
				cookieResult = GetLastError();
			}
			/*
			if(InternetGetCookieEx(url,key,cookie,&bufSize,0,NULL) == TRUE){

				cookieResult = S_OK;
			}else {
				cookieResult = GetLastError();
			}
			*/
				
			
		}
		
		
			

		//ʃR[h
		if(SUCCEEDED(cookieResult) == TRUE){


			//擾NbL[̃TCY0傫΁AresultsɐI̒lݒ
			if(bufSize > 0){

				result = COOKIE_ERR_OK;

			//擾NbL[̃TCY0̏ꍇA͂ŉ͂
			} else {
				result = GetCookieInternetExplorerSelfParse(isProtectedMode == TRUE ? ieCookieSecPath : ieCookiePath,cookie,bufSizeTemp,key,domein);

			}//if(bufSize > 0)

		//ʃR[hIł͂ȂꍇresultsɃG[̏ڍׂݒ
		} else {
	
			
			errprint(TEXT("ieCookieGetError,hresult:%d"),cookieResult);
			switch(cookieResult){
				//obt@Ȃꍇ̃G[winerror.hɐݒ肳ĂȂ̂ł̂܂܂̒lŔԂ悤ɂĂǂɒ`Ă邩Ȃ̂Ō`}Nɒu
			case 0x8007007a:

				result = COOKIEERR_DETAIL_RESULT_TOOBIG;

				break;

				//`̃G[ꍇ


			
			default:

				

				result = COOKIE_ERR_UNKNOWN;

				break;

			}//switch(cookieResult)
		}//if(cookieResult == ERROR_SUCCESS)
	}//if(wcslen(domeins[index]) >= GET_IE_COOKIE_URL_MAXLENGTH)

	wincheck(cookieResult);


end:
	//JWXg
	RegCloseKey(hKey);

	return result;
}

static INLINE COOKIE_RESULT GetCookieInternetExplorerSelfParse(LPCWSTR dir,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein){


	COOKIE_RESULT result = COOKIE_ERR_DETAIL_NOTFOUND;
	TCHAR seachFormat[_MAX_PATH];
	TCHAR cookieFileBuf[_MAX_PATH];
	WIN32_FIND_DATA findData;
	HANDLE hFindFile = NULL;
	_stprintf(seachFormat,TEXT("%s%s"),dir,TEXT("?*.txt"));

	hFindFile = FindFirstFile(seachFormat,&findData);

	do{
		if(hFindFile == INVALID_HANDLE_VALUE)goto notfind;
		
		if((findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FALSE){
			
			_stprintf(cookieFileBuf,TEXT("%s%s"),dir,findData.cFileName);
			result = SelfParseCookie(cookieFileBuf,cookie,bufSize,key,domein,selfParseIECallBack);

			if(result != COOKIE_ERR_DETAIL_NOTFOUND)goto end;
		
		}

		

	}while(FindNextFile(hFindFile,&findData));

end:

	FindClose(hFindFile);
	return result;

notfind:
	result =  COOKIE_ERR_DETAIL_NOTFOUND;
	goto end;	
}

static COOKIE_RESULT selfParseIECallBack(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein){

	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;

	CHAR mb_key[_MAX_PATH];
	CHAR mb_domein[_MAX_PATH];
	CHAR cookie_mbBuff[_MAX_PATH];
	DWORD cookieBufSize = 0;
	LPCSTR keyStartPointer = NULL;
	LPCSTR cookieStartPointer = NULL;
	LPCSTR cookieEndPointer = NULL;
	LPCSTR astorStartPointer = NULL;
	LPCSTR domeinStartPointer = NULL;

	if(ARRAY_LENGTH(mb_key) < GetLenToMB(CP_UTF8,key)){
		
		goto keybuffbigerr;

	} else if(ARRAY_LENGTH(mb_domein) < GetLenToMB(CP_UTF8,domein) ){

		goto domeinbuffbigerr;

	}


	WideToMB(CP_UTF8,key,mb_key,ARRAY_LENGTH(mb_key));
	WideToMB(CP_UTF8,domein,mb_domein,ARRAY_LENGTH(mb_domein));

	keyStartPointer = strstr(targetString,mb_key);

	if(keyStartPointer == NULL)goto notfound;
	cookieStartPointer = strstr(keyStartPointer,"\n");

	if(cookieStartPointer == NULL)goto notfound;

	cookieStartPointer++;

	cookieEndPointer = strstr(cookieStartPointer,"\n");

	astorStartPointer = strstr(cookieEndPointer+1,"*");
	domeinStartPointer = strstr(cookieEndPointer+1,mb_domein);
	if(astorStartPointer == NULL || domeinStartPointer == NULL || astorStartPointer <= domeinStartPointer)goto notfound;
	cookieBufSize = cookieEndPointer - cookieStartPointer;
	strncpy(cookie_mbBuff,cookieStartPointer,cookieBufSize);
	cookie_mbBuff[cookieBufSize]='\0';
	if(((INT_PTR)bufSize) < GetLenToWide(CP_UTF8,cookie_mbBuff) + wcslen(key) + 1){

		goto cookiebuffbigerr;
	}
	wcscpy(cookie,key);
	cookie += wcslen(cookie);
	cookie[0] = L'=';
	cookie++;

	MBToWide(CP_UTF8,cookie_mbBuff,cookie,bufSize);
	result = COOKIE_ERR_OK;

end:

	return result;

keybuffbigerr:
	result =COOKIE_ERR_DETAIL_KEY_TOOBIG;
	goto end;


domeinbuffbigerr:
	result = COOKIE_ERR_DETAIL_DOMEIN_TOOBIG;
	goto end;


notfound:
	result = COOKIE_ERR_DETAIL_NOTFOUND;
	goto end;

cookiebuffbigerr:
	result = COOKIE_ERR_DETAIL_DOMEIN_TOOBIG;
	goto end;
}

///
///SQLn̉͗p֐
///

static COOKIE_RESULT getCookieSQLite(LPCWSTR path,LPCWSTR sql,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein,ParseCookieCallBack sqlCallBack,SelfParseCookieCallBack selfCallBack){

	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;
	UINT dbchekresult = 0;
	sqlite3 *db = NULL;
	sqlite3_stmt *stmt = NULL;
	BOOL copyFlag = FALSE;
	WCHAR cookieFilePathBuff[_MAX_PATH] ={0};
	dbchekresult = checkDBAndStmt(&db,&stmt,path,sql);

	if(dbchekresult != 0){
		db = NULL;
		stmt = NULL;
		copyFlag = CookieFileCopy(path,cookieFilePathBuff,ARRAY_LENGTH(cookieFilePathBuff));
		dbchekresult = checkDBAndStmt(&db,&stmt,path,sql);
	}

	if(dbchekresult == 0){

		result = sqlCallBack(stmt,cookie,bufSize,key,domein);

	}

	if(result != COOKIE_ERR_OK){

		SelfParseCookie(path,cookie,bufSize,key,domein,selfCallBack);

	}


	sqlite3_finalize(stmt);
	SqliteManager_close(&db);

	if(copyFlag != FALSE)DeleteFile(cookieFilePathBuff);

	return result;
}

///
///t@CAtHbNX̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieFireFoxSQLite(sqlite3_stmt *stmt,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein){

	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;						//ʃR[h
	LPCWSTR pName = (LPCWSTR)NULL;						//O̒lmۂꎞIȃ|C^
	LPCWSTR pValue = (LPCWSTR)NULL;						//value̒lmۂꎞIȃ|C^
	
	

	

	

	

	switch(sqlite3_bind_text16(stmt,1,key,-1,SQLITE_STATIC)){

	case SQLITE_OK:


		switch(sqlite3_bind_text16(stmt,2,domein,-1,SQLITE_STATIC)){

		case SQLITE_OK:

			cookieStepExec(stmt,cookie,bufSize, &result);

			


			break;

		case SQLITE_TOOBIG:

			result = COOKIE_ERR_DETAIL_URL_TOOBIG;


			break;

		default:

			result = COOKIE_ERR_UNKNOWN;


			break;

		}//switch(sqlite3_bind_text16(firefoxCookieStmt,2,domeins[index],sizeof(WCHAR) * (wcslen(key[index]) + 1),SQLITE_STATIC))




		break;//SQLITE_OK

	case SQLITE_TOOBIG:

		result = COOKIE_ERR_DETAIL_KEY_TOOBIG;

		break;

	default:

		result = COOKIE_ERR_UNKNOWN;


		break;

	}//switch(sqlite3_bind_text16(firefoxCookieStmt,1,key[index],sizeof(WCHAR) * (wcslen(key[index]) + 1),SQLITE_STATIC))








	return result;
}


static INLINE COOKIE_RESULT GetCookieFireFoxSelf(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein){
	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;	
	CHAR mb_key[_MAX_PATH];
	CHAR mb_domein[_MAX_PATH];
	CHAR mb_cookie[_MAX_PATH];
	CHAR mb_domein_key[(sizeof(mb_key) + sizeof(mb_domein))/sizeof(CHAR)];
	CHAR mb_end_domein[_MAX_PATH] = ".";
	LPCSTR startPointer;
	LPCSTR endPointer;


	if(ARRAY_LENGTH(mb_key) < GetLenToMB(CP_UTF8,key)){
		
		goto keybuffbigerr;

	} else if(ARRAY_LENGTH(mb_domein) < GetLenToMB(CP_UTF8,domein) ){

		goto domeinbuffbigerr;

	}


	WideToMB(CP_UTF8,key,mb_key,ARRAY_LENGTH(mb_key));
	WideToMB(CP_UTF8,domein,mb_domein,ARRAY_LENGTH(mb_domein));

	strcpy(mb_domein_key,mb_domein);
	strcat(mb_domein_key,mb_key);
	strcat(mb_end_domein,mb_domein);
	for(;targetString < targetEndPointer;targetString += strlen(targetString)+2){
		startPointer = strstr(targetString,mb_domein_key);
		
		if(startPointer != NULL ){
			endPointer = strstr(startPointer,mb_end_domein);
			if(endPointer != NULL){
				startPointer += strlen(mb_domein_key);
				if(startPointer < endPointer){
					int cookiesize = endPointer - startPointer;
					if(cookiesize + 1 > ARRAY_LENGTH(mb_cookie))goto cookiebuferr;
					strncpy(mb_cookie,startPointer,cookiesize);
					mb_cookie[cookiesize] = '\0';
					if(((int)bufSize) < GetLenToWide(CP_UTF8,mb_cookie) + 1)goto cookiebuferr;

					MBToWide(CP_UTF8,mb_cookie,cookie,bufSize);
					result = COOKIE_ERR_OK;
					goto end;
				}
			}
		}
	}
	result = COOKIE_ERR_DETAIL_NOTFOUND;

end:

	
	return result;

keybuffbigerr:
	result = COOKIE_ERR_DETAIL_KEY_TOOBIG;
	goto end;

domeinbuffbigerr:
	result = COOKIE_ERR_DETAIL_DOMEIN_TOOBIG;
	goto end;

cookiebuferr:
	result = COOKIEERR_DETAIL_RESULT_TOOBIG;
	goto end;
}



///
///O[ON[̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieGoogleChromeSQLite(sqlite3_stmt *stmt,LPWSTR cookie,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein){



	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;					//ʃR[h
	LPCWSTR pName = (LPCWSTR)NULL;						//O̒lmۂꎞIȃ|C^
	LPCWSTR pValue = (LPCWSTR)NULL;						//value̒lmۂꎞIȃ|C^
	WCHAR host_key2Buf[LENGTH_DOMEIN] = {L"."};						//hĈQ̈
	LPWSTR pHostKey = &host_key2Buf[1];
	


	

	




	//Xe[ggɃp^ݒ1
	switch(sqlite3_bind_text16(stmt,1,key,-1,SQLITE_STATIC)){

	case SQLITE_OK:

		//Xe[ggɃp^ݒ2
		switch(sqlite3_bind_text16(stmt,2,domein,-1,SQLITE_STATIC)){

		case SQLITE_OK:

			if(wcslen(domein) > LENGTH_DOMEIN -2){

				result = COOKIE_ERR_DETAIL_URL_TOOBIG;
				

				break;

			}

			wcscpy(pHostKey,domein);						//̂͂łH

			//Xe[ggɃp^ݒ3
			switch(sqlite3_bind_text16(stmt,3,host_key2Buf,-1,SQLITE_STATIC)){

			case SQLITE_OK:

		
				//NbL[擾SQLs
				cookieStepExec(stmt,cookie,bufSize,&result);

				


				break;


				case SQLITE_TOOBIG:

					result = COOKIE_ERR_DETAIL_URL_TOOBIG;


					break;

				default:
				
					result = COOKIE_ERR_UNKNOWN;


				break;

			}//switch(sqlite3_bind_text16(googleChromeCookieStmt,3,domeins[index],-1,SQLITE_STATIC))



			break;

		case SQLITE_TOOBIG:

			result = COOKIE_ERR_DETAIL_URL_TOOBIG;


			break;

		default:
				
			result = COOKIE_ERR_UNKNOWN;


			break;

		}//switch(sqlite3_bind_text16(googleChromeCookieStmt,2,domeins[index],sizeof(WCHAR) * (wcslen(key[index]) + 1),SQLITE_STATIC))




		break;//SQLITE_OK

	case SQLITE_TOOBIG:

		result = COOKIE_ERR_DETAIL_KEY_TOOBIG;


		break;

	default:

		result = COOKIE_ERR_UNKNOWN;


	}//switch(sqlite3_bind_text16(googleChromeCookieStmt,1,key[index],sizeof(WCHAR) * (wcslen(key[index]) + 1),SQLITE_STATIC))




	return result;
}

static INLINE COOKIE_RESULT GetCookieGoogleChromeSelf(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein){

	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;	
	CHAR mb_key[_MAX_PATH];
	CHAR mb_domein[_MAX_PATH];
	CHAR mb_cookie[_MAX_PATH];
	CHAR mb_domein_key[(sizeof(mb_key) + sizeof(mb_domein))/sizeof(CHAR)];
	LPCSTR endString = "/";
	LPCSTR startPointer;
	LPCSTR endPointer;


	if(ARRAY_LENGTH(mb_key) < GetLenToMB(CP_UTF8,key)){
		
		goto keybuffbigerr;

	} else if(ARRAY_LENGTH(mb_domein) < GetLenToMB(CP_UTF8,domein) ){

		goto domeinbuffbigerr;

	}


	WideToMB(CP_UTF8,key,mb_key,ARRAY_LENGTH(mb_key));
	WideToMB(CP_UTF8,domein,mb_domein,ARRAY_LENGTH(mb_domein));

	strcpy(mb_domein_key,mb_domein);
	strcat(mb_domein_key,mb_key);

	for(;targetString < targetEndPointer;targetString += strlen(targetString)+2){
		startPointer = strstr(targetString,mb_domein_key);
		
		if(startPointer != NULL ){
			endPointer = strstr(startPointer,endString);
			if(endPointer != NULL){
				startPointer += strlen(mb_domein_key);
				if(startPointer < endPointer){
					int cookiesize = endPointer - startPointer;
					if(cookiesize + 1 > ARRAY_LENGTH(mb_cookie))goto cookiebuferr;
					strncpy(mb_cookie,startPointer,cookiesize);
					mb_cookie[cookiesize] = '\0';
					if(((int)bufSize) < GetLenToWide(CP_UTF8,mb_cookie) + 1)goto cookiebuferr;

					MBToWide(CP_UTF8,mb_cookie,cookie,bufSize);
					result = COOKIE_ERR_OK;
					goto end;
				}
			}
		}
	}
	result = COOKIE_ERR_DETAIL_NOTFOUND;

end:

	
	return result;

keybuffbigerr:
	result = COOKIE_ERR_DETAIL_KEY_TOOBIG;
	goto end;

domeinbuffbigerr:
	result = COOKIE_ERR_DETAIL_DOMEIN_TOOBIG;
	goto end;

cookiebuferr:
	result = COOKIEERR_DETAIL_RESULT_TOOBIG;
	goto end;
}

///
///IỹNbL[擾
///
static INLINE COOKIE_RESULT GetCookieOpera(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookies,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein){

	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;
	CHAR mb_key[_MAX_PATH];
	CHAR mb_domein[_MAX_PATH];
	LPCSTR cookiePointer;
	LPCSTR keyPointer;

	if(ARRAY_LENGTH(mb_key) < GetLenToMB(CP_UTF8,key)){
		
		goto keybuffbigerr;

	} else if(ARRAY_LENGTH(mb_domein) < GetLenToMB(CP_UTF8,domein) ){

		goto domeinbuffbigerr;

	}


	WideToMB(CP_UTF8,key,mb_key,ARRAY_LENGTH(mb_key));
	WideToMB(CP_UTF8,domein,mb_domein,ARRAY_LENGTH(mb_domein));
	strstr(mb_domein,".jp")[0] = '\0';

	for(;targetString < targetEndPointer;targetString += strlen(targetString) + 1){

		
		if(strncmp(targetString + 1,mb_domein,strlen(mb_domein)) == 0){
			
			
			
			
			
			for(keyPointer = (targetString + strlen(targetString) + 1);keyPointer < targetEndPointer;keyPointer = (keyPointer + strlen(keyPointer) + 1)){
				if(strstr(keyPointer,mb_key) !=NULL){
					CHAR cookie_mbBuff[_MAX_PATH];
					UINT_PTR length;
					cookiePointer = keyPointer+ strlen(keyPointer) + 1;
					length = strlen(cookiePointer) -2;
					strncpy(cookie_mbBuff,cookiePointer+1,length);
					cookie_mbBuff[length] = '\0';
					if(((INT_PTR)bufSize) < GetLenToWide(CP_UTF8,cookie_mbBuff) + wcslen(key) + 1){

						goto cookiebuffbigerr;
					}
					wcscpy(cookies,key);
					cookies += wcslen(cookies);
					cookies[0] = L'=';
					cookies++;

					MBToWide(CP_UTF8,cookie_mbBuff,cookies,bufSize);
					result = COOKIE_ERR_OK;
					goto end;
				}
			}
			
		}

	}

end:


	return result;


keybuffbigerr:
	result = COOKIE_ERR_DETAIL_URL_TOOBIG;
	goto end;

domeinbuffbigerr:
	result = COOKIE_ERR_DETAIL_DOMEIN_TOOBIG;
	goto end;

cookiebuffbigerr:
	result = COOKIEERR_DETAIL_RESULT_TOOBIG;
	goto end;
}

///
///Tt@̃NbL[擾
///
static INLINE COOKIE_RESULT GetCookieSafari(LPCSTR targetString,LPCSTR targetEndPointer,LPWSTR cookies,SIZE_T bufSize, LPCWSTR key,LPCWSTR domein){
	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;
	CHAR mb_key[_MAX_PATH] = "A";
	CHAR mb_domein[_MAX_PATH] = ".";
	LPCSTR cookiePointer;
	LPCSTR domeinPointer;
	SIZE_T mb_keyLen;

	if(ARRAY_LENGTH(mb_key)-1 < GetLenToMB(CP_UTF8,key)){
		
		goto keybuffbigerr;

	} else if(ARRAY_LENGTH(mb_domein) - 1 < GetLenToMB(CP_UTF8,domein) ){

		goto domeinbuffbigerr;

	}

	WideToMB(CP_UTF8,key,mb_key + 1,ARRAY_LENGTH(mb_key) - 1);
	WideToMB(CP_UTF8,domein,mb_domein + 1,ARRAY_LENGTH(mb_domein) - 1);
	mb_keyLen = strlen(mb_key);
	
	for(;targetString < targetEndPointer;targetString += strlen(targetString) + 1){

		if(strstr(targetString,mb_key) != NULL){

			cookiePointer = targetString + strlen(targetString) + 1;
			domeinPointer = cookiePointer + strlen(cookiePointer) + 1;

			if(strcmp(mb_domein,domeinPointer) == 0){

				if(((INT_PTR)bufSize) < GetLenToWide(CP_UTF8,cookiePointer) + wcslen(key) + 1){

					goto cookiebuffbigerr;
				}
				wcscpy(cookies,key);
				cookies += wcslen(cookies);
				cookies[0] = L'=';
				cookies++;

				MBToWide(CP_UTF8,cookiePointer,cookies,bufSize);
				result = COOKIE_ERR_OK;
				break;
			}
		}

	}

end:


	return result;


keybuffbigerr:
	result = COOKIE_ERR_DETAIL_URL_TOOBIG;
	goto end;

domeinbuffbigerr:
	result = COOKIE_ERR_DETAIL_DOMEIN_TOOBIG;
	goto end;

cookiebuffbigerr:
	result = COOKIEERR_DETAIL_RESULT_TOOBIG;
	goto end;
}

///
///N[ƃt@CAtHbNX̋ʏ
///

static INLINE UINT checkDBAndStmt(sqlite3 **db,sqlite3_stmt **stmt,LPCWSTR path,LPCWSTR sql){


	//DB|C^NULL̏ꍇxDBI[v邻łNULL̏ꍇAG[Ԃ
	if(*db == NULL){
		SqliteManager_open(db,path,SQLITE_OPEN_READONLY | SQLITE_OPEN_PRIVATECACHE,0);
		if(*db == NULL){
			return 1;

		}
	}

	//Xe[ggNULL̏ꍇxXe[gg̍쐬sAsꍇG[Ԃ
	if(*stmt == NULL){
		SqliteManager_prepare( *db,sql, -1, stmt,(void**)NULL);
		if(*stmt == NULL){
			return 2;


		}
	}

	return 0;

}

static INLINE VOID cookieStepExec(sqlite3_stmt *stmt,LPWSTR cookie,SIZE_T bufSize,COOKIE_RESULT *result){

	LPCWSTR pName;
	LPCWSTR pValue;
	INT_PTR rc;


	//dumpln_mb(CP_UTF8,"sql%s",sqlite3_sql(stmt));

	do{
		//sqlꍇA擾valueʂɎ߂
		rc =  sqlite3_step( stmt );

	}while(SQLITE_BUSY == rc || SQLITE_LOCKED == rc);


	switch(rc){

	case SQLITE_ROW:


		pName = (LPCWSTR)sqlite3_column_text16( stmt, 0 );
		pValue   = (LPCWSTR)sqlite3_column_text16( stmt, 1 );

		//擾񂪃obt@̃TCY傫ꍇAobt@TCYG[i[
		if(wcslen(pValue) + wcslen(pName) + 2 >= bufSize){

			*result = COOKIEERR_DETAIL_RESULT_TOOBIG;


		} else  {


			wcscpy(cookie,pName);
			wcscat(cookie,L"=");
			wcscat(cookie,pValue);

			*result = COOKIE_ERR_OK;
			

			

		}
			


		break;


	case SQLITE_DONE:
		*result = COOKIE_ERR_DETAIL_NOTFOUND;

		break;

	default:
		*result = COOKIE_ERR_UNKNOWN;

		break;

	}

	return;


}


static COOKIE_RESULT SelfParseCookie(LPCWSTR cookieFilePath,LPWSTR cookie,SIZE_T bufSize,LPCWSTR key,LPCWSTR domein,SelfParseCookieCallBack callBack){

	COOKIE_RESULT result = COOKIE_ERR_UNKNOWN;

	HANDLE hCookieFile = CreateFile(cookieFilePath,GENERIC_READ,FILE_SHARE_WRITE | FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
	if(hCookieFile == INVALID_HANDLE_VALUE ){

		goto fileopenerr;
	}
	{
		DWORD readSize;
		
		DWORD lowSize = GetFileSize(hCookieFile,NULL);
		SIZE_T bufferSize = lowSize;
		LPSTR buffer = NULL;
		if(lowSize == -1)goto fileopenerr;

		buffer = (LPSTR)malloc(bufferSize);
		
		ReadFile(hCookieFile,buffer,bufferSize,&readSize,NULL);
		
	

		
		result = callBack(buffer,buffer + (bufferSize / sizeof(CHAR)),cookie,bufSize,key,domein);
		free(buffer);
	}

end:
	
	CloseHandle(hCookieFile);
	
	return result;

fileopenerr:
	result = COOKIE_ERR_OPEN_FAILED;
	goto end;
}


BROWSERTYPE getDefaultBrowserType(){

	BROWSERTYPE rslt = getDefaultBrowserReg(HKEY_CURRENT_USER,L"Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice",L"Progid");

	if(rslt == BT_NOSETTING){

		rslt =  getDefaultBrowserReg(HKEY_CLASSES_ROOT,L"http\\shell\\open\\command",L"");
	}

	return rslt;
	
}

static INLINE BROWSERTYPE getDefaultBrowserReg(HKEY hTopKey,LPCWSTR path,LPCWSTR sectionName){

	BROWSERTYPE rslt = BT_NOSETTING;
	WCHAR browserName[_MAX_PATH];
	DWORD cName  = sizeof(browserName);
	HKEY hKey;
	//WXgL[ǂݎpŃI[v
	if(RegOpenKeyEx(hTopKey,path,0,KEY_READ,&hKey) != ERROR_SUCCESS){
		return BT_NOSETTING;
	}

	RegQueryValueEx(hKey,sectionName,(LPDWORD)NULL,(LPDWORD)NULL,(LPBYTE)&browserName,&cName);

	

	rslt = browserNameToBrowserType(browserName);



	RegCloseKey(hKey);
	return rslt;

}


static INLINE BROWSERTYPE browserNameToBrowserType(LPCWSTR browserName){

	WCHAR browserNameBuf[_MAX_PATH];
	wcscpy(browserNameBuf,browserName);

	CharUpperBuff(browserNameBuf,wcslen(browserNameBuf));
	
	if(
		_tcsstr(browserNameBuf,L"CHROME") !=NULL ||
		_tcsstr(browserNameBuf,L"GOOGLECHROME") != NULL
		){

		return BT_GOOGLE_CHROME;

	} else if(
		_tcsstr(browserNameBuf,L"IE") !=NULL ||
		_tcsstr(browserNameBuf,L"INTERNETEXPLORER") !=NULL
		){

		return BT_INTERNET_EXPLORER;

	} else if(
		_tcsstr(browserNameBuf,L"FIREFOX") !=NULL
		){

		return BT_FIRE_FOX;

	} else if(
		_tcsstr(browserNameBuf,L"SAFARI") !=NULL
		){

		return BT_SAFARI;
	} else if(
		_tcsstr(browserNameBuf,L"OPERA") !=NULL
		){

		return BT_OPERA;

	} else if(
		_tcsstr(browserNameBuf,L"SLEIPNIR") !=NULL
		){

		return BT_IE_COMPONENT;

	} else {

		return BT_IE_COMPONENT;

	}
	
	
}

