#pragma once

namespace nlite{

	class CCommentView;
	class CCommentListWindow;
	class CChatChildCtrlsList;
	class CChatChildCtrls;

	//萔p̖O
	namespace commentViewConstant{

		//Rgr[EBhE
		const static LPCTSTR  NLITE_COMMENTVIEW = TEXT("NLITE_COMMENTVIEW");

		//RgXgEBhE
		const static LPCTSTR NLITE_COMMENTLISTWINDOW = TEXT("NLITE_COMMENTLISTWINDOW");

		//wb_[̍
		const static UINT_PTR HEADER_HAIGHT = 20;

		//wb_[Rg[ID
		const static UINT_PTR HEADER_ID = 257;

		//RgXgEBhEID
		const static UINT_PTR LISTWINDOW = 258;

		//baseWindowID
		const static UINT_PTR MENU_OR_ID = 256;
	}

	class CChatReadEdit :public CWindowImpl<CChatReadEdit,CRichEditCtrl>{
		friend CCommentListWindow;
		friend CChatChildCtrls;

		CCommentView &m_master;


		BEGIN_MSG_MAP(CChatReadEdit)

		END_MSG_MAP()
		CChatReadEdit(CCommentView &m_master);
		BOOL SetWindowText(const CChatData &str);

		///
		///eZbg
		//
		VOID Reset();


		///
		///N\
		///
		VOID linkStringBeside(const tstring &target,const nliteregex::tregex &re);


		///
		///̃AvP[VɂėpIȃEBhE쐬֐
		///
		HWND GeneralCreate(HWND hParent,DWORD eventMask,UINT id);
	};

	class CChatChildCtrls{
		friend CCommentListWindow;
		friend CChatChildCtrlsList;
	private:
		CChatReadEdit chatDispCtrl;
		CCommentView &m_master;


	private:

		enum {
			NO_DIOSCTRL_ID = 10000000,
			USERNAME_DISPCTRL_ID = 20000000,
			CHAT_DISPCTRL_ID = 30000000

		};

		///
		///RXgN^
		///
		CChatChildCtrls(CCommentView &hMaster);

		///
		///w肵ɃRg[Zbg
		///
		VOID SetCtrl(HDWP,const RECT &rc,CCommentList::reference commen,BOOL mulutiLineFlag);

		VOID AdjustRect(RECT &rc);

		VOID Hide(HDWP hdwp);

		VOID Create();

		///
		///Rg[̌擾
		///
		static UINT_PTR GetCtrlCount();



	};

	///
	///Rg\EBhE̎qEBhEXg
	///
	class CChatChildCtrlsList{
		friend CCommentView;
		friend CCommentListWindow;
		friend CChatChildCtrls;

	private:
		typedef std::list<CChatChildCtrls> InternalList;

		InternalList m_list;								//ŊǗ郊Xg
		CCommentView &m_hMaster;							//̃EBhELĂeEBhE


	private:
		typedef InternalList::reference reference;
		typedef InternalList::iterator iterator;

		///
		///RXgN^
		///
		CChatChildCtrlsList(CCommentView &hMaster);



		///
		///Rg[\
		///
		VOID ShowCntrls();

		///
		///\
		///
		VOID AllHide();

	private:

		///
		///g
		///
		iterator Extend();


	};


	//Rg\pEBhE
	class CCommentListWindow:public CWindowImpl<CCommentListWindow>{

		friend CCommentView;
		friend CChatChildCtrls;
		friend CChatChildCtrlsList;


		//o
	private:
		CCommentView &self;
		UINT_PTR viewSellHeight;
		CPen collLinePen;													//ڏc`py
		CPen normalSellLinePen;												//g`py
		CBrush normalBkBrush;												//wi`puV
		CPen selectSellLinePen;												//g`py
		CBrush selectBkBrush;												//wi`puV
		CFont linkFont;														//ÑtHg


		enum {
			CALCEDIT_ID = 100

		};

	public:


		DECLARE_WND_CLASS(commentViewConstant::NLITE_COMMENTLISTWINDOW)


		//
		//bZ[W}bv
		//
		BEGIN_MSG_MAP(CCommentListWindow)
			MSG_WM_LBUTTONDBLCLK(OnLButtonDblClk)
			MSG_WM_LBUTTONDOWN(OnLButtonDown)
			MSG_WM_CREATE(OnCreate)
			MSG_WM_ERASEBKGND(OnEraseBkGnd)
			MSG_WM_MOUSEWHEEL(OnMouseWheel)
			MSG_WM_PAINT(OnPaint)
			MSG_WM_SIZE(OnSize)
			MSG_WM_KEYDOWN(OnKeyDown)
			MSG_WM_SETCURSOR(OnSetCursor)
			MESSAGE_HANDLER_EX(UM_COMMENTVIEW_SETCTRL,OnSetCtrol)
			NOTIFY_ID_HANDLER_EX(CChatChildCtrls::CHAT_DISPCTRL_ID,OnChatControlNortify)
			NOTIFY_HANDLER_EX(CALCEDIT_ID,EN_REQUESTRESIZE,OnCalcSellSize)
		END_MSG_MAP()



	private:

		///
		///RXgN^
		///
		CCommentListWindow(CCommentView &self_in);

		///
		///fXgN^
		///
		~CCommentListWindow();




		///
		///vpeBݒ莞̏
		///
		VOID OnSetProperty();

		///
		///XN[y[WvZ
		///
		UINT_PTR CalcScrollPage(UINT_PTR nMax);

		///
		///s̍₢킹
		///
		VOID CalcItemHeight(CChatData &chatData);

		///
		///Is\
		///
		VOID ShowCurSel();

		///
		///`bg\̈vZ
		///
		VOID CalcChatRect(const CDC &cdc,RECT &rc,const CNLiteString &str);


		//vCx[g֐
	private:

		///
		///ACe`
		///
		VOID DrawItem(CDC &dc,const RECT &rc,const RECT *headerRect,CChatData &chatData);

		///
		///`捂Zbg
		///
		VOID ResetViewSellHeight();




		///
		///NbNsvZ
		///
		CCommentList::iterator CalcClickLine(INT_PTR height);

		///
		///[URԏォ̔
		///
		BOOL IsOnNoOrUserName(UINT_PTR index,const POINT &point);

		//bZ[Wnh
	private:

		///
		///EBhE쐬̏
		///
		LRESULT OnCreate(LPCREATESTRUCT lpCreateStruct);

		///
		///}EXNbN̏
		///
		VOID OnLButtonDown(UINT wParam, _WTYPES_NS::CPoint &point);

		///
		///j̏
		///
		VOID OnDestroy();

		///
		///`揈
		///
		VOID OnPaint(HDC hdc);

		///
		///Rg[Zbg
		///
		LRESULT OnSetCtrol(UINT uMsg,WPARAM wparam,LPARAM lparam);

		///
		///TCYύX
		///
		VOID OnSize(UINT wParam, _WTYPES_NS::CSize &windowSize);

		///
		///}EX_uNbN̏
		///
		VOID OnLButtonDblClk(UINT wParam, _WTYPES_NS::CPoint &point);

		///
		///wihԂ
		///
		LRESULT OnEraseBkGnd(HDC lparam);

		///
		///}EXzC[
		///
		LRESULT OnMouseWheel(UINT loWparam,SHORT hiWparam,CPoint &point);

		///
		///L[̏
		///
		VOID OnKeyDown(TCHAR vKey,UINT loLParam,UINT hiLParam);

		///
		///J[\ύX
		///
		LRESULT OnSetCursor(HWND wparam,UINT loLparam,UINT hiLparam);

		///
		///`bgRg[ʒm
		///
		LRESULT OnChatControlNortify(LPNMHDR lParam);


		///
		///Z̃TCYvZ
		///
		LRESULT OnCalcSellSize(LPNMHDR lParam);

	};

	///
	///Rgr[NX
	///
	class CCommentView:public CWindowImpl<CCommentView>{
		friend CChatChildCtrls;
		friend CCommentListWindow;						//th錾
		friend CChatChildCtrlsList;
		friend CChatChildCtrls;
		friend CChatReadEdit;
		//vCx[g^ENX`
	private:

		//wb_[i[pIuWFNg
		typedef struct{

			LPTSTR *columns;
			UINT_PTR *holizensize;
			UINT_PTR count;

		}HEADERSINFO,*LPHEADERSINFO;






		//o錾
	private:

		CHeaderCtrl m_header;						//wb_[Rg[
		CCommentListWindow  m_commentListWindow;	//RgXgEBhE
		CNicoLiveStream &stream;					//IuWFNg
		CGeneralProperty generalProperty;			//ʐݒ
		CCommentList commentlist;					//RgXg
		CCommentViewProperty viewproperty;			//\vpeB
		HFONT hHeaderFontNew;						//wb_[tHg
		CNicoVideoAuth &refAuth;					//jRjRF؃IuWFNgQ
		CChatChildCtrlsList chatChildCtrlsList;		//qEBhEXg








	public:

		enum{
			NO,
			USERNAME,
			COMMENT,
			TIME,
			INFO

		};

		///
		///RXgN^
		///
		CCommentView(CNicoLiveStream &stream,CNicoVideoAuth &refAuth);

		///
		///fXgN^
		///
		~CCommentView();

		///
		///EBhEXV
		///
		VOID UpDateUI();


		//
		//EBhENX錾
		//
		DECLARE_WND_CLASS_EX(commentViewConstant::NLITE_COMMENTVIEW,0,COLOR_BACKGROUND)

		//
		//bZ[W}bv
		//
		BEGIN_MSG_MAP(CCommentView)
			MSG_WM_CREATE(OnCreate)
			MSG_WM_DESTROY(OnDestroy)			
			MSG_WM_SIZE(OnSize)
			MSG_WM_HSCROLL(OnHScroll)
			MSG_WM_VSCROLL(OnVScroll)
			MESSAGE_HANDLER_EX(UM_CLICK_CHATNO,OnClickChatNo)
			MESSAGE_HANDLER_EX(UM_CLICK_USERNAME,OnClickUserName)
			MSG_WM_ERASEBKGND(OnEraseBkgnd)
			NOTIFY_CODE_HANDLER_EX(HDN_ENDTRACK   ,OnHeaderEndTrack)
			NOTIFY_CODE_HANDLER_EX(HDN_ENDDRAG  ,OnHeaderEndDrag)
		END_MSG_MAP()

		///
		///vpeBݒ
		///
		VOID SetProperty(const CCommentViewProperty &setProperty,const CGeneralProperty &in_generalProperty);

		///
		///vpeB擾
		///
		CCommentViewProperty &GetProperty();

		///
		///EBhE쐬
		///
		HWND Create(HWND hWndParent);

		///
		///wb_̉擾
		///
		UINT_PTR GetColumnHolSizeSum();

		///
		///jRɐڑ̏
		///
		VOID OnConnect();

		///
		///`bgRgM̏
		///
		VOID OnChatReceve(NicoLiveChat_P chat,UINT_PTR count);

		///
		///`bgRgMm菈
		///
		VOID OnChatReceveSettle(UINT_PTR commentCount,UINT_PTR commentCountSum);



		//vCx[g֐
	private:


		///
		///wb_ǉ
		///
		VOID AddHeader(LPHEADERSINFO infos);

		///
		///wb_̉
		///
		VOID DecisionHorzSize();


		///
		///TCYύX
		///
		VOID ChangeSize(const SIZE& client);

		//EBhEbZ[Wnh
	private:



		///
		///TCYύX㏈
		///
		LRESULT OnSize(UINT wParam,SIZE lParam);



		///
		///r[Aɕ\ĂRԂNbNꂽ̏
		///
		LRESULT OnClickChatNo(UINT uMsg,WPARAM wParam,LPARAM lParam);


		///
		///r[Aɕ\Ă郆[UNbNꂽ̏
		///
		LRESULT OnClickUserName(UINT uMsg,WPARAM wParam,LPARAM lParam);


		///
		///wihԂ
		///
		LRESULT OnEraseBkgnd(HDC wParam);

		///
		///EBhEj̏
		///
		VOID OnDestroy();

		///
		///wb_ACeύX
		///
		LRESULT OnHeaderEndTrack(LPNMHDR lParam);


		///
		///wb_hbO㏈
		///
		LRESULT OnHeaderEndDrag(LPNMHDR lParam);



		///
		///XN[̏
		///
		VOID OnHScroll(INT_PTR loWParam,SHORT hiWParam,HWND lParam);

		///
		///cXN[̏
		///
		VOID OnVScroll(INT_PTR loWParam,SHORT hiWParam,HWND lParam);

		///
		///쐬̏
		///
		LRESULT OnCreate(LPCREATESTRUCT lpcs);

	};

}
