#pragma once

namespace nlite{

	//O錾
	class CCommentListWindow;
	class CListenerColorCollector;
	class CCommentList;
	class CListenerList;
	class CReadUserSettingXML;

	//R[h
	namespace cuntry{

		enum LOCALE{
			unknown,
			jp

		};

	}

	///
	///Xi[f[^
	///
	class CListenerData{
	private:
		friend CListenerColorCollector;
		friend CCommentList;
		friend CListenerList;
		friend CReadUserSettingXML;

		CNLiteString user_id;					//[U[ID
		CNLiteString name;						//[U[
		CNLiteString community;					//o^R~jeB
		COLORREF bgcolor;						//wiF
		COLORREF nameColor;						//OF
		time_t time;							//o^
		BOOL onlyCommunityFlag;
	public:

		enum {
			INIT_COLOR = -1

		};


		//Zb^[
	public:
		
		///
		///RXgN^
		///
		CListenerData();

		///
		///wiFݒ
		///
		VOID SetBkColor(COLORREF bkColor_in);

		///
		///OHݒ
		///
		VOID SetNameColor(COLORREF nameColor_in);
		
		///
		///[Uݒ
		///
		VOID SetUserName(LPCTSTR name);


		//Qb^[
	public:

		///
		///wiF擾
		///
		COLORREF GetBackColor() const;


		///
		///jbNl[̐F擾
		///
		COLORREF GetNameColor() const;

		///
		///[U擾
		///
		const CNLiteString &GetUserID() const;


		///
		///[U擾
		///
		const CNLiteString &GetName() const;
	};

	//
	//Xi[f[^wiJ[Wt@NVi
	//
	class CListenerColorCollector{

	private:
		std::deque<COLORREF> colorlist;										//FXg

	public:

		typedef std::deque<COLORREF>::iterator iterator;

		//w肵Fo^Ă邩ׂ
		BOOL Find(COLORREF target){

			iterator end = colorlist.end();

			return std::find(colorlist.begin(),end,target) != end ? TRUE : FALSE;
		}

		//t@NVi
		void operator()(CListenerData &target){

			if(target.bgcolor != CListenerData::INIT_COLOR){

				colorlist.push_back(target.bgcolor);
			}

		}

	};
	
	
	///
	///Xi[Xg
	///
	class CListenerList{

	private:
		typedef CListenerData InternalType;
		typedef std::list<InternalType> ListenerList_Internal; 
		ListenerList_Internal m_listenerList;

	public:

		typedef InternalType& reference;
		typedef ListenerList_Internal::value_type value_type;
		typedef ListenerList_Internal::iterator iterator;

		

		///
		///[U[o^
		///
		reference Register(CListenerData &listener,BOOL bUpdate);


		///
		///Xi[f[^ǂݍ
		///
		BOOL ReadProperty(LPCTSTR fileName);

		///
		///Xi[f[^
		///
		BOOL WriteProperty(LPCTSTR fileName);

		
		///
		///wiFW
		///
		VOID BkColorCollect(CListenerColorCollector &target);

	};

	

	class CChatData{
		friend CCommentList;
		
	public:
		struct ViewData{

			//FR[hl
			enum{
				INIT_COLOR = -1
			};

			BOOL selectFlag;					//I
			COLORREF stringColor;				//ƎF
			COLORREF backColor;					//ƎwiF
			COLORREF sellLineColor;				//gF
			UINT_PTR height;

			ViewData();
		};

	private:
		ViewData viewData;					//\pf[^
		UINT_PTR premium;					//v~A
		BOOL anonymity;						//tO
		UINT_PTR no;						//R
		UINT_PTR vpos;						//Rg\ʒu
		time_t date;						//
		cuntry::LOCALE locale;				//R[h
		CListenerData *listenerData;			//[U
		CNLiteString name;					//OBĂȂ
		CNLiteString chatBuf;				//`bg{
		std::vector<CNLiteString> mail;		//[R}h
		ULONG_PTR thread;					//Xbhԍ
		

		//Zb^[
	public:

		///
		///nlib̃`bgf[^Zbg
		///
		VOID SetChat(NicoLiveChat &chat_in,CListenerData &listener);

		///
		///\pݒ
		///
		VOID SetHeight(UINT_PTR height);

		//Qb^[
	public:

		///
		///Xi[NX̎QƂ擾
		///
		CListenerData &GetListnerData();

		///
		///`bg{擾
		///
		const CNLiteString &GetChatBuff()const;

		///
		///IԔtO擾
		///
		BOOL IsSelect()const;

		///
		///wiF擾
		///
		COLORREF GetBackColor()const;

		///
		///v~Aʎ擾
		///
		UINT_PTR GetPremium()const;

		///
		///RgԎ擾
		///
		time_t GetDate()const;

		///
		///Rgԍ擾
		///
		UINT_PTR GetNo()const;

		///
		///\̐F擾
		///
		COLORREF GetStringColor()const;

		///
		///gF擾
		///
		COLORREF GetSellLineColor()const;

		///
		///\p̍擾
		///
		UINT_PTR GetHeight()const;


	};




	///
	///RgXgNX
	///
	class CCommentList{

	private:
		typedef std::list<CChatData> ChatList;
	public:
		typedef ChatList::iterator iterator;
		typedef ChatList::reference reference;
		typedef ChatList::reverse_iterator reverse_iterator;
	private:
		ChatList chatList;
		iterator shortcut;
	

	
		//G[R[h
	public:
		enum ERRORCORD{
			ERR = -1,
			OK = 0


		};


		//^`
	

	public:

		///
		///RXgN^
		///
		CCommentList();
		
		///
		///fXgN^
		///
		~CCommentList();
		
		///
		///ڑ̏
		///
		VOID OnConnect();
		

		///
		///j̏
		///
		VOID OnDestroy();
		
		///
		///i[ꂽRg擾
		///
		UINT_PTR Size();
		

		///
		///Iڂ擾
		///
		iterator GetCurSel();


		INT_PTR GetCurSelNo();

		///
		///Iڂݒ
		///
		VOID SetCurSel(iterator cursel);

		///
		///IԂ̃ACe擾
		///
		iterator GetCurSelItem();

		///
		///󂩔
		///
		BOOL empty();

		///
		///ŏ̃Ce[^擾
		///
		iterator begin();

		///
		///Ō̃Ce[^擾
		///
		iterator end();

		///
		///tCe[^̍ŏ擾
		///
		reverse_iterator rbegein();

		///
		///tCe[^̍Ō擾
		///
		reverse_iterator rend();

		///
		///`bgM̏
		///`bgf[^̑}s
		///Xg󂩁AM`bgf[^date̒lXgŌȏ̂̂ꍇŌɑ}
		///łȂꍇ̓Xg̍ŏɓnꂽ`bgf[^date傫datef[^TÃf[^̒Oɑ}
		///
		iterator OnChatReceve(NicoLiveChat_P chatData,LPCTSTR communityID, UINT_PTR count,CCommentListWindow &listWindow);

		///
		///w肵ԍ̃RgQƂ擾
		///
		reference GetChatAt(UINT_PTR no);
		

		///
		///XgŌ̎QƂ擾
		///
		reference back();

		///
		///V[gJbgCe[^擾
		///
		iterator GetShortCut();
		
		///
		///V[gJbgݒ
		///
		BOOL SetShortCut(UINT_PTR no);

		
		
	};


	///
	///[Uݒt@CǎNX
	///
	class CReadUserSettingXML:public CXmlParser{

	private:
		CListenerData listenerBuff;
		CListenerList &m_listenerList;
		BOOL userNodeFlag;
		
		
		


	public:

		CReadUserSettingXML(CListenerList &in_listenerList);

		void OnStartElement (const XML_Char *pszName, const XML_Char **papszAttrs);

		void OnEndElement (const XML_Char *pszName);

		void OnCharacterData (const XML_Char *pszData, int nLength);
	};
	
}