#include "stdafx.h"
#include "nlite_include.h"
using namespace std::tr1;
namespace nlite{




//Xi[IuWFNg
struct ListenerPre{

	CListenerData &user;

	ListenerPre(CListenerData &in_user):
		user(in_user)
	{}

	bool operator()(CListenerList::reference listenerData){

		
		return (user.GetUserID() == listenerData.GetUserID())/* && (user.community == listenerData.community)*/;
	}

};


//
//Xi[f[^
/////////////////////////////////////////////////////////////////////////////////////////////////


CListenerData::CListenerData():
user_id(TEXT("")),
name(TEXT("")),
community(TEXT("")),
bgcolor(INIT_COLOR),
time(0),
onlyCommunityFlag(FALSE),
nameColor(INIT_COLOR)
{}

VOID CListenerData::SetNameColor(COLORREF nameColor_in){
	
	nameColor = nameColor_in;

	return;
}

VOID CListenerData::SetBkColor(COLORREF bkColor_in){
	bgcolor = bkColor_in;

	return;
}

VOID CListenerData::SetUserName(LPCTSTR name){

	this->name = name;


}

COLORREF CListenerData::GetBackColor()const {

	return this->bgcolor;

}

COLORREF CListenerData::GetNameColor()const{

	return this->nameColor;
}


const CNLiteString &CListenerData::GetUserID()const{

	return this->user_id;

}



const CNLiteString &CListenerData::GetName()const{

	return this->name;

}

CChatData::ViewData::ViewData():
			sellLineColor(INIT_COLOR),
			stringColor(INIT_COLOR),
			backColor(INIT_COLOR),
		  selectFlag(FALSE),
		  height(0)
		{}

VOID CChatData::SetChat(NicoLiveChat &chat_in,CListenerData &listener){
	
	
	this->anonymity = _ttol(chat_in.anonymity);
	this->premium = _ttol(chat_in.premium);
	this->chatBuf = chat_in.chatBuf;
	this->no = _ttol(chat_in.no);

	if(_tcscmp(chat_in.locale,TEXT("jp")) == 0){
		this->locale = cuntry::jp;
	} else {
		this->locale = cuntry::unknown;
	}
	this->mail.reserve(chat_in.mailCount);
	for(UINT_PTR index = 0;index < chat_in.mailCount ;index++){

		this->mail.push_back(chat_in.mail[index]);
	}

	this->name = chat_in.name;


	
	this->listenerData = &listenerList.Register(listener,FALSE);
	tstring target(chat_in.chatBuf);
	
	match_results<tstring::iterator> results;
	if(regex_match(target.begin(),target.end(),results,nliteregex::NAMESERTCHREGEX) == TRUE){
		
		const tstring &name = results.str(results.size() - 1).c_str();
		
		if(nliteProperty.GetGeneralProperty().IsNumberName() == TRUE || _tcstol(name.c_str(),NULL,10) == 0){
			this->listenerData->SetUserName(name.c_str());
		}
		
	}
	
	this->vpos = _ttol(chat_in.vpos);
	this->thread = _ttol(chat_in.thread);
	this->date = _ttol(chat_in.date);
	


	return;
}


VOID CChatData::SetHeight(UINT_PTR height){

	this->viewData.height = height;
	
}

CListenerData &CChatData::GetListnerData() {


	return *this->listenerData;
}

const CNLiteString &CChatData::GetChatBuff()const{

	return this->chatBuf;
}

BOOL CChatData::IsSelect()const{

	return this->viewData.selectFlag;
}

COLORREF CChatData::GetBackColor()const{

	return this->viewData.backColor;
}

UINT_PTR CChatData::GetPremium()const{

	return this->premium;

}

time_t CChatData::GetDate()const{

	return this->date;

}

UINT_PTR CChatData::GetNo()const{

	return this->no;
}

COLORREF CChatData::GetStringColor()const{

	return this->viewData.stringColor;

}

COLORREF CChatData::GetSellLineColor()const{

	return this->viewData.sellLineColor;
}

UINT_PTR CChatData::GetHeight()const{

	return this->viewData.height;
}

//
//
//RgXgNX
//////////////////////////////////////////////////////////////////////////

//Is擾pt@NVi
struct GetCurSelFunc_t{

	INT_PTR count;
	BOOL findFlag;
	GetCurSelFunc_t():
		count(0)
		{}

	BOOL operator() (const CChatData &target){
		count++;
		return  target.IsSelect();
	}

};

//}ʒut@NVi
struct SeartchSetPos_t{
	time_t time;

	SeartchSetPos_t(time_t in_time):time(in_time){}

	bool operator()(const CChatData &target){

		return time > target.GetDate();
	}
};

CCommentList::CCommentList(){}

CCommentList::~CCommentList(){}

CCommentList::iterator CCommentList::GetCurSel(){
	auto end = this->end();
	auto ite = this->begin();

	for(;ite != end && ite->viewData.selectFlag == FALSE;++ite);

	return ite ;
}


INT_PTR CCommentList::GetCurSelNo(){

	auto end = this->end();
	auto ite = this->begin();
	INT_PTR no = 0;
	for(;ite != end && ite->viewData.selectFlag == FALSE;++ite,++no);

	return ite != end ? no : -1;

}


CCommentList::iterator CCommentList::OnChatReceve(NicoLiveChat_P chatData_in,LPCTSTR communityID, UINT_PTR commnetCountSum,CCommentListWindow &listWindow){

	CChatData chatData;
	CListenerData listenerData;
	listenerData.user_id = chatData_in->user_id;
	listenerData.time = time(NULL);
	listenerData.community = communityID;
	chatData.SetChat(*chatData_in,listenerData);
	iterator rslt;
	if(empty() == TRUE || back().date <= chatData.date){
		chatList.push_back(chatData);
		rslt = (--chatList.end());
		if(nlite::nliteProperty.GetCommentReadProperty().IsCommentRead() == TRUE){
			
			g_speaker.SynthesisAsync((const speaker::TChar_P)(LPCTSTR)rslt->chatBuf);
		}
	}else {

		rslt = chatList.insert(std::find_if(chatList.begin(),chatList.end(),SeartchSetPos_t(chatData.date)),chatData);
	}
	
	if(shortcut ==chatList.end())shortcut = chatList.begin();

	return rslt;
}

CCommentList::iterator CCommentList::GetCurSelItem(){
	auto rslt = std::find_if(chatList.begin(),chatList.end(),GetCurSelFunc_t());

	return rslt;
}


VOID CCommentList::SetCurSel(CCommentList::iterator cursel){
	
	auto end = this->end();
	if(cursel == end)goto end;
	{
		auto curselItem = this->GetCurSelItem();
	
		if(curselItem != end){
			curselItem->viewData.selectFlag = FALSE;
		}
	
		
		cursel->viewData.selectFlag = TRUE;
	}
end:

	return;
}


CCommentList::reference CCommentList::GetChatAt(UINT_PTR no){

	iterator data = chatList.begin();
	std::advance(data,no);
	return *data;
}


UINT_PTR CCommentList::Size(){

	return chatList.size();
}

BOOL CCommentList::empty(){

	return chatList.empty();
}



CCommentList::iterator CCommentList::begin(){

	return chatList.begin();
}

CCommentList::iterator CCommentList::end(){
	
	return chatList.end();
}


CCommentList::reverse_iterator CCommentList::rbegein(){

	
	return chatList.rbegin();
}



		
CCommentList::reverse_iterator CCommentList::rend(){

	return chatList.rend();
}

VOID CCommentList::OnDestroy(){
	
	chatList.clear();
	
}

VOID CCommentList::OnConnect(){
	OnDestroy();
	shortcut = chatList.begin();
}

CCommentList::reference CCommentList::back(){

	return chatList.back();
}

///
///V[gJbgCe[^擾
///
CCommentList::iterator CCommentList::GetShortCut(){

	return shortcut;
}
		
///
///V[gJbgݒ
///
BOOL CCommentList::SetShortCut(UINT_PTR no){


	if(static_cast<INT_PTR>(chatList.size()) <= no)return FALSE;

	shortcut = chatList.begin();
	std::advance(shortcut,no);

	return TRUE;

}



VOID CListenerList::BkColorCollect(CListenerColorCollector &target){

	iterator end = m_listenerList.end();
	std::for_each(m_listenerList.begin(), end,target);
}

CListenerList::reference CListenerList::Register(CListenerData &listener,BOOL bUpdate){

	//֐IuWFNg
	ListenerPre listenerPre(listener);


	iterator begin = m_listenerList.begin();
	iterator end = m_listenerList.end();

	//o^\̃Xi[f[^łɓo^Ă邩
	iterator rslt = std::find_if(begin,end,listenerPre);


	//Xi[f[^o^ĂȂꍇ
	if(rslt == end){

		//Xi[f[^o^
		m_listenerList.push_back(listener);
		return m_listenerList.back();



		//Xi[f[^o^ĂꍇŁAXVtOtruȅꍇ
	} else if(bUpdate == TRUE){

		//Xi[f[^XV
		*rslt = listener;

		
	}
	
	return *rslt;

}

BOOL CListenerList::ReadProperty(LPCTSTR fileName){
	BOOL rslt = FALSE;
	CAtlFile	userSettingFile;
	ULONGLONG userSettingFileSize;
	std::vector<char> userSettingBuf;
	
	if(SUCCEEDED(userSettingFile.Create(fileName,GENERIC_READ,FILE_SHARE_READ,OPEN_ALWAYS)) == FALSE || userSettingFile.m_h == NULL || SUCCEEDED(userSettingFile.GetSize(userSettingFileSize)) == FALSE){

		throw Exception(TEXT("Xi[ݒt@CJ܂łB̃G[悤ł΁Axݒt@C폜čēxĂ݂Ă"),__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
		
	}
	userSettingBuf.resize(static_cast<UINT_PTR>(userSettingFileSize / sizeof(char) + (1 * sizeof(char))));
	userSettingFile.Read(&userSettingBuf[0],userSettingBuf.size());
	LPSTR userSettingStart = strstr(&userSettingBuf[0],"<");
	if(userSettingStart != NULL){
		CReadUserSettingXML rusx(nlite::listenerList);
		rusx.Parse(userSettingStart);
	}


	return rslt;
}
#define NLITE_ATTRIBUTE_WRITE_STR(s,n)	s->WriteAttributeString(NULL, _tcsstr(TEXT(#n),TEXT("."))  != NULL ? _tcsstr(TEXT(#n),TEXT(".")) + 1 : TEXT(#n), NULL, n)

#define NLITE_ATTRIBUTE_WRITE_INT(s,n)	\
	{\
	TCHAR buffer[sizeof(n) * 8];\
	_stprintf(buffer,TEXT("%d"),static_cast<INT>(n));\
	s->WriteAttributeString(NULL, _tcsstr(TEXT(#n),TEXT(".")) + 1, NULL,buffer );\
}
BOOL CListenerList::WriteProperty(LPCTSTR fileName){
	BOOL rslt = FALSE;


	CComPtr<IXmlWriter> pWriter;
	CreateXmlWriter(__uuidof(IXmlWriter), reinterpret_cast<void**>(&pWriter), 0);
	CComPtr<IStream> pStream;
	SHCreateStreamOnFile(fileName, STGM_CREATE | STGM_WRITE, &pStream);

	pWriter->SetOutput(pStream);

	// CfgL
	pWriter->SetProperty(XmlWriterProperty_Indent, TRUE);

	// <?xml version="1.0" encoding="UTF-8"?>
	pWriter->WriteStartDocument(XmlStandalone_Omit);

	pWriter->WriteStartElement(NULL,TEXT("listenerData"),NULL);


	auto begin = m_listenerList.begin();
	auto end = m_listenerList.end();

	//Xi[XgۑΏۂ̃f[^̂xml`ŕۑ
	for(;begin != end;++begin){
		if(begin->name.Length() > 0 || begin->nameColor != CListenerData::INIT_COLOR || begin->bgcolor != CListenerData::INIT_COLOR){
			pWriter->WriteStartElement(NULL,TEXT("user"),NULL);
			if(begin->name.Length() > 0) NLITE_ATTRIBUTE_WRITE_STR(pWriter,(*begin).name);
			if(begin->community.Length()> 0) NLITE_ATTRIBUTE_WRITE_STR(pWriter,(*begin).community);
			NLITE_ATTRIBUTE_WRITE_INT(pWriter,(*begin).time);
			if(begin->bgcolor != CListenerData::INIT_COLOR)NLITE_ATTRIBUTE_WRITE_INT(pWriter,(*begin).bgcolor);
			if(begin->nameColor != CListenerData::INIT_COLOR)NLITE_ATTRIBUTE_WRITE_INT(pWriter,(*begin).nameColor);
			pWriter->WriteString(begin->user_id);
			pWriter->WriteEndElement();
		}
	}
	pWriter->WriteEndDocument();
	rslt = TRUE;
	return rslt;
}


CReadUserSettingXML::CReadUserSettingXML(CListenerList &in_listenerList):m_listenerList(in_listenerList),userNodeFlag(FALSE){}

#define NLITE_READ_USER_STRING(at,l,t) if(_tcscmp(at[0],TEXT(#t)) == 0)l.t = at[1]
#define NLITE_READ_USER_INT(at,l,t)		if(_tcscmp(at[0],TEXT(#t))==0)l.t = _tcstol((const wchar_t*)at[1],NULL,10)

	void CReadUserSettingXML::OnStartElement (const XML_Char *pszName, const XML_Char **papszAttrs){

		if(_tcscmp(pszName,TEXT("user")) == 0){

			this->userNodeFlag = TRUE;


			for(;papszAttrs[0] != NULL;papszAttrs += 2){

				NLITE_READ_USER_STRING(papszAttrs,listenerBuff,name);
				NLITE_READ_USER_STRING(papszAttrs,listenerBuff,community);
				NLITE_READ_USER_INT(papszAttrs,listenerBuff,bgcolor);
				NLITE_READ_USER_INT(papszAttrs,listenerBuff,nameColor);
				NLITE_READ_USER_INT(papszAttrs,listenerBuff,time);
				
			}

		}

		return;
	}

	void CReadUserSettingXML::OnEndElement (const XML_Char *pszName){

		if(_tcscmp(pszName,TEXT("user")) == 0){

			listenerList.Register(listenerBuff,TRUE);
			this->userNodeFlag = FALSE;
			this->listenerBuff.~CListenerData();
			new(&listenerBuff) CListenerData();

		}

		return;
	}

	void CReadUserSettingXML::OnCharacterData (const XML_Char *pszData, int nLength){

		if(this->userNodeFlag == TRUE){

			
			if(_tcstol(listenerBuff.user_id,NULL,10) != 0 || ((difftime(time(NULL),604800)) <listenerBuff.time)){
				listenerBuff.user_id.Append(pszData,nLength);
			}



		}

		

		return;
	}

}