!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
MODULE sctk_z
  !
  IMPLICIT NONE
  !
CONTAINS
!
! Calc Z_{n k}
!
SUBROUTINE make_Z()
  !
  USE kinds, ONLY : DP
  USE mp_world, ONLY : mpime, world_comm
  USE mp, ONLY : mp_sum
  USE modes, ONLY : nmodes
  USE el_phon, ONLY : elph_nbnd_min, elph_nbnd_max
  USE sctk_val, ONLY : beta, bindx, dk, emin, gg, kindx, ngap, ngap1, ngap2, omg, xi, Z
  !
  USE sctk_kernel_weight, ONLY : Zweight
  !
  IMPLICIT NONE
  !
  INTEGER :: igap, ik, ib, jgap, jk, jb, im, ngap10, ngap11
  REAL(dp) :: x, xp, om, zave(2), ave(2), tx, txp, tom
  !
  ALLOCATE(Z(ngap,2))
  Z(1:ngap,1:2) = 0.0_dp
  !
  CALL divide(world_comm, ngap1,ngap10,ngap11)
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(ngap10,ngap11,ngap2,nmodes,kindx,bindx,beta, &
  !$OMP &        elph_nbnd_min,elph_nbnd_max,xi,dk,Z,gg,omg) &
  !$OMP & PRIVATE(igap,ik,ib,jgap,jk,jb,im,x,xp,om,tx,txp,tom)
  !
  !$OMP DO REDUCTION(+: Z)
  DO igap = ngap10, ngap11
     !
     x = ABS(xi(igap,1) * beta * 0.5_dp)
     tx = tanh(x)
     ik = kindx(igap,1)
     ib = bindx(igap,1)
     !
     IF(ib < elph_nbnd_min .OR. elph_nbnd_max < ib) CYCLE
     !
     DO jgap = 1, ngap2
        !
        xp = ABS(xi(jgap,2) * beta * 0.5_dp)
        txp = tanh(xp)
        jk = kindx(jgap,2)
        jb = bindx(jgap,2)
        !
        IF(jb < elph_nbnd_min .OR. elph_nbnd_max < jb) CYCLE
        !
        DO im = 1, nmodes
           !
           om = ABS(omg(im,jk,ik) * beta * 0.5_dp)
           tom = tanh(om)
           !
           Z(igap,1) = Z(igap,1) + dk(jgap,2) * gg(im,jb,jk,ib,ik) * beta**2 &
           &                 * Zweight(x, xp, om, tx, txp, tom)
           Z(jgap,2) = Z(jgap,2) + dk(igap,1) * gg(im,jb,jk,ib,ik) * beta**2 &
           &                 * Zweight(xp, x, om, txp, tx, tom)
           !
        END DO ! im
        !
     END DO ! jgap
     !
  END DO ! igap
  !$OMP END DO
  !
  !$OMP END PARALLEL
  !
  Z(1:ngap,1:2) = - Z(1:ngap,1:2)
  !
  CALL mp_sum( Z, world_comm )
  !
  zave(1) = SUM(Z(1:ngap,1) * dk(1:ngap,1), ABS(xi(1:ngap,1)) < emin * 1e-2_dp)
  zave(2) = SUM(Z(1:ngap,2) * dk(1:ngap,2), ABS(xi(1:ngap,2)) < emin * 1e-2_dp)
  ave(1) = SUM(dk(1:ngap,1), ABS(xi(1:ngap,1)) < emin * 1e-2_dp)
  ave(2) = SUM(dk(1:ngap,2), ABS(xi(1:ngap,2)) < emin * 1e-2_dp)
  !
  zave(1:2) = zave(1:2) / ave(1:2)
  !
  IF(mpime == 0)  WRITE(*,*) "  Averaged Z_{FS} : ", zave(1:2)
  !
END SUBROUTINE make_Z
!
! Calc Z_{n k}
!
SUBROUTINE make_Z_qpdos()
  !
  USE kinds, ONLY : DP
  USE modes, ONLY : nmodes
  USE klist, ONLY : nks
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_sum
  USE fermisurfer_common, ONLY : b_low, b_high
  USE el_phon, ONLY : elph_nbnd_min, elph_nbnd_max
  !
  USE sctk_val, ONLY : beta, bindx, dk, ggf, kindx, ngap2, nx, omgf, xi, xi0, ZF
  USE sctk_kernel_weight, ONLY : Zweight
  !
  IMPLICIT NONE
  !
  INTEGER :: ik, ib, jgap, jk, jb, im, ix, nks0, nks1
  REAL(dp) :: x, xp, om, tx, txp, tom
  !
  ALLOCATE(ZF(nx,b_low:b_high,nks))
  ZF(1:nx,b_low:b_high,1:nks) = 0.0_dp
  !
  CALL divide(world_comm, nks,nks0,nks1)
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(nx,nks0,nks1,b_low,b_high,nmodes,ngap2,xi,dk,kindx,bindx,ZF,ggf,omgf,xi0,elph_nbnd_min,elph_nbnd_max,beta) &
  !$OMP & PRIVATE(ik, ib, jgap, jk, jb, ix, im, x, xp, om, tx, txp, tom)
  !
  !$OMP DO
  DO ik = nks0, nks1
     !
     DO ib = b_low, b_high
        !
        DO ix = 1, nx
           !
           x = ABS(0.5_dp * beta * xi0(ix))
           tx = tanh(x)
           !
           DO jgap = 1, ngap2
              !
              xp = ABS(xi(jgap,2) * 0.5_dp * beta)
              txp = tanh(xp)
              jk = kindx(jgap,2)
              jb = bindx(jgap,2)
              !
              IF(jb < elph_nbnd_min .OR. elph_nbnd_max < jb) CYCLE
              !
              DO im = 1, nmodes
                 !
                 om = ABS(omgf(im,jk,ik) * 0.5_dp * beta)
                 tom = tanh(om)
                 !    
                 ZF(ix,ib,ik) = ZF(ix,ib,ik) &
                 &        + dk(jgap,2) * ggf(im,jb,jk,ib,ik) &
                 &        * beta**2 * Zweight(x, xp, om, tx, txp, tom)
                 !
              END DO ! im
              !
           END DO ! jgap
           !
           ZF(ix,ib,ik) = - ZF(ix,ib,ik)
           !
        END DO
        !
     END DO ! ib
     !
  END DO ! ik
  !$OMP END DO
  !
  !$OMP END PARALLEL
  !
  CALL mp_sum( ZF, world_comm )
  !
END SUBROUTINE make_Z_qpdos
!
! Calc Z_{n k}
!
SUBROUTINE make_Z_f()
  !
  USE kinds, ONLY : DP
  USE modes, ONLY : nmodes
  USE klist, ONLY : nks
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_sum
  USE fermisurfer_common, ONLY : b_low, b_high
  USE el_phon, ONLY : elph_nbnd_min, elph_nbnd_max
  !
  USE sctk_val, ONLY : beta, bindx, dk, ggf, kindx, ngap2, omgf, xi, ZF
  USE sctk_kernel_weight, ONLY : Zweight_f
  !
  IMPLICIT NONE
  !
  INTEGER :: ik, ib, jgap, jk, jb, im, nks0, nks1
  REAL(dp) :: xp, om, txp, tom
  !
  ALLOCATE(ZF(1,b_low:b_high,nks))
  ZF(1,b_low:b_high,1:nks) = 0.0_dp
  !
  CALL divide(world_comm, nks,nks0,nks1)
  !
  !$OMP PARALLEL DEFAULT(NONE) &
  !$OMP & SHARED(nks0,nks1,b_low,b_high,nmodes,ngap2,xi,dk,kindx,bindx,ZF,ggf,omgf,elph_nbnd_min,elph_nbnd_max,beta) &
  !$OMP & PRIVATE(ik, ib, jgap, jk, jb, im, xp, om, txp, tom)
  !
  !$OMP DO
  DO ik = nks0, nks1
     !
     DO ib = b_low, b_high
        !
        DO jgap = 1, ngap2
           !
           xp = ABS(xi(jgap,2) * beta * 0.5_dp)
           txp = tanh(xp)
           jk = kindx(jgap,2)
           jb = bindx(jgap,2)
           !
           IF(jb < elph_nbnd_min .OR. elph_nbnd_max < jb) CYCLE
           !
           DO im = 1, nmodes
              !
              om = ABS(omgf(im,jk,ik) * beta * 0.5_dp)
              tom = tanh(om)
              !
              ZF(1,ib,ik) = ZF(1,ib,ik) &
              &         + dk(jgap,2) * ggf(im,jb,jk,ib,ik) &
              &         * beta**2 * Zweight_f(xp, om, txp, tom)
              !
           END DO ! im
           !
        END DO ! jgap
        !
        ZF(1,ib,ik) = - ZF(1,ib,ik)
        !       
     END DO ! ib
     !
  END DO ! ik
  !$OMP END DO
  !
  !$OMP END PARALLEL
  !
  CALL mp_sum( ZF, world_comm )
  !
END SUBROUTINE make_Z_f
  !
END MODULE sctk_z
