set :application, "NVC_Serv"
set :repo_url, "git://git.pf.sourceforge.jp/gitroot/h/hm/hmml/nvc_serv.git"
set :scm, :git
set :branch, 'master'
fetch(:default_env).merge!(rails_env: :production)

set :linked_files, fetch(:linked_files, []).push('config/database.yml', 'config/secrets.yml', 'config/initializers/z90_local.rb') 
set :linked_dirs, %w{log tmp/sockets public/system}

namespace :deploy do
  task :fix_asset_perms do
    on roles(:web), in: :sequence do
      execute "chmod o+r -R #{release_path}/public/assets"
    end
  end
  after "deploy:assets:precompile", "deploy:fix_asset_perms"
end

namespace :docker do
  task :build_image do
    puts "Trying to build base image..."
    system *%W(docker build --tag nvc-base .)
  end
end
