package org.dyndns.nuda.logger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.dyndns.nuda.reflect.ClassLoaderUtil;
import org.dyndns.nuda.tools.util.StringUtil;

/**
 * Log4J用ロガーアダプターです
 * 
 * @author nkoseki
 * 
 */
public class LOG4JLoggerAdaptor implements LoggerAdaptor {
	private static Class<?>	loggerClass	= null;
	private static Method	getLogger	= null;
	
	private static Method	debug		= null;
	private static Method	debugT		= null;
	private static Method	info		= null;
	private static Method	infoT		= null;
	private static Method	error		= null;
	private static Method	errorT		= null;
	private static Method	warn		= null;
	private static Method	warnT		= null;
	private static Method	fatal		= null;
	private static Method	fatalT		= null;
	
	private Object			logger		= null;
	
	public LOG4JLoggerAdaptor() {
		if (loggerClass == null) {
			loggerClass = this.getLoggerClass();
			if (loggerClass == null) {
				String message =
					StringUtil.format(
						"以下のクラスが見つかりませんでした[{}]",
						this.getLoggerClassName());
				
				IllegalStateException e = new IllegalStateException(message);
				
				throw e;
			}
			
			this.initLoggerContainer();
			
		}
		this.getLogger("default");
		//		
		//		Logger logger = Logger.getLogger("");
		//		logger.debug("");
		//		logger.info("");
		//		logger.error("");
		//		logger.warn("");
		//		logger.fatal("");
		
	}
	
	public LOG4JLoggerAdaptor(final String loggerName) {
		if (loggerClass == null) {
			loggerClass = this.getLoggerClass();
			if (loggerClass == null) {
				String message =
					StringUtil.format(
						"以下のクラスが見つかりませんでした[{}]",
						this.getLoggerClassName());
				
				IllegalStateException e = new IllegalStateException(message);
				
				throw e;
			}
			
			this.initLoggerContainer();
			this.createLoggerObject(loggerName);
		}
		//		
		//		Logger logger = Logger.getLogger("");
		//		logger.debug("");
		//		logger.info("");
		//		logger.error("");
		//		logger.warn("");
		//		logger.fatal("");
		
	}
	
	private void initLoggerContainer() {
		if (loggerClass != null) {
			try {
				// getLoggerメソッドの作成
				getLogger =
					loggerClass.getDeclaredMethod(
						"getLogger",
						new Class<?>[] { String.class });
				
				Class<?> category = Class.forName("org.apache.log4j.Category");
				
				// debugメソッドの作成
				
				//				Method[] methods = category.getDeclaredMethods();
				//				for (Method m : methods) {
				//					String name = m.getName();
				//					Class<?>[] params = m.getParameterTypes();
				//					StringBuilder b = new StringBuilder();
				//					for (Class<?> param : params) {
				//						b.append(param.getCanonicalName()).append(", ");
				//					}
				//					String paramStr = b.toString();
				//					if (paramStr.length() > 2) {
				//						paramStr = paramStr.substring(0, paramStr.length() - 2);
				//					}
				//					
				//					String mes =
				//						StringUtil.format(
				//							"{}#{}({})",
				//							loggerClass.getCanonicalName(),
				//							name,
				//							paramStr);
				//					System.out.println(mes);
				//				}
				
				debug =
					category
						.getMethod("debug", new Class<?>[] { Object.class });
				debugT =
					category.getDeclaredMethod("debug", new Class<?>[] {
						Object.class,
						Throwable.class });
				
				// infoメソッドの作成
				info =
					category.getDeclaredMethod(
						"info",
						new Class<?>[] { Object.class });
				infoT =
					category.getDeclaredMethod("info", new Class<?>[] {
						Object.class,
						Throwable.class });
				
				// errorメソッドの作成
				error =
					category.getDeclaredMethod(
						"error",
						new Class<?>[] { Object.class });
				errorT =
					category.getDeclaredMethod("error", new Class<?>[] {
						Object.class,
						Throwable.class });
				
				// warnメソッドの作成
				warn =
					category.getDeclaredMethod(
						"warn",
						new Class<?>[] { Object.class });
				warnT =
					category.getDeclaredMethod("warn", new Class<?>[] {
						Object.class,
						Throwable.class });
				
				// fatalメソッドの作成
				fatal =
					category.getDeclaredMethod(
						"fatal",
						new Class<?>[] { Object.class });
				fatalT =
					category.getDeclaredMethod("fatal", new Class<?>[] {
						Object.class,
						Throwable.class });
				
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				e.printStackTrace();
			} catch (ClassNotFoundException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public String getRecommendVersion() {
		return "1.3";
	}
	
	@Override
	public String getLoggerClassName() {
		return "org.apache.log4j.Logger";
	}
	
	@Override
	public Class<?> getLoggerClass() {
		if (ClassLoaderUtil.isClassDefined(this.getLoggerClassName())) {
			try {
				Class<?> loggerClass = Class.forName(this.getLoggerClassName());
				return loggerClass;
			} catch (ClassNotFoundException e) {
				
			}
		}
		
		return null;
	}
	
	@Override
	public LoggerAdaptor getLogger(final String loggerName) {
		LOG4JLoggerAdaptor adaptor = new LOG4JLoggerAdaptor(loggerName);
		adaptor.createLoggerObject(loggerName);
		return adaptor;
	}
	
	private void createLoggerObject(final String loggerName) {
		Object result = null;
		try {
			result = getLogger.invoke(null, new Object[] { loggerName });
			this.logger = result;
		} catch (IllegalArgumentException e) {
		} catch (IllegalAccessException e) {
		} catch (InvocationTargetException e) {
		}
	}
	
	@Override
	public LoggerAdaptor getLogger(final Class<?> targetClass) {
		String className = targetClass.getCanonicalName();
		LoggerAdaptor adaptor = this.getLogger(className);
		return adaptor;
	}
	
	@Override
	public void trace(final String format, final Object... params) {
		
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				debug.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
		
	}
	
	@Override
	public void trace(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				debugT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void debug(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				debug.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void debug(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				debugT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void info(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				info.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void info(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				infoT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void warn(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				warn.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void warn(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				warnT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void error(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				error.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void error(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				errorT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void fatal(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				fatal.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void fatal(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				fatalT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
}
