package org.dyndns.nuda.tools.util.binary;

import java.nio.charset.Charset;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BinaryTest extends TestCase {
	
	@Override
	@Before
	public void setUp() throws Exception {
	}
	
	@Override
	@After
	public void tearDown() throws Exception {
	}
	
	@Test
	public void testBinary01_Error_argument_is_null() {
		try {
			new Binary(null);
		} catch (IllegalArgumentException e) {
			Assert.assertEquals(
				"argument [binaryArray] is NULL",
				e.getMessage());
		}
	}
	
	@Test
	public void testBinary02_Error_argument_is_empty() {
		try {
			new Binary(new byte[0]);
		} catch (IllegalArgumentException e) {
			Assert.assertEquals(
				"argument [binaryArray] is EMPTY",
				e.getMessage());
		}
	}
	
	@Test
	public void testGetSource01_normal() {
		byte[] bytes =
			{ (byte) 0x80, (byte) 0x90, (byte) 0xA0, (byte) 0xB0, (byte) 0xC0 };
		
		Binary binary = new Binary(bytes);
		
		byte[] actual = binary.getSource();
		
		Assert.assertEquals(bytes.length, actual.length);
		int len = bytes.length;
		for (int i = 0; i < len; i++) {
			Assert.assertEquals(bytes[i], actual[i]);
		}
	}
	
	@Test
	public void testGetSource01_abnormal() {
		byte[] bytes =
			{ (byte) 0x80, (byte) 0x90, (byte) 0xA0, (byte) 0xB0, (byte) 0xC0 };
		
		Binary binary = new Binary(bytes);
		
		bytes[0] = (byte) 0xF0;
		
		byte[] actual = binary.getSource();
		
		Assert.assertEquals(bytes.length, actual.length);
		int len = bytes.length;
		for (int i = 0; i < len; i++) {
			if (i == 0) {
				Assert.assertNotSame(
					"(" + bytes[i] + ", " + actual[i] + ")",
					bytes[i],
					actual[i]);
			} else {
				Assert.assertEquals(bytes[i], actual[i]);
			}
			
		}
	}
	
	@Test
	public void testGetBinaryForm01() {
		byte[] bytes = { (byte) 0x80, (byte) 0xCF };
		Binary binary = new Binary(bytes);
		String binForm = binary.getBinaryForm();
		Assert.assertEquals("1000000011001111", binForm);
	}
	
	@Test
	public void testGetBinaryForm02() {
		Binary binary = new Binary(new byte[2]);
		String binForm = binary.getBinaryForm();
		Assert.assertEquals("0000000000000000", binForm);
	}
	
	@Test
	public void testLength01() {
		byte[] bytes = { (byte) 0x80, (byte) 0xCF };
		Binary binary = new Binary(bytes);
		Assert.assertEquals(16, binary.length());
	}
	
	@Test
	public void testLength02() {
		Binary binary = new Binary(new byte[2]);
		Assert.assertEquals(16, binary.length());
	}
	
	@Test
	public void testGetHexForm01() {
		byte[] bytes = { (byte) 0x80, (byte) 0xCF };
		Binary binary = new Binary(bytes);
		Assert.assertEquals("80cf", binary.getHexForm());
	}
	
	@Test
	public void testGetHexForm02() {
		Binary binary = new Binary(new byte[2]);
		Assert.assertEquals("0000", binary.getHexForm());
	}
	
	@Test
	public void testGetHexForm03() {
		byte[] bytes =
			{
				(byte) 0x01,
				(byte) 0x23,
				(byte) 0x45,
				(byte) 0x67,
				(byte) 0x89,
				(byte) 0xAB,
				(byte) 0xCD,
				(byte) 0xEF };
		Binary binary = new Binary(bytes);
		Assert.assertEquals("0123456789abcdef", binary.getHexForm());
	}
	
	@Test
	public void testGet32dForm01() {
		String expected = "028q5cu4qnjff";
		
		byte[] bytes =
			{
				(byte) 0x01,
				(byte) 0x23,
				(byte) 0x45,
				(byte) 0x67,
				(byte) 0x89,
				(byte) 0xAB,
				(byte) 0xCD,
				(byte) 0xEF };
		Binary binary = new Binary(bytes);
		Assert.assertEquals(expected, binary.get32dForm());
		// /!#$%&'()=~|`{+*}?_<>"@-[];:,.@\
	}
	
	public void testDecodeXXX() {
		byte[] bytes =
			{
				(byte) 0x01,
				(byte) 0x23,
				(byte) 0x45,
				(byte) 0x67,
				(byte) 0x89,
				(byte) 0xAB,
				(byte) 0xCD,
				(byte) 0xEF };
		String expected =
			"cmm_seq 		VARCHAR(45)		COLLATE utf8_bin NOT NULL COMMENT 'ユニークキー',";
		bytes = expected.getBytes(Charset.forName("UTF-8"));
		
		Binary bin = new Binary(bytes);
		String t = bin.getBinaryForm();
		String t2 = bin.getHexForm();
		String t3 = bin.get32dForm();
		String t4 = bin.get64dForm();
		
		Binary bin2 = Binary.decode64DFrom(t4);
		if (bin2 != null) {
			String _t = bin2.getBinaryForm();
			Assert.assertEquals("エラー1(64d)", t, _t);
			Assert.assertEquals(
				expected,
				new String(bin2.getSource(), Charset.forName("UTF-8")));
		} else {
			Assert.fail("エラー1");
		}
		
		Binary bin3 = Binary.decode32DFrom(t3);
		if (bin3 != null) {
			String _t = bin3.getBinaryForm();
			Assert.assertEquals("エラー2(32d)", t, _t);
			Assert.assertEquals(
				expected,
				new String(bin3.getSource(), Charset.forName("UTF-8")));
		} else {
			Assert.fail("エラー2");
		}
		
		Binary bin4 = Binary.decode16DFrom(t2);
		if (bin3 != null) {
			String _t = bin4.getBinaryForm();
			Assert.assertEquals("エラー3(16d)", t, _t);
			Assert.assertEquals(
				expected,
				new String(bin4.getSource(), Charset.forName("UTF-8")));
		} else {
			Assert.fail("エラー3");
		}
		
		Binary bin5 = Binary.decode2DForm(t);
		if (bin3 != null) {
			String _t = bin5.getBinaryForm();
			Assert.assertEquals("エラー4(2d)", t, _t);
			Assert.assertEquals(
				expected,
				new String(bin5.getSource(), Charset.forName("UTF-8")));
		} else {
			Assert.fail("エラー4");
		}
	}
	
	@Test
	public void testXXX() {
		byte[] bytes =
			{
				(byte) 0x01,
				(byte) 0x23,
				(byte) 0x45,
				(byte) 0x67,
				(byte) 0x89,
				(byte) 0xAB,
				(byte) 0xCD,
				(byte) 0xEF };
		
		bytes =
			"cmm_seq 		VARCHAR(45)		COLLATE utf8_bin NOT NULL COMMENT 'ユニークキー',"
				.getBytes(Charset.forName("UTF-8"));
		
		Binary bin = new Binary(bytes);
		String t = bin.getBinaryForm();
		String t2 = bin.getHexForm();
		String t3 = bin.get32dForm();
		String t4 = bin.get64dForm();
		
		//		System.out.println("(l=" + t.length() + ")" + t);
		//		System.out.println("(l=" + t2.length() + ")" + t2);
		//		System.out.println("(l=" + t3.length() + ")" + t3);
		//		System.out.println("(l=" + t4.length() + ")" + t4);
		
		Binary bin2 = Binary.decode64DFrom(t4);
		if (bin2 != null) {
			String _t = bin2.getBinaryForm();
			//			System.out.println("decode 64d");
			//			System.out.println("(l=" + _t.length() + ")" + _t);
		} else {
			System.out.println("エラー1");
		}
		
		Binary bin3 = Binary.decode32DFrom(t3);
		if (bin3 != null) {
			String _t = bin3.getBinaryForm();
			//			System.out.println("decode 32d");
			//			System.out.println("(l=" + _t.length() + ")" + _t);
		} else {
			System.out.println("エラー2");
		}
		
		Binary bin4 = Binary.decode16DFrom(t2);
		if (bin3 != null) {
			String _t = bin4.getBinaryForm();
			//			System.out.println("decode 16d");
			//			System.out.println("(l=" + _t.length() + ")" + _t);
		} else {
			System.out.println("エラー3");
		}
		
		Binary bin5 = Binary.decode2DForm(t);
		if (bin3 != null) {
			String _t = bin5.getBinaryForm();
			//			System.out.println("decode 2d");
			//			System.out.println("(l=" + _t.length() + ")" + _t);
		} else {
			System.out.println("エラー4");
		}
		
		Assert.assertTrue(true);
		
	}
}
