package org.dyndns.nuda.logger;

import java.util.LinkedList;
import java.util.List;

public class AutoLoggerAdaptorResolver implements LogAdaptorResolver {
	
	private List<LogAdaptorResolver>	resolvers	=
														new LinkedList<LogAdaptorResolver>();
	
	public static AutoLoggerAdaptorResolver newInstance() {
		return new AutoLoggerAdaptorResolver();
	}
	
	private AutoLoggerAdaptorResolver() {
		this.resolvers.add(new SLF4JLogAdaptorResolver());
		this.resolvers.add(new LOG4JLogAdaptorResolver());
		this.resolvers.add(new JDKLogAdaptorResolver());
		// NOP-Adaptor-Resolverを追加
		this.resolvers.add(new NOPLogAdaptorResolver());
	}
	
	@Override
	public boolean accept() {
		for (LogAdaptorResolver resolver : this.resolvers) {
			boolean result = resolver.accept();
			if (result) {
				return true;
			}
		}
		return false;
	}
	
	@Override
	public LoggerAdaptor getAdaptor() {
		
		for (LogAdaptorResolver resolver : this.resolvers) {
			boolean result = resolver.accept();
			if (result) {
				return resolver.getAdaptor();
			}
		}
		return null;
	}
	
}
