//
//  MSScriptItem.h
//  ScriptItemTest
//
//  Created by 木谷 洋 on 12/03/31.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum
{
    eInputModeNone = 0,
    eInputModeSelection,
    eInputModeAll,
} eScriptItemInputMode;

typedef enum
{
    eOutputModeDiscard = 0,
    eOutputModeReplaceSelection,
    eOutputModeReplaceAll,
    eOutputModeInsertAfter,
    eOutputModeAppend,
    eOutputModePasteboard,
} eScriptItemOutputMode;


// class cluster
@interface MSScriptItem : NSObject
+ (id)itemWithURL:(NSURL*)aURL;
+ (id)itemsOfDirectoryAtURL:(NSURL*)aURL; // menu structure constructor
+ (void)setAction:(SEL)aSelector;
- (NSString*)name;
- (NSURL*)URL;
- (NSMenuItem*)menuItem;
@end

@interface MSScriptActionItem : MSScriptItem
- (NSString*)keyEquivalent;
- (NSInteger)modifierFlag;
- (eScriptItemInputMode)inputMode;
- (eScriptItemOutputMode)outputMode;
@end

@interface MSScriptSubmenuItem : MSScriptItem
- (NSArray*)subItems;
@end

@interface MSScriptSeparatorItem : MSScriptItem
@end
