//
//  MSDocument.h
//  Manuscript
//
//  Created by 二鏡 on 12/01/30.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import <Cocoa/Cocoa.h>
#import "MSScriptItem.h"

@class MSScriptExecutor;
@class MSLayoutBlockManager;
@class MSPager;
@class MSTextView;

@interface MSDocument : NSDocument 
{
    MSLayoutBlockManager *content;
    MSPager *pager;
    IBOutlet MSTextView *textView;
    
    IBOutlet NSPopUpButton *fontFamily;
    IBOutlet NSPopUpButton *fontFace;
    struct 
    {
        NSRange selection;
    } initialState;
    
    struct {
        MSScriptExecutor *executor;
        eScriptItemOutputMode writebackMode;
    } script;
}
@property (readwrite) NSInteger encoding;
- (NSDictionary*)fileInfo;
- (NSAttributedString*)normalizeAttributedString:(NSAttributedString*)aStr;

- (IBAction)fontFamilyChanged:(id)sender;
- (IBAction)fontFaceChanged:(id)sender;
- (IBAction)abortScript:(id)sender;
- (IBAction)runScript:(id)sender;
@end
