/*
 *  CompiledAttributedString.h
 *  Manuscript
 *
 *  Created by 二鏡 on 11/03/17.
 *  Copyright 2011 二鏡庵. All rights reserved.
 *
 */
#import <Cocoa/Cocoa.h>
#include <vector>

using namespace std;

struct AttributesSet
{
    NSFont *font;
    NSColor *foregroundColor;
    NSColor *backgroundColor;
    
    uint32_t underlineStyle;
    uint32_t strikethroughStyle;
    NSColor *underlineColor;
    NSColor *strikethroughColor;
    int segment;
    NSString *ruby;
};

typedef pair<CFRange,AttributesSet> AttributesAdapter;

struct CompiledAttributedString
{
    vector<unichar> characters;
    vector<AttributesAdapter> attributes;
    
    void compile(NSAttributedString *aStr);
    inline BOOL closed() const
    {
        if(characters.empty())
            return NO;
        
        unichar last = *(characters.end()-1);
        CFCharacterSetRef newlineSet = CFCharacterSetGetPredefined(kCFCharacterSetNewline);
        return CFCharacterSetIsCharacterMember(newlineSet, last);
    }
    inline NSString *
    substring_in_range(CFRange range) const
    {
        return [NSString stringWithCharacters: &characters[0]+range.location
                                       length: range.length];
    }
    inline CFIndex 
    length() const
    {
        return characters.size();
    }
    CompiledAttributedString() {};
    CompiledAttributedString(NSAttributedString* aStr)
    {
        this->compile(aStr);
    }
    NSString *description() const
    {
        return [NSString stringWithCharacters: &characters[0]
                                       length: characters.size()];
    }
};