//
//  VerticalGlyphLocator.mm
//  Manuscript
//
//  Created by 二鏡 on 11/07/29.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#include "VerticalGlyphLocator.h"


NSString *ParserNoEnoughSpaceException = @"ParserNoEnoughSpaceException";


uint32_t 
VerticalGlyphLocator::locateGlyphsPropotionallyByCentering(CFRange range, 
                                                                CGFloat x,
                                                                CGFloat y)
{
    const vector<CGSize>& advances = advances_();
    CGFloat realWidth = 0.0;
    CGFloat virtualWidth;
    
    for(CFIndex i=range.location;i<range.location+range.length;i++)
    {
        realWidth += advances[i].width;
    }
    
    CGFloat boxWidth = boxState.getBoxWidth();
    uint32_t boxCount = (uint32_t)ceil(realWidth/boxWidth);
    virtualWidth = boxCount*boxWidth;
    
    // advance start offset from y
    y -= (virtualWidth-realWidth)/2.0;
    _locateGlyphsPropotionally(range,x,y,kCTFontVerticalOrientation);    
    return boxCount;
}

// 行が完了したらtrueを返す。
bool
VerticalGlyphLocator::analyzeGlyphsInRange(CFRange range)
{
    const vector<uint8>& characterAttribute = characterAttribute_();
    const vector<CGSize>& advances = advances_();
    CFIndex i;
    CFIndex start = range.location;
    CFIndex limit = range.location+range.length;
    shouldHyphenation = false;
    
    for(i=start;i<limit;i++)
    {
        uint8_t cAttr = characterAttribute[i];
        
        // 改行文字
        if(isStrongBreak(cAttr))
        {
            // ここまでの文字を確定
            stabilizeCurrentChainIfNeed();
            stabilizeNewline(i);
            return true;
        }
        
        // 全角文字
        if(isFixedWidth(cAttr))
        {
            // chainを確定
            stabilizeCurrentChainIfNeed();
            
            if(boxState.isBoxRemaining())
            {
                stabilizeFullGlyph(i);
                continue;
            }
            
            // boxに余裕なし
            if(boxState.isAnchorLocation(i))
            {
                raiseNoEnoughSpaceException();
            }
            else
            {
                // i-1でbreak
                // chainは上で確定しているのでここでやることはない
                // stabilizedで行範囲が見られる
                return true;
            }
        }
        
        // 半角文字
        CGFloat width = advances[i].width;
        if(boxState.canPutPropotionalGlyph(width))
        {
            if(chainState.isChaining())
            {
                chainState++;
            }
            else
            {
                startChainAtIndex(i);
            }
            boxState.take1Glyph(width);
            continue;
        }
        else
        {   
            // もう入らない
            // breakPointまで追い込み
            
            // そもそも一文字も入らない行状態ならば例外
            if(boxState.isAnchorLocation(i))
            {
                raiseNoEnoughSpaceException();
            }
            
            // 現在半角文字列をレイアウト途中
            if(chainState.isChaining())
            {
                // Lionスペシャル
                // 組み込みのハイフン処理を当てにする実験
                CFIndex hypen = _findHyphenation(chainState.getRange());
                if(hypen != kCFNotFound)
                {
                    chainState.cutChainToIndex(hypen);
                    shouldHyphenation = true;
                }
                else
                {
                    // 一応旧コードも混ぜておく
                    // 改行候補を探し、あったらそこまででカット
                    // なければそのまま採用
                    CFIndex lastWeakBreak = _findLastWeakBreak(chainState.getRange());
                    if(lastWeakBreak != kCFNotFound)
                    {
                        chainState.cutChainToIndex(lastWeakBreak);
                    }
                }           
                stabilizeCurrentChain();
            }
            return true;
        }
    }
    return false;
}
