//
//  MSMainController.m
//  Manuscript
//
//  Created by 二鏡 on 12/03/22.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import "MSMainController.h"
#import "MSDocument.h"
#import "Defaults.h"
#import "MSPreferencesPanelController.h"
#import "MSScriptItem.h"

extern NSString *udFileInfoMap;

@implementation MSMainController
+ (id)applicationSupportFolder
{
    id fm = [NSFileManager defaultManager];
    id URL = [[fm URLsForDirectory: NSApplicationSupportDirectory
                         inDomains: NSUserDomainMask] objectAtIndex: 0];
    URL = [URL URLByAppendingPathComponent: @"Manuscript"];
    return URL;
}

+ (id)scriptFolder
{
    id url = [self applicationSupportFolder];
    return [url URLByAppendingPathComponent: @"Script"];
}

- (void)applicationWillFinishLaunching:(id)notif
{
    register_defaults();
    id fm = [NSFileManager defaultManager];
    id url = [MSMainController scriptFolder];
    [MSScriptActionItem setAction: @selector(runScript:)];
    
    // application support folderを保証
    [fm createDirectoryAtURL: url
 withIntermediateDirectories: YES 
                  attributes: nil
                       error: nil];
    [self rebuildScriptMenu: self];
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
    id docs = [NSApp orderedDocuments];
    id map = [NSMutableDictionary dictionary];
    for(MSDocument *doc in docs)
    {
        // encoding mapping. filename => encoding value
        id key = [[doc fileURL] path];
        id fileInfo = [doc fileInfo];
        if(key)
            [map setObject: fileInfo forKey: key];
    }
    
    id ud = [NSUserDefaults standardUserDefaults];
    [ud setObject: map forKey: udFileInfoMap];
    // マップ全体を上書きするので、不定の理由で消滅した書類の情報は自動的に消える
}

- (IBAction)showPreferences:(id)sender
{
    id panel = [MSPreferencesPanelController sharedPanel];
    [panel showWindow: self];
}

- (IBAction)rebuildScriptMenu:(id)sender
{
    id mainMenu = [NSApp mainMenu];
    id scriptMenu = [[mainMenu itemWithTag: gScriptMenuTag] submenu];
    
    // 古いメニューを削除
    {
        id items = [scriptMenu itemArray];
        for(id item in items)
        {
            if([item tag] != gScriptMenuDefaultItemTag)
                [scriptMenu removeItem: item];
        }
    }
    
    id scriptItems = [MSScriptItem itemsOfDirectoryAtURL: [[self class] scriptFolder]];
    NSUInteger i = 0;
    for(id aScriptItem in scriptItems)
    {
        id aMenuItem = [aScriptItem menuItem];
        [scriptMenu insertItem: aMenuItem atIndex: i++];
    }
}

- (IBAction)openScriptFolder:(id)sender
{
    id url = [[self class] scriptFolder];
    id ws = [NSWorkspace sharedWorkspace];
    [ws openURL: url];
}

@end
