//
//  MSFontServices.m
//  Manuscript
//
//  Created by 二鏡 on 12/03/23.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import "MSFontServices.h"
#import "Defaults.h"

@implementation MSFontServices
+ (NSArray*)facesForFamily:(NSString*)family
{
    id fontManager = [NSFontManager sharedFontManager];
    id members = [fontManager availableMembersOfFontFamily: family];
    
    // faceのリストを作る
    id ret = [NSMutableArray array];
    for(id member in members)
    {
        [ret addObject: [member objectAtIndex: 1]];
    }
    
    return [ret copy];
}

+ (NSString*)fontNameWithFamily:(NSString*)family
                            face:(NSString*)face
{
    id attr = [NSDictionary dictionaryWithObjectsAndKeys:
               family, NSFontFamilyAttribute,
               face, NSFontFaceAttribute,
               nil];
    id fd = [[NSFontDescriptor alloc] initWithFontAttributes: attr];
    return [fd postscriptName];
}

+ (NSString*)defaultFontDisplayName
{
    id ud = [NSUserDefaults standardUserDefaults];
    id family = [ud stringForKey: udFontFamily];
    id face   = [ud stringForKey: udFontFace];
    CGFloat size = [ud floatForKey: udFontSize];
    id font = [NSFont fontWithName: [self fontNameWithFamily: family face: face]
                              size: size];
    id name = [font displayName];
    id ret = [NSString stringWithFormat: @"%@ %.1fpt", name, size];
    return ret;
}

+ (NSFont*)defaultFont
{
    id ud = [NSUserDefaults standardUserDefaults];
    id family = [ud stringForKey: udFontFamily];
    id face   = [ud stringForKey: udFontFace];
    CGFloat size = [ud floatForKey: udFontSize];
    id font = [NSFont fontWithName: [self fontNameWithFamily: family face: face]
                              size: size];
    return font;
}

+ (void)registerDefaultFontWithName:(NSString*)fontName
                               face:(NSString*)faceName
                               size:(CGFloat)size
{
    id ud = [NSUserDefaults standardUserDefaults];
    [ud setObject: fontName forKey: udFontFamily];
    [ud setObject: faceName forKey: udFontFace];
    [ud setFloat: size forKey: udFontSize];
}
@end
