//
//  MSFindPanelController.h
//  Fumizuki
//
//  Created by 二鏡 on 11/09/08.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class MSTextView;

typedef enum {
    eAllTextMode = 0,
    eSelectionMode = 1,
} eFindTargetMode;

@interface MSFindPanelController : NSWindowController
{
    // bind source
    NSString *searchString;
    NSString *replaceString;
    BOOL isPatternTouched;
    
    NSString *matchStatus; // n matchs表示用の文字列
    eFindTargetMode targetMode;
    BOOL useRegularExpression;
    BOOL ignoreCase;

    NSRegularExpression *regexp;
    NSString *replaceTemplate;
    NSMutableArray *matches;
    NSMutableIndexSet *invalidIndexes;
    CFIndex currentMatch;
    
    // target context
    struct {
        MSTextView *textView;
        NSTextStorage *storage;
    } _target;
}
@property (readwrite,copy) NSString *searchString;
@property (readwrite,copy) NSString *replaceString;
@property (readonly,copy) NSString *matchStatus;
@property (readwrite,assign) eFindTargetMode targetMode;
@property (readwrite,assign) BOOL useRegularExpression;
@property (readwrite,assign) BOOL ignoreCase;
@property (readonly) BOOL hasMatch;

+ (id)sharedFindPanel;
- (IBAction)updateSearchString:(id)sender;
- (IBAction)updateReplaceString:(id)sender;
- (IBAction)changeSearchRange:(id)sender;
- (IBAction)replaceAll:(id)sender;
- (IBAction)replace:(id)sender;
- (IBAction)replaceAndFindNext:(id)sender;
- (IBAction)search:(id)sender;
- (IBAction)previous:(id)sender;
- (IBAction)next:(id)sender;
@end
