//
//  MSDocumentController.m
//  Manuscript
//
//  Created by 二鏡 on 12/03/22.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import "MSDocumentController.h"

@implementation MSDocumentController
@synthesize selectedEncoding;
- (void)openDocument:(id)sender
{
    [super openDocument: sender];
    self.selectedEncoding = [encodings selectedTag];
}

- (void)openDocumentWithContentsOfURL:(NSURL *)url display:(BOOL)displayDocument completionHandler:(void (^)(NSDocument *, BOOL, NSError *))completionHandler
{
    [super openDocumentWithContentsOfURL: url display:displayDocument completionHandler: completionHandler];
    self.selectedEncoding = 0;
}

- (void)reopenDocumentForURL:(NSURL *)urlOrNil withContentsOfURL:(NSURL *)contentsURL display:(BOOL)displayDocument completionHandler:(void (^)(NSDocument *document, BOOL documentWasAlreadyOpen, NSError *error))completionHandler
{
    [super reopenDocumentForURL: urlOrNil withContentsOfURL: contentsURL display:displayDocument completionHandler: completionHandler];
}

- (NSInteger)runModalOpenPanel:(NSOpenPanel *)openPanel forTypes:(NSArray *)types 
{
    NSInteger result;
    
    [openPanel setAccessoryView: accessoryView];
    result = [super runModalOpenPanel: openPanel forTypes: types];
    
    return result;
}
@end
