//
//  ConfigurationManager.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/25.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *ConfigurationManagerInitilizeFailureException;

@interface NSObject (ObjectIDContainer)
- (NSManagedObjectID*)objectID;
@end

@interface ConfigurationManager : NSObject
{
    NSManagedObjectContext *context;
}
@property (readonly) NSManagedObjectContext *context;

// transitions
- (NSArray*)transitions;
- (NSManagedObject*)currentTransition;
- (void)setCurrentTransition:(NSManagedObject*)obj;
- (NSManagedObject*)insertNewTransition;

// container support
- (NSManagedObject*)fetchItem:(id)container;
- (void)deleteItem:(id)container;

- (BOOL)save:(NSError**)error;
@end
