//
//  ECScene.h
//  SceneRenderProto
//
//  Created by 二鏡 on 11/11/14.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ECLayer.h"

extern NSString *gSceneFileExtension;
extern NSString *ECPasteboardTypeScene;

@interface ECScene : NSObject <NSPasteboardReading, NSPasteboardWriting, NSCoding, NSCopying>
{
    NSUndoManager *undo; // can be nil
    NSMapTable *currentUndoGroupMapping;
    
    NSSize size;
    NSMutableArray *layers; // top -> bottomのオーダー
    CGColorRef backgroundColor;
}

+ (NSString*)pathComponent:(NSString*)body;
+ (NSString*)templateName0;
+ (NSString*)templateNameWithCount:(NSUInteger)val;

- (id)initWithSize:(NSSize)aSize;
- (id)initWithContentsOfURL:(NSURL*)aURL;
+ (NSSize)sizeOfContentsOfURL:(NSURL*)aURL;

@property (readonly) NSSize size;
@property (readwrite,copy) NSColor *backgroundColor;
@property (readonly) BOOL isStatic; // アニメーションの無い静的シーンはYES
@property (readonly) BOOL update;
@property (readwrite) BOOL lightPreview;
@property (nonatomic,readwrite,assign) NSUndoManager *undo;

- (NSArray*)layers;
- (NSUInteger)countOfLayers;
- (id)objectInLayersAtIndex:(NSUInteger)i;
- (void)insertObject:(ECLayer*)aLayer
     inLayersAtIndex:(NSUInteger)i;
- (void)removeObjectFromLayersAtIndex:(NSUInteger)i;
- (void)addLayersObject:(ECLayer*)aLayer;
- (void)removeLayersObject:(ECLayer*)aLayer;
- (void)exchangeLayerObjectAtIndex:(NSUInteger)i
                 withObjectAtIndex:(NSUInteger)j;

// support
- (ECLayer*)layerAtPoint:(NSPoint)aPoint;
- (CGSize)recommendSizeForImageSize:(CGSize)imgSize; // イメージが枠内に収まるように縮小する時の計算
- (NSString*)nextLayerName;

// view service
// 編集用の表示メソッド。renderInContextを用いる
- (void)drawSceneWithContext:(CGContextRef)aContext;

// 出力用の表示メソッド
- (CGImageRef)allocImageAtTime:(NSUInteger)msec;
- (CGImageRef)allocSnapshot:(CGFloat)ratio; // thumbnail生成用
- (void)cleanupRendering; // 各レイヤーに通達

- (BOOL)atomicWriteToURL:(NSURL*)aURL; // project用の衝突判定をしないメソッド
- (BOOL)writeToURL:(NSURL*)aURL;     // シーンファイルを単独で書き出す為のメソッド

// リソース移動
- (void)resolveTemporaryResources;
@end


@interface ECScene (RegularLayerSupport)
- (NSUInteger)longestTextLength;
@end
