//
//  ECQCCompositionItem.m
//  Etokicho
//
//  Created by 二鏡 on 11/11/27.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import "ECQCCompositionItem.h"

@implementation ECQCCompositionItem
@synthesize parameters, identifier;
+ (id)itemWithRenderer:(QCRenderer*)renderer
{
    if(renderer == nil)
        return nil;
    
    ECQCCompositionItem *item = [[[self alloc] init] autorelease];
    id composition = [renderer composition];
    item.identifier = [composition identifier];
    id plist = [[renderer propertyListFromInputValues] mutableCopy];

    // イメージのデータは削除する
    [plist removeObjectForKey: QCCompositionInputSourceImageKey];
    [plist removeObjectForKey: QCCompositionInputDestinationImageKey];
    [plist removeObjectForKey: QCCompositionInputImageKey];
    
    item.parameters = plist;
    [plist release];
    return item;
}

- (id)initWithCoder:(NSCoder *)coder 
{
    if([coder allowsKeyedCoding])
    {
        self.identifier = [coder decodeObjectForKey: @"identifier"];
        self.parameters = [coder decodeObjectForKey: @"parameters"];
    }
    else
    {
        self.identifier = [coder decodeObject];
        self.parameters = [coder decodeObject];
    }
    return self;
}

- (void)encodeWithCoder:(NSCoder *)encoder
{
    if([encoder allowsKeyedCoding])
    {
        [encoder encodeObject: self.identifier forKey: @"identifier"];
        [encoder encodeObject: self.parameters forKey: @"parameters"];
    }
    else
    {
        [encoder encodeObject: self.identifier];
        [encoder encodeObject: self.parameters];
    }
}

- (id)copyWithZone:(NSZone *)zone
{
    ECQCCompositionItem *item = [[ECQCCompositionItem allocWithZone: zone] init];
    item.identifier = self.identifier;
    item.parameters = self.parameters;
    return item;
}

- (void)dealloc
{
    self.parameters = nil;
    self.identifier = nil;
    [super dealloc];
}

- (QCComposition*)loadComposition
{
    id repository = [QCCompositionRepository sharedCompositionRepository];
    return [repository compositionWithIdentifier: self.identifier];
}

- (void)apply:(id <QCCompositionRenderer>)renderer
{
    [renderer setInputValuesWithPropertyList: self.parameters];
}
@end
