//
//  ECTransitionSampleView.m
//  Etokicho
//
//  Created by 二鏡 on 11/11/25.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import "ECTransitionSampleView.h"

static NSString *oTransitionContext = @"transition";

@implementation ECTransitionSampleView
@synthesize transition, renderer;

- (BOOL)isOpaque
{
    return YES;
}

- (BOOL)acceptsFirstResponder
{
    return YES;
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
    return YES;
}

- (void)mouseDown:(NSEvent *)theEvent
{
    
}

- (void)drawRect:(NSRect)dirtyRect
{
    [[NSColor blackColor] set];
    NSRectFill(dirtyRect);

    if([renderer renderAtTime: transition arguments: nil])
    {
        NSImage *image = [renderer createSnapshotImageOfType: @"NSImage"];
        NSSize size = [image size];
        NSRect bounds = [self bounds];
        CGFloat x = NSMidX(bounds)-size.width/2;
        CGFloat y = NSMidY(bounds)-size.height/2;
        NSRect rect = NSMakeRect(x,y,size.width,size.height);
        [image drawInRect: rect
                 fromRect: NSZeroRect 
                operation: NSCompositeSourceOver
                 fraction: 1.0];
        [image release];
    }
}

- (CGSize)recommendSize:(CGSize)size
{
    NSRect bounds = [self bounds];
    
    // 縮小率を計算
    CGFloat scale_w = NSWidth(bounds)/size.width;
    CGFloat scale_h = NSHeight(bounds)/size.height;
    
    // 小さい方に合わせる
    CGFloat scale = MIN(scale_w,scale_h);
    CGFloat scaled_width = floor(size.width*scale);
    CGFloat scaled_height = floor(size.height*scale);

    return CGSizeMake(scaled_width,scaled_height);
}
@end
