//
//  ECDTimeline.m
//  Etokicho
//
//  Created by 二鏡 on 11/12/06.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import "ECDTimeline.h"
#import "ECDSegment.h"
#import "ECDTransitionSegment.h"
#import "ECDSceneSegment.h"

@interface ECDTimeline (AutoGenerated)
- (id)primitiveSegments;
- (void)setPrimitiveSegments:(id)val;
@end

@implementation ECDTimeline
+ (NSSet*)keyPathsForValuesAffectingValueForKey:(NSString *)key
{
    if([key isEqualToString: @"sceneCount"])
        return [NSSet setWithObject: @"segments"];
    if([key isEqualToString: @"transitionCount"])
        return [NSSet setWithObject: @"segments"];
    
    return [super keyPathsForValuesAffectingValueForKey: key];
}

@dynamic fps;
@dynamic segments;

/* 
 * 自動生成コードがイマイチ怪しいので自前記述
 */
- (void)insertObject:(ECDSegment *)value inSegmentsAtIndex:(NSUInteger)idx
{
    NSIndexSet *change = [NSIndexSet indexSetWithIndex: idx];
    [self willChange: NSKeyValueChangeInsertion
     valuesAtIndexes: change
              forKey: @"segments"];
    
    id set = [self primitiveSegments];
    [set insertObject: value
              atIndex: idx];
    
    [self didChange: NSKeyValueChangeInsertion
    valuesAtIndexes: change
             forKey: @"segments"];
    
}

- (void)insertSegments:(NSArray *)value atIndexes:(NSIndexSet *)indexes
{
    [self willChange: NSKeyValueChangeInsertion
     valuesAtIndexes: indexes
              forKey: @"segments"];
    
    id set = [self primitiveSegments];
    [set insertObjects: value
             atIndexes: indexes];
    
    [self didChange: NSKeyValueChangeInsertion
    valuesAtIndexes: indexes
             forKey: @"segments"];
}

- (void)replaceObjectInSegmentsAtIndex:(NSUInteger)idx 
                            withObject:(ECDSegment *)value
{
    NSIndexSet *change = [NSIndexSet indexSetWithIndex: idx];
    [self willChange: NSKeyValueChangeReplacement
     valuesAtIndexes: change
              forKey: @"segments"];
    
    id set = [self primitiveSegments];
    [set replaceObjectAtIndex: idx withObject: value];
    
    [self didChange: NSKeyValueChangeReplacement
    valuesAtIndexes: change
             forKey: @"segments"];
}

- (void)removeSegmentsAtIndexes:(NSIndexSet *)indexes
{
    [self willChange: NSKeyValueChangeRemoval
     valuesAtIndexes: indexes
              forKey: @"segments"];
    
    id set = [self primitiveSegments];
    [set removeObjectsAtIndexes: indexes];
    
    [self didChange: NSKeyValueChangeRemoval
    valuesAtIndexes: indexes
             forKey: @"segments"];
}

- (void)addSegmentsObject:(ECDSegment *)value
{
    NSIndexSet *change = [NSIndexSet indexSetWithIndex: [self.segments count]];
    [self willChange: NSKeyValueChangeInsertion
     valuesAtIndexes: change
              forKey: @"segments"];
    
    id set = [self primitiveSegments]; // mutable ordered set
    [set addObject: value];

    [self didChange: NSKeyValueChangeInsertion
    valuesAtIndexes: change
             forKey: @"segments"];
}

- (void)addSegments:(NSArray *)values
{
    NSRange range = NSMakeRange([self.segments count], [values count]);
    NSIndexSet *change = [NSIndexSet indexSetWithIndexesInRange: range];

    [self willChange: NSKeyValueChangeInsertion
     valuesAtIndexes: change
              forKey: @"segments"];

    id set = [self primitiveSegments];
    [set addObjectsFromArray: values];

    [self didChange: NSKeyValueChangeInsertion
    valuesAtIndexes: change
             forKey: @"segments"];
}
@end

@implementation ECDTimeline (Statics)
- (NSUInteger)sceneCount
{
    id segments = [self.segments array];
    Class cls = [ECDSceneSegment class];
    NSUInteger ret = 0;
    for(id seg in segments)
    {
        if([seg isKindOfClass: cls])
            ret++;
    }
    return ret;
}

- (NSUInteger)transitionCount
{
    id segments = [self.segments array];
    Class cls = [ECDTransitionSegment class]; 
    NSUInteger ret = 0;
    for(id seg in segments)
    {
        if([seg isKindOfClass: cls])
            ret++;
    }
    return ret;    
}
@end

