//
//  ECDSegment.m
//  Etokicho
//
//  Created by 二鏡 on 11/12/06.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import "ECDSegment.h"
#import "ECDTimeline.h"

NSString *plistSegmentMsecKey = @"msec";
NSString *plistSegmentTypeKey = @"SegmentType";

static NSString *propertyListFile = @"info.plist";
NSString *ECDPasteboardTypeSegment = @"com.mac.nikyo-an.etokicho.pasteboard.segment";

@implementation ECDSegment

@dynamic msec;
@dynamic timeline;

@synthesize lightPreview;
+ (NSString*)segmentType
{
    return @""; // abstruct
}

+ (id)standardRenderAttributes
{
    return [NSDictionary dictionaryWithObjectsAndKeys: 
            @"png ", QTAddImageCodecType,
            [NSNumber numberWithInt: codecLosslessQuality], QTAddImageCodecQuality,
            nil];
}

+ (CGImageRef)allocBlackImage:(CGSize)size
{
    size_t w = size.width;
    size_t h = size.height;
    size_t bitsPerComponent = 8; // 32bits color = 8bits per component
    size_t bytesPerRow = w*4;    // w * 4bytes per pixel
    CGRect rect = CGRectMake(0,0,size.width,size.height);
    
    CGColorSpaceRef cs = CGColorSpaceCreateWithName(kCGColorSpaceGenericRGB);
    CGBitmapInfo info = kCGImageAlphaPremultipliedFirst | kCGBitmapByteOrderDefault;
    CGContextRef context = CGBitmapContextCreate(NULL, w, h, bitsPerComponent, bytesPerRow, cs, info);
    CGColorSpaceRelease(cs);
    
    CGColorRef blackColor = CGColorGetConstantColor(kCGColorBlack);
    CGContextSetFillColorWithColor(context, blackColor);
    CGContextFillRect(context, rect);
    CGContextFlush(context);
    
    CGImageRef blackImage = CGBitmapContextCreateImage(context);
    CGContextRelease(context);
    return blackImage;
}

+ (NSURL*)propertyListForLocation:(NSURL*)URL
{
    return [URL URLByAppendingPathComponent: propertyListFile];
}

+ (id)attachSegmentWithContentsOfURL:(NSURL*)URL
                           inContext:(NSManagedObjectContext*)context
{
    id plistFile = [self propertyListForLocation: URL];
    id plist = [NSDictionary dictionaryWithContentsOfURL: plistFile];
    id type = [plist objectForKey: plistSegmentTypeKey];
    
    id entity = [NSEntityDescription entityForName: type
                            inManagedObjectContext: context];
    NSString *className = [entity managedObjectClassName];
    Class entityClass = [[NSBundle mainBundle] classNamed:className];
    
    id ret = [[entityClass alloc] initWithEntity: entity
                  insertIntoManagedObjectContext: context];
    
    return [[ret loadContentsOfURL: URL
                      propertyList: plist
                         inContext: context] autorelease];
}

// secondary initialization
- (id)loadContentsOfURL:(NSURL*)URL
           propertyList:(NSDictionary*)plist
              inContext:(NSManagedObjectContext*)context
{
    return self;
}

- (BOOL)writeToURL:(NSURL*)URL
{
    return NO;
}

- (void)resolveTemporaryResources
{
    
}

- (void)insertSegment:(QTMovie*)aMovie
            frameRate:(NSUInteger)fps
                 size:(NSSize)aSize
{
    // abstruct
}

- (void)cleanup
{
    // abstruct
}

- (id)valueForUndefinedKey:(NSString *)key
{
    return NSNotApplicableMarker;
}

- (id)cloneInContext:(NSManagedObjectContext*)context
{
    id entity = [self entity];
    ECDSegment *ret = [[[self class] alloc] initWithEntity: entity
                            insertIntoManagedObjectContext: context];
    ret.msec = self.msec;
    // timelineはこの段階でコピーしてはならない
    return [ret autorelease];
}
@end
