//
//  ECStoryboardView.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/21.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <QuartzCore/QuartzCore.h>

extern NSString *ECStoryBoardViewLayerSegmentRequestNotification;
// @"segment" key -> requested segment

@class ECStoryboardView;

@protocol ECStoryboardViewDelegate
- (void)deleteSelection:(ECStoryboardView*)sender;
- (void)copySelection:(ECStoryboardView*)sender;
- (void)pasteOnSelection:(ECStoryboardView*)sender;
- (void)pasteAfterSelection:(ECStoryboardView*)sender;
- (void)pasteBeforeSelection:(ECStoryboardView*)sender;
@end

// content
@interface ECStoryboardView : NSView
{
    // layers
    NSMapTable *layerTable;
    NSMapTable *reverseTable;
    CATextLayer *emptyLayer;
    
    // content
    // bind with NSArray of segments
    struct {
        id obj;
        NSString *keyPath;
    } content;
    
    // selectedIndexes
    // bind with NSIndexSet
    struct {
        id obj;
        NSString *keyPath;
    } selection;
    
    struct {
        NSUInteger prev;
        BOOL dragging;
        NSPoint start;
    } click;
    
    struct {
        NSUInteger start; // キーによるselection移動時に起点とするindex
    } keyMove;
    
    CGSize minSize;
    CGImageRef transitionImage;
    
    id target;
    SEL action;
    SEL doubleAction;
    
    id <ECStoryboardViewDelegate> delegate;
}
@property (readwrite,assign) id <ECStoryboardViewDelegate> delegate;
@property (readwrite,assign) id target;
@property (readwrite) SEL action;
@property (readwrite) SEL doubleAction;
- (void)attachEmptyLayerIfNeed;
- (void)detachEmptyLayer;

- (IBAction)deselect:(id)sender;
- (IBAction)pasteAfter:(id)sender;
- (IBAction)pasteBefore:(id)sender;
@end

