#include <CoreFoundation/CoreFoundation.h>
#include <CoreServices/CoreServices.h>
#include <QuickLook/QuickLook.h>

/* -----------------------------------------------------------------------------
    Generate a thumbnail for file

   This function's job is to create thumbnail for designated file as fast as possible
   ----------------------------------------------------------------------------- */

OSStatus GenerateThumbnailForURL(void *thisInterface, QLThumbnailRequestRef thumbnail, CFURLRef url, CFStringRef contentTypeUTI, CFDictionaryRef options, CGSize maxSize)
{
    CGImageRef image;
    CFURLRef thumbnailURL = CFURLCreateCopyAppendingPathComponent(NULL, url, CFSTR("thumbnail.jpg"), false);
    CGImageSourceRef src = CGImageSourceCreateWithURL(thumbnailURL, nil);
    CFRelease(thumbnailURL);
    if(src == nil)
    {
        return noErr;
    }
    
    image = CGImageSourceCreateImageAtIndex(src, 0, nil);
    CFRelease(src);
    if(image)
    {
        QLThumbnailRequestSetImage(thumbnail, image, nil);
        CFRelease(image);
    }
    
    return noErr;
}

void CancelThumbnailGeneration(void* thisInterface, QLThumbnailRequestRef thumbnail)
{
    // implement only if supported
}
