#include "tim.h"
#include "it3_common.h"
#include <depend.h>
#include "kernel.h"
#include "que_ctl.h"

#include "alm.h"
#include "cyc.h"

static UINT last_time = 0;
SYSTIME systime = {0, 0};

ER tim_initialize(void)
{
	return E_OK;
}

void tim_terminate(void)
{
}

/* ^CCxgnh */
ER tim_event(void)
{
	int steptime, now_time;

	/* ݎ擾 */
	now_time = depend_get_time();

	/* oߎԂZo */
	steptime = now_time - last_time;

	systime.ltime += steptime;

	/* A[^C} */
	alm_timeevent(steptime);

	/* ^C} */
	cyc_timeevent(steptime);

	/* ݎۑ */
	last_time = now_time;

	return E_OK;
}

/* ^CeBbN̋ */
ER isig_tim(void)
{
	systime.ltime += 1;		/* invoked every 1msec */
	if(systime.ltime < 1)
	{
		systime.utime++;
	}

	os_timer();

	return E_OK;
}

ER set_tim(SYSTIME *pk_tim)
{
	depend_EnterCriticalSection();

	systime = *pk_tim;

	depend_LeaveCriticalSection();

	return E_OK;
}

/* VXe̎Q */
ER get_tim(SYSTIME *p_systim)
{
	ER result;

	if(ISVALID_PTR(p_systim))
	{
		*p_systim = systime;

		result = E_OK;
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

/* ^XN̒x */
ER dly_tsk(DLYTIME dlytim)
{
	ER ercd;
	T_TCB *p_tcb;

//	if(DSPENA == OFF)
//	{
//		return E_CTX;	/* ReLXgG[ */
//	}

	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);

	del_rdq(p_tcb);								/* TCB  RDQ O */
	p_tcb->tskstat = TTS_WAI;				/* ^XNԂ͎Ԍoߑ҂ */
	p_tcb->tskwait = TTW_DLY;				/* ^XNԂ͎Ԍoߑ҂ */
	p_tcb->wid = 0;
	p_tcb->tmout = timq.time + dlytim;			/* ^CAEgݒ */
	add_timq(p_tcb);							/* ԑ҂sɂȂ */

	/* fBXpb`܂ő҂ */
	tsk_wait_dispatch();

	return E_OK;
}

void ret_tmr(void)
{
}
