#include "mpf.h"
#include "it3_common.h"
#include "it3_config.h"
#include <depend.h>
#include "tsk.h"

#define	ISVALID_MPFID(mpfid)		((0 < (mpfid)) && ((mpfid) < TNUM_MPF))
#define	ISVALID_MPFATR(mpfatr)		(0 == ((mpfatr) & ~(TA_TPRI)))
#define	ISVALID_BLF(blf, p_mpf, mpfcnt, blfsz)		(0 == ((mpfatr) & ~(TA_TPRI)))

typedef struct S_MPFCB
{
	ID						mpfid;

	VP						exinf;			/* g						*/
	ATR						mpfatr;			/* v[				*/
	INT						mpfcnt;			/* v[Ŝ̃ubN	*/
	INT						blfsz;			/* Œ蒷ubNTCY		*/

	T_LST					wtsklst;		/* ҂^XNXg				*/
	INT						frbcnt;			/* 󂫃ubN̐				*/
	T_LST					frblst;			/* 󂫃ubÑXg			*/
	B						*p_mpf;			/* v[̃AhX		*/
} T_MPFCB;

static const T_MPFCB mpfcb_initializer = {0};

static T_MPFCB mpfcbs[TNUM_MPF];

static void build_frblst(T_LST *p_frblst, B *p_mpf, INT mpfcnt, INT blfsz)
{
	INT cnt;

	lst_init(p_frblst);

	for(cnt = 0;cnt < mpfcnt;cnt++)
	{
		lst_insert(p_frblst, (T_LST *)(p_mpf + (blfsz * cnt)));
	}
}

static BOOL is_valid_blf(VP blf, B *p_mpf, INT mpfcnt, INT blfsz)
{
	BOOL result = FALSE;

	if((p_mpf <= (B *)blf) && ((B *)blf < (p_mpf + (mpfcnt * blfsz))))
	{
		if(0 == (((B *)blf - p_mpf) % blfsz))
		{
			result = TRUE;
		}
	}

	return result;
}

ER mpf_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_MPF;cnt++)
	{
		mpfcbs[cnt] = mpfcb_initializer;
	}

	return E_OK;
}

void mpf_terminate(void)
{
}

ER cre_mpf(ID mpfid, T_CMPF *pk_cmpf)
{
	ER result;

	if(ISVALID_MPFID(mpfid))
	{
		if(ISVALID_PTR(pk_cmpf) && ISVALID_MPFATR(pk_cmpf->mpfatr))
		{
			T_MPFCB *p_mpfcb;

			p_mpfcb = &(mpfcbs[mpfid]);

			depend_EnterCriticalSection();

			if(0 == p_mpfcb->mpfid)
			{
				B *p_mpf;

				p_mpf = (B *)depend_malloc(pk_cmpf->blfsz * pk_cmpf->mpfcnt);
				if(ISVALID_PTR(p_mpf))
				{
					*p_mpfcb = mpfcb_initializer;

					p_mpfcb->mpfid = mpfid;

					p_mpfcb->exinf = pk_cmpf->exinf;
					p_mpfcb->mpfatr = pk_cmpf->mpfatr;
					p_mpfcb->mpfcnt = pk_cmpf->mpfcnt;
					p_mpfcb->blfsz = pk_cmpf->blfsz;

					lst_init(&(p_mpfcb->wtsklst));
					p_mpfcb->frbcnt = pk_cmpf->mpfcnt;
					build_frblst(&(p_mpfcb->frblst), p_mpf, p_mpfcb->mpfcnt, p_mpfcb->blfsz);
					p_mpfcb->p_mpf = p_mpf;

					result = E_OK;
				}
				else
				{
					result = E_NOMEM;
				}
			}
			else
			{
				result = E_OBJ;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER del_mpf(ID mpfid)
{
	ER result;

	if(ISVALID_MPFID(mpfid))
	{
		T_MPFCB *p_mpfcb;

		p_mpfcb = &(mpfcbs[mpfid]);

		depend_EnterCriticalSection();

		if(0 != p_mpfcb->mpfid)
		{
			depend_free(p_mpfcb->p_mpf);

			*p_mpfcb = mpfcb_initializer;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER get_blf(VP *p_blf, ID mpfid)
{
	return tget_blf(p_blf, mpfid, TMO_FEVR);
}

ER pget_blf(VP *p_blf, ID mpfid)
{
	return tget_blf(p_blf, mpfid, TMO_POL);
}

ER ipget_blf(VP *p_blf, ID mpfid)
{
	return E_NOSPT;
}

ER tget_blf(VP *p_blf, ID mpfid, TMO tmout)
{
	ER result;

	if(ISVALID_MPFID(mpfid))
	{
		if(ISVALID_PTR(p_blf) && ISVALID_TMOUT(tmout))
		{
			T_MPFCB *p_mpfcb;

			p_mpfcb = &(mpfcbs[mpfid]);

			depend_EnterCriticalSection();

			if(0 != p_mpfcb->mpfid)
			{
				if(lst_empty(&(p_mpfcb->wtsklst)))
				{
					if(TMO_POL != tmout)
					{
#if 0
						T_TCB *p_tcb;
						ER ret;

						ret = tsk_get_tcb(TSK_SELF, &p_tcb);
						if(E_OK == ret)
						{
							del_rdq(NULL, p_tcb);
							p_tcb->tskstat = TTS_WAI;
							p_tcb->tskwait = TTW_MPF;
							p_tcb->wid = mpfid;
							lst_insert(&(p_mpfcb->wtsklst), (T_LST *)p_tcb);
							result = tsk_wait(p_tcb);
							if(E_OK == result)
							{
								*p_blf = p_tcb->wait.wmpf.blf;
							}
						}
						else
						{
							result = ret;
						}
#endif
						// TODO 󂫂̂ő҂
						result = E_NOSPT;
					}
					else
					{
						result = E_TMOUT;
					}
				}
				else
				{
					T_LST *p_frb;

					p_frb = p_mpfcb->wtsklst.p_next;
					lst_delete(p_frb);
					(p_mpfcb->frbcnt)--;

					*p_blf = (VP)p_frb;

					result = E_OK;
				}
			}
			else
			{
				result = E_NOEXS;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER rel_blf(ID mpfid, VP blf)
{
	ER result;

	if(ISVALID_MPFID(mpfid))
	{
		if(ISVALID_PTR(blf))
		{
			T_MPFCB *p_mpfcb;

			p_mpfcb = &(mpfcbs[mpfid]);

			depend_EnterCriticalSection();

			if(0 != p_mpfcb->mpfid)
			{
				if(is_valid_blf(blf, p_mpfcb->p_mpf, p_mpfcb->mpfcnt, p_mpfcb->blfsz))
				{
					if(lst_empty(&(p_mpfcb->wtsklst)))
					{
						lst_insert(&(p_mpfcb->frblst), (T_LST *)blf);
						(p_mpfcb->frbcnt)++;
					}
					else
					{
#if 0
						T_TCB *p_tcb;

						p_tcb = (T_TCB *)(p_mpfcb->wtsklst.p_next);
						p_tcb->winfo.mpf.blf = blf;
						tsk_wait_release(p_tcb, E_OK);
#endif
						// TODO ǂȁ[
						result = E_NOSPT;
					}
					result = E_OK;
				}
				else
				{
					result = E_PAR;
				}
			}
			else
			{
				result = E_NOEXS;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER ref_mpf(T_RMPF *pk_rmpf, ID mpfid)
{
	ER result;

	if(ISVALID_MPFID(mpfid))
	{
		if(ISVALID_PTR(pk_rmpf))
		{
			T_MPFCB *p_mpfcb;

			p_mpfcb = &(mpfcbs[mpfid]);

			depend_EnterCriticalSection();

			if(0 != p_mpfcb->mpfid)
			{
				pk_rmpf->exinf = p_mpfcb->exinf;
				pk_rmpf->wtsk = TSK_GET_WTSKID(&(p_mpfcb->wtsklst));
				pk_rmpf->frbcnt = p_mpfcb->frbcnt;

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}
