#include "mbx.h"
#include "it3_common.h"
#include "it3_debug.h"
#include "lst.h"

#include "kernel.h"
#include "que_ctl.h"


#define	ISVALID_MBXID(mbxid)	((0 < (mbxid)) && ((mbxid) < TNUM_MBX))
#define	ISVALID_MBXATR(mbxatr)	(TRUE)	/* l̓`FbNȂ */

/* C{bNXL[ǗubN(MBXQ) */
typedef struct S_MBXCB
{
	ID			mbxid;

	VP 			exinf;
	ATR			mbxatr;
	INT			bufcnt;

	T_LST		wtsklst;

	T_MSG		*p_mhead;


	T_TCB		*head;					/* 擪TCBւ̃|C^				*/
	T_MSG		*msg;					/* 擪bZ[Wւ̃|C^		*/
	VH			wtskmode;				/* ҂							*/
	VH			wmsgmode;				/* ҂							*/
	VB			dmy[4];					/* _~[							*/
} T_MBXCB;


static const T_MBXCB mbxcb_initializer = {0};

static T_MBXCB mbxcbs[TNUM_MBX];

/*--------------------------------------------------------------------------*/
/*                   bZ[W҂L[Ƀ^XNǉ                     */
/*--------------------------------------------------------------------------*/
static void add_mbxq(T_MBXCB *p_mbxcb, T_TCB *p_tcb)
{
	IT3_ASSERT(p_mbxcb);
	IT3_ASSERT(p_tcb);

	if(TA_TPRI & p_mbxcb->mbxatr)
	{
		T_LST *p_insert_pos;

		p_insert_pos = p_mbxcb->wtsklst.p_next;

		while(&(p_mbxcb->wtsklst) != p_insert_pos)
		{
			if(p_tcb->tskpri < ((T_TCB *)p_insert_pos)->tskpri)
			{
				break;
			}

			p_insert_pos = p_insert_pos->p_next;
		}

		lst_insert(p_insert_pos, (T_LST *)p_tcb);
	}
	else
	{
		lst_insert(&(p_mbxcb->wtsklst), (T_LST *)p_tcb);
	}

#if 0 // lstɕς
	T_MBXCB *p_mbxq;
	T_TCB *toptcb, *endtcb, *nextcb, *pretcb;

	p_mbxq = &(mbxcbs[p_tcb->wid]);

	toptcb = p_mbxq->head;
	if(NULL != toptcb)
	{
		/*-------------------- ̃^XN --------------------*/
		if(p_mbxq->wtskmode == TA_TFIFO)	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endtcb       = toptcb->prev;
			p_tcb->prev = endtcb;
			p_tcb->next = toptcb;
			toptcb->prev = p_tcb;
			endtcb->next = p_tcb;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endtcb = toptcb->prev;
			nextcb = toptcb;

			do
			{
				if( p_tcb->pri < nextcb->pri )
				{
					pretcb = nextcb->prev;

					p_tcb->prev = pretcb;
					p_tcb->next = nextcb;
					nextcb->prev = p_tcb;
					pretcb->next = p_tcb;

					if( nextcb == toptcb )
					{
						p_mbxq->head = p_tcb;
					}
					break;
				}

				nextcb = nextcb->next;

			} while( (nextcb != toptcb)&&(mbxcbs->head != NULL) );

			if( nextcb == toptcb )
			{
				p_tcb->prev = endtcb;
				p_tcb->next = toptcb;
				toptcb->prev = p_tcb;
				endtcb->next = p_tcb;
			}
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		mbxcbs->head   = p_tcb;
		p_tcb->next = p_tcb;
		p_tcb->prev = p_tcb;
	}

	return;
#endif
}

/*--------------------------------------------------------------------------*/
/*                  bZ[W҂L[^XN폜                    */
/*--------------------------------------------------------------------------*/
static void del_mbxq(T_MBXCB *p_mbxcb, T_TCB *p_tcb)
{
	IT3_ASSERT(p_tcb);

	lst_delete((T_LST *)p_tcb);

#if 0 // lstɕς
	T_MBXCB *p_mbxq;
	T_TCB *pretcb, *nextcb;

	p_mbxq = &(mbxcbs[deltcb->wid]);

	pretcb = deltcb->prev;
	if(pretcb != deltcb)
	{
		/*-------------------- ̃^XN --------------------*/
		nextcb       = deltcb->next;
		pretcb->next = nextcb;
		nextcb->prev = pretcb;
		if(p_mbxq->head == deltcb)
		{
			mbxcbs->head = nextcb;
		}
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		mbxcbs->head = NULL;
	}

	/*deltcb->prev = NULL;*/
	/*deltcb->next = NULL;*/

	return;
#endif
}

/*--------------------------------------------------------------------------*/
/*                   bZ[WL[ɃbZ[Wǉ                     */
/*--------------------------------------------------------------------------*/
void add_msg(ID mbxid, T_MSG *addmsg)
{
	T_MBXCB *p_mbxq;
	T_MSG *topmsg, *endmsg, *nexmsg, *premsg;

	p_mbxq = &(mbxcbs[mbxid]);

	topmsg = mbxcbs->msg;
	if(topmsg != NULL)
	{
		/*-------------------- ̃bZ[W --------------------*/
		if( mbxcbs->wmsgmode == TA_TFIFO )	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endmsg       = topmsg->pk_prev;
			addmsg->pk_prev = endmsg;
			addmsg->pk_next = topmsg;
			topmsg->pk_prev = addmsg;
			endmsg->pk_next = addmsg;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endmsg = topmsg->pk_prev;
			nexmsg = topmsg;

			do
			{
				if( tcb[addmsg->tskid].tskpri < tcb[nexmsg->tskid].tskpri )
				{
					premsg = nexmsg->pk_prev;

					addmsg->pk_prev = premsg;
					addmsg->pk_next = nexmsg;
					nexmsg->pk_prev = addmsg;
					premsg->pk_next = addmsg;

					if( nexmsg == topmsg )
					{
						mbxcbs->msg = addmsg;
					}

					break;
				}

				nexmsg = nexmsg->pk_next;

			} while( (nexmsg != topmsg)&&(mbxcbs->msg != NULL) );

			if( nexmsg == topmsg )
			{
				addmsg->pk_prev = endmsg;
				addmsg->pk_next = topmsg;
				topmsg->pk_prev = addmsg;
				endmsg->pk_next = addmsg;
			}
		}
	}
	else
	{
		/*-------------------- ̃bZ[WȂ --------------------*/
		mbxcbs->msg    = addmsg;
		addmsg->pk_next = addmsg;
		addmsg->pk_prev = addmsg;
	}

	return;
}

/*--------------------------------------------------------------------------*/
/*                  bZ[WL[烁bZ[W폜                    */
/*--------------------------------------------------------------------------*/
void del_msg(ID mbxid, T_MSG *delmsg)
{
	T_MBXCB *p_mbxq;
	T_MSG *premsg, *nexmsg;

	p_mbxq = &(mbxcbs[mbxid]);

	premsg = delmsg->pk_prev;
	if(premsg != delmsg )
	{
		/*-------------------- ̃bZ[W --------------------*/
		nexmsg       = delmsg->pk_next;
		premsg->pk_next = nexmsg;
		nexmsg->pk_prev = premsg;

		if(p_mbxq->msg == delmsg)
		{
			mbxcbs->msg = nexmsg;
		}
	}
	else
	{
		/*-------------------- ̃bZ[WȂ --------------------*/
		p_mbxq->msg = NULL;
	}

	delmsg->pk_next  = NULL;
	delmsg->pk_prev  = NULL;

	return;
}


ER mbx_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_MBX;cnt++)
	{
		mbxcbs[cnt] = mbxcb_initializer;
		lst_init(&(mbxcbs[cnt].wtsklst));
	}

	return E_OK;
}

void mbx_terminate(void)
{
}

/* C{bNX */
ER cre_mbx(ID mbxid, T_CMBX* pk_cmbx)
{
	ER result;

	if(ISVALID_MBXID(mbxid))
	{
		if(ISVALID_PTR(pk_cmbx) && ISVALID_MBXATR(pk_cmbx->mbxatr))
		{
			T_MBXCB *p_mbxcb;

			p_mbxcb = &(mbxcbs[mbxid]);

			if(0 == p_mbxcb->mbxid)
			{
				*p_mbxcb = mbxcb_initializer;

				p_mbxcb->mbxid = mbxid;

				p_mbxcb->exinf = pk_cmbx->exinf;
				p_mbxcb->mbxatr = pk_cmbx->mbxatr;
				p_mbxcb->bufcnt = pk_cmbx->bufcnt;

				lst_init(&(p_mbxcb->wtsklst));

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* C{bNX폜 */
ER del_mbx(ID mbxid)
{
	ER result;

	if(ISVALID_MBXID(mbxid))
	{
		T_MBXCB *p_mbxcb;

		p_mbxcb = &(mbxcbs[mbxid]);

		if(0 != p_mbxcb->mbxid)
		{
			// TODO ǂȁ[

			*p_mbxcb = mbxcb_initializer;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* C{bNX֑M */
ER snd_msg(ID mbxid, T_MSG *pk_msg)
{
	ER result;

	if(ISVALID_MBXID(mbxid))
	{
		if(ISVALID_PTR(pk_msg))
		{
			T_MBXCB *p_mbxcb;

			p_mbxcb = &(mbxcbs[mbxid]);

			// TODO ǂȁ[

			result = E_OK;
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;


#if 0
	T_MBXCB *p_mbxq;
	T_TCB *p_tcb;

	/*-------------------- p[^G[ ---------------------*/
	if(! ISVALID_MBXID(mbxid))
	{
		return E_ID;
	}

	p_mbxq = &(mbxcbs[mbxid]);

	if((0 != pk_msg->pk_next) || (0 != pk_msg->pk_prev))
	{
		/* nrǗ̈悪ĂȂ */
		return E_PAR;
	}

	/* M^XNhcL^ */
	kernel_tsk_get_self_tskid(&(pk_msg->tskid));

	if(NULL == mbxcbs->head)
	{
		/*---------------- bZ[W҂̃^XNȂ -----------------*/
		/* bZ[W҂sɂȂ */
		add_msg(mbxid, pk_msg);
	}
	else
	{
		/*---------------- bZ[W҂̃^XN -----------------*/
		p_tcb = mbxcbs->head;

		*((T_MSG **)(p_tcb->arg)) = pk_msg;	/* bZ[Wn      */

		del_mbxq(p_mbxq, p_tcb);			/* MBXQ  TCB O  */

		if(p_tcb->tskstat & TTS_SUS)
		{
			/* d҂ */
			p_tcb->tskstat = TTS_SUS;		/* ^XNԂ SUSPEND  */
		}
		else
		{
			/* bZ[W҂ */
			p_tcb->tskstat = TTS_RDY;		/* ^XNԂ READY  */
			p_tcb->tskwait = 0;
			p_tcb->wid = 0;
			add_rdq(p_tcb);		/* RDQ  TCB Ȃ */
		}

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return E_OK;
#endif
}

/* C{bNX֑Mi荞݃nhpj */
ER isnd_msg(ID mbxid, T_MSG *pk_msg)
{
	return snd_msg(mbxid, pk_msg);
}

/* C{bNXM */
ER rcv_msg(T_MSG **ppk_msg, ID mbxid)
{
	return trcv_msg(ppk_msg, mbxid, TMO_FEVR);

#if 0
	T_MBXCB *p_mbxq;
	T_TCB *p_tcb;
	T_MSG *p_msg;

//	if( DSPENA == OFF )	{		/* fBXpb`֎~ */
//		return( E_CTX );
//	}

	/*-------------------- p[^G[ ---------------------*/
	if(! ISVALID_MBXID(mbxid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	p_mbxq = &(mbxcbs[mbxid]);

	if(NULL != p_mbxq->msg)
	{
		/*----------------------- bZ[W ----------------------*/
		p_msg = p_mbxq->msg;
		*pk_msg = (T_MSG *)p_msg;		/* bZ[W󂯎 */

		del_msg(mbxid, p_msg);		/* MBXQ  bZ[WO */
	}
	else
	{
		ER ercd;

		/*----------------------- bZ[WȂ ----------------------*/
		ercd = kernel_tsk_get_tcb(TSK_SELF, &p_tcb);
		if(E_OK != ercd)
		{
			return ercd;
		}

		del_rdq(p_tcb);			/* RDQ  TCB O */

		p_tcb->tskstat = TTS_WAI;
		p_tcb->tskwait = TTW_MBX;
		p_tcb->wid = mbxid;

		p_tcb->arg = (VB *)pk_msg;	/* ߂lp̃AhXۑ */
		add_mbxq(p_tcb);		/* MBXQ  TCB Ȃ */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return E_OK;
#endif
}

/* C{bNXM(|[O) */
ER prcv_msg(T_MSG **ppk_msg, ID mbxid)
{
	return trcv_msg(ppk_msg, mbxid, TMO_POL);

#if 0
	T_MBXCB *p_mbxq;
	T_MSG *p_msg;

	/*-------------------- p[^G[ ---------------------*/
	if(! ISVALID_MBXID(mbxid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	p_mbxq = &(mbxcbs[mbxid]);

	if(NULL == p_mbxq->msg)						/* bZ[WȂ? */
	{
		return E_TMOUT;
	}

	/*----------------------- bZ[W ----------------------*/
	p_msg = mbxcbs->msg;
	*pk_msg = (T_MSG *)p_msg;		/* bZ[W󂯎 */

	del_msg(mbxid, p_msg);		/* MBXQ  bZ[WO */

	return E_OK;
#endif
}

/* C{bNXM(^CAEgL) */
ER trcv_msg(T_MSG **ppk_msg, ID mbxid, TMO tmout)
{
	ER result;

	if(ISVALID_MBXID(mbxid))
	{
		if(ISVALID_PTR(ppk_msg) && ISVALID_TMOUT(tmout))
		{
			T_MBXCB *p_mbxcb;

			p_mbxcb = &(mbxcbs[mbxid]);

			if(0 != p_mbxcb->mbxid)
			{
				if(p_mbxcb->p_mhead)
				{
					*ppk_msg = p_mbxcb->p_mhead;
					p_mbxcb->p_mhead = p_mbxcb->p_mhead->pk_next;

					result = E_OK;
				}
				else
				{
					result = E_TMOUT;
					if(tmout != TMO_POL) {
//						ctxtsk->wspec = (mbxcb->mbxatr & TA_TPRI) ?
//								&wspec_mbx_tpri : &wspec_mbx_tfifo;
//						ctxtsk->wercd = &ercd;
//						ctxtsk->winfo.mbx.ppk_msg = ppk_msg;
//						gcb_make_wait((GCB *) mbxcb, tmout);
					}
				}
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* C{bNXԎQ */
ER ref_mbx(T_RMBX *pk_rmbx, ID mbxid)
{
	ER result;

	if(ISVALID_MBXID(mbxid))
	{
		if(pk_rmbx)
		{
			T_MBXCB *p_mbxcb;

			p_mbxcb = &(mbxcbs[mbxid]);

			if(0 != p_mbxcb->mbxid)
			{
				pk_rmbx->exinf = p_mbxcb->exinf;
				pk_rmbx->wtsk = TSK_GET_WTSKID(&(p_mbxcb->wtsklst));
				pk_rmbx->pk_msg = NULL;		// TODO ǂȁ[

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;

}

/*--------------------------------------------------------------------------*/
/*                      C{bNXԂQƂ                        */
/*--------------------------------------------------------------------------*/
ER mbx_sts(ID *p_wtskid, T_MSG **ppk_msg, ID mbxid)
{
	T_MBXCB *p_mbxq;

	/*-------------------- p[^G[ ---------------------*/
	if(! ISVALID_MBXID(mbxid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	p_mbxq = &(mbxcbs[mbxid]);

	*ppk_msg  = (T_MSG *)NADR;
	*p_wtskid = FALSE;

	if(NULL != p_mbxq->head)
	{
		/* ҂^XN */
		*p_wtskid = p_mbxq->head->tskid;	/* 擪̑҂^XNhcݒ */
	}
	else if(NULL != p_mbxq->msg)
	{
		/* bZ[W */
		*ppk_msg = p_mbxq->msg;		/* 擪̃bZ[WAhXݒ */
	}

	return E_OK;
}

/*--------------------------------------------------------------------------*/
/*      ^XNMbZ[W҂L[OiIpj    */
/*--------------------------------------------------------------------------*/
ER edel_msg(ID mbxid)
{
	T_MBXCB *p_mbxq;
	T_MSG *topmsg, *nextmsg, *msg;
	UH msgnum, d_msgnum;
	UH i;

	/*-------------------- p[^G[ ---------------------*/
	if((mbxid < 0) || (TNUM_MBX <= mbxid))
	{
		/* hc͈͊O */
		return E_ID;
	}

	d_msgnum = 0;

	p_mbxq = &(mbxcbs[mbxid]);

	if(NULL != p_mbxq->msg)
	{
		/*- bZ[W -*/
		ID tskid;
		tskid = kernel_tsk_get_self_tskid(TSK_SELF);

		topmsg = msg = p_mbxq->msg;

		/* bZ[W̐𐔂 */
		msgnum = 0;
		do
		{
			msgnum++;
			msg = msg->pk_next;
		} while(topmsg != msg);

		msg = topmsg;

		for(i = 0;i < msgnum;i++)
		{
			if(msg->tskid == tskid)
			{
				nextmsg = msg->pk_next;
				del_msg(mbxid, msg);	/* MBXQ  bZ[WO */
				msg = nextmsg;
				d_msgnum++;
			}
			else
			{
				msg = msg->pk_next;
			}
		}
	}

	if(0 == d_msgnum)
	{
		return E_OBJ;
	}

	return E_OK;
}

