#include "mbf.h"
#include "it3_common.h"
#include "it3_config.h"

#define	ISVALID_MBFID(mbfid)		((0 < (mbfid)) && ((mbfid) < TNUM_MBF))
#define	ISVALID_MBFATR(mbfatr)		(TRUE)	/* ̓`FbNȂ */

typedef struct S_MBFCB
{
	ID						mbfid;

	VP						exinf;			/* g						*/
	ATR						mbfatr;			/* bZ[Wobt@			*/
	INT						bufsz;			/* bZ[Wobt@̃TCY		*/
	INT						maxmsz;			/* bZ[W̍ő咷				*/

} T_MBFCB;

static const T_MBFCB mbfcb_initializer = {0};

static T_MBFCB mbfcbs[TNUM_MBF];

ER mbf_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_MBF;cnt++)
	{
		mbfcbs[cnt] = mbfcb_initializer;
	}

	return E_OK;
}

void mbf_terminate(void)
{
}

/* bZ[Wobt@ */
ER cre_mbf(ID mbfid, T_CMBF *pk_cmbf)
{
	ER result;

	if(ISVALID_MBFID(mbfid))
	{
		if(ISVALID_PTR(pk_cmbf) && ISVALID_MBFATR(pk_cmbf->mbfatr))
		{
			T_MBFCB *p_mbfcb;

			p_mbfcb = &(mbfcbs[mbfid]);

			if(0 == p_mbfcb->mbfid)
			{
				*p_mbfcb = mbfcb_initializer;

				p_mbfcb->mbfid = mbfid;
				p_mbfcb->exinf = pk_cmbf->exinf;
				p_mbfcb->mbfatr = pk_cmbf->mbfatr;
				p_mbfcb->bufsz = pk_cmbf->bufsz;
				p_mbfcb->maxmsz = pk_cmbf->maxmsz;

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* bZ[Wobt@폜 */
ER del_mbf(ID mbfid)
{
	ER result;

	if(ISVALID_MBFID(mbfid))
	{
		T_MBFCB *p_mbfcb;

		p_mbfcb = &(mbfcbs[mbfid]);

		if(0 != p_mbfcb->mbfid)
		{
			*p_mbfcb = mbfcb_initializer;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* bZ[Wobt@֑M */
ER snd_mbf(ID mbfid, VP msg, INT msgsz)
{
	return tsnd_mbf(mbfid, msg, msgsz, TMO_FEVR);
}

/* bZ[Wobt@֑M(|[O) */
ER psnd_mbf(ID mbfid, VP msg, INT msgsz)
{
	return tsnd_mbf(mbfid, msg, msgsz, TMO_POL);
}

/* bZ[Wobt@֑M(^CAEgL) */
ER tsnd_mbf(ID mbfid, VP msg, INT msgsz, TMO tmout)
{
	ER result;

	if(ISVALID_MBFID(mbfid))
	{
		if(ISVALID_PTR(msg) && (0 < msgsz) && ISVALID_TMOUT(tmout))
		{
			T_MBFCB *p_mbfcb;

			p_mbfcb = &(mbfcbs[mbfid]);

			if(0 != p_mbfcb->mbfid)
			{
				// TODO ǂȁ[
				result = E_NOSPT;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* bZ[Wobt@M */
ER rcv_mbf(VP msg, INT *p_msgsz, ID mbfid)
{
	return trcv_mbf(msg, p_msgsz, mbfid, TMO_FEVR);
}

/* bZ[Wobt@M(|[O) */
ER prcv_mbf(VP msg, INT *p_msgsz, ID mbfid)
{
	return trcv_mbf(msg, p_msgsz, mbfid, TMO_POL);
}

/* bZ[Wobt@M(^CAEgL) */
ER trcv_mbf(VP msg, INT *p_msgsz, ID mbfid, TMO tmout)
{
	ER result;

	if(ISVALID_MBFID(mbfid))
	{
		if(ISVALID_PTR(msg) && ISVALID_PTR(p_msgsz) && ISVALID_TMOUT(tmout))
		{
			T_MBFCB *p_mbfcb;

			p_mbfcb = &(mbfcbs[mbfid]);

			if(0 != p_mbfcb->mbfid)
			{
				// TODO ǂȁ[
				result = E_NOSPT;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* bZ[Wobt@ԎQ */
ER ref_mbf(T_RMBF *pk_rmbf, ID mbfid)
{
	ER result;

	if(ISVALID_MBFID(mbfid))
	{
		if(ISVALID_PTR(pk_rmbf))
		{
			T_MBFCB *p_mbfcb;

			p_mbfcb = &(mbfcbs[mbfid]);

			if(0 != p_mbfcb->mbfid)
			{
				pk_rmbf->exinf = p_mbfcb->exinf;
				pk_rmbf->wtsk = FALSE;		// TODO ǂȁ[
				pk_rmbf->stsk = FALSE;		// TODO ǂȁ[
				pk_rmbf->msgsz = 0;			// TODO ǂȁ[
				pk_rmbf->frbufsz = 0;		// TODO ǂȁ[

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}
