#include "it3.h"
#include "it3_common.h"
#include "it3_debug.h"

#define EXTDEF
#include "kernel.h"
#undef EXTDEF

#include "tsk.h"
#include "sem.h"
#include "flg.h"
#include "mbx.h"
#include "mbf.h"
#include "por.h"
#include "int.h"
#include "mpl.h"
#include "mpf.h"
#include "tim.h"
#include "alm.h"
#include "cyc.h"
#include "sys.h"
#include "net.h"

static ER (*init_funcs[])(void) = {
		tsk_initialize,
		sem_initialize,
		flg_initialize,
		mbx_initialize,
		mbf_initialize,
		por_initialize,
		int_initialize,
		mpl_initialize,
		mpf_initialize,
		tim_initialize,
		alm_initialize,
		cyc_initialize,
		sys_initialize,
		net_initialize,
};

static void (*term_funcs[])(void) = {
		net_terminate,
		sys_terminate,
		cyc_terminate,
		alm_terminate,
		tim_terminate,
		mpf_terminate,
		mpl_terminate,
		int_terminate,
		por_terminate,
		mbf_terminate,
		mbx_terminate,
		flg_terminate,
		sem_terminate,
		tsk_terminate,
};

/* J[l̏ */
static ER it3_initialize(void)
{
	ER result;
	INT cnt, cnt_max;
	int int_ret;
	ER er_ret;

	/* ˑ̏ */
	int_ret = depend_initialize();
	if(0 == int_ret)
	{
		result = E_OK;

		cnt_max = ARRAY_CNT(init_funcs);
		for(cnt = 0;cnt < cnt_max;cnt++)
		{
			er_ret = (init_funcs[cnt])();
			if(E_OK != er_ret)
			{
				IT3_LOG2("it3 init failure.[cnt:%d, ret:%d]", cnt, er_ret);
				result = er_ret;
				break;
			}
		}
	}
	else
	{
		IT3_LOG1("it3 depend init abort.[ret:%d]", int_ret);
		result = E_SYS;
	}

	return result;
}

/* J[ls */
static int it3_run(void)
{
	/* VXe */

	/* 荞݂ */

	/* ^XN̎sJn */
	/* SẴ^XNDOMANTԂɂȂAI */
	while(TRUE)
	{
		/* ݃nh */
		int_event();

		/* ^CCxgnh */
		tim_event();

		/* CPUOnh */
		/* gT[rXR[[` */
		/* ^XN */

//		if()	/* SẴ^XNDOMANT? */
//		{
//			break;
//		}

		/* ^XNfBXpb` */
		tsk_dispatch();
	}

	depend_message_show("uITRONIYOI");

	/* ˑ̏I */
	depend_terminate();

	return E_OK;
}

/* J[l̏I */
static void it3_terminate(void)
{
	INT cnt, cnt_max;

	cnt_max = ARRAY_CNT(term_funcs);
	for(cnt = 0;cnt < cnt_max;cnt++)
	{
		(term_funcs[cnt])();
	}

	depend_terminate();
}

/* J[l̃Gg[|Cg */
ER IT3_main(const T_IT3_ARG *p_arg)
{
	int result;
	ER ret;

	it3_debug_initialize();

	IT3_LOG("-->it3_main");

	/* n[hEFAˑ̏ */
	ret = (ISVALID_PTR(p_arg->pf_hw_init)) ? (p_arg->pf_hw_init)() : E_OK;
	if(E_OK == ret)
	{
		/* J[lg̏ */
		ret = it3_initialize();
		if(E_OK == ret)
		{
			/* ÓIAPȈ */
			/* ̂ƂÓIAPI͖Ȃ̂ŁA邱Ƃ */

			/* [U[X^[gAbv */
			ret = (p_arg->pf_startup)();
			if(E_OK == ret)
			{
				/* J[l̓Jn */
				it3_run();

				result = E_OK;
			}
			else
			{
				IT3_LOG1("user startup failure[ret:%d].", ret);
				result = ret;
			}

			/* J[l̏I */
			it3_terminate();
		}
		else
		{
			IT3_LOG1("it3 init failure.[ercd:%d]", ret);
			result = ret;
		}

		/* n[hEFȀI */
		if(ISVALID_PTR(p_arg->pf_hw_term))
		{
			(p_arg->pf_hw_term)();
		}
	}
	else
	{
		IT3_LOG1("hardware init failure.[ret:%d]", ret);
		result = ret;
	}

	IT3_LOG("<--it3_main");

	it3_debug_terminate();

	return result;
}

/* ݐMݒ */
ER IT3_interrupt_signel(UINT intno)
{
	return set_int(intno);
}
