#include "int.h"
#include "it3_common.h"
#include "it3_config.h"
#include <depend.h>

#define	ISVALID_INTNO(intno)	((0 < (intno)) && ((intno) < TNUM_INT))
#define	ISVALID_INTATR(intatr)	(TRUE)	/* `FbNȂ */

/* ݃nh` */
typedef struct S_INTCB
{
	UINT				intno;

	ATR					intatr;		/* ݃nh					*/
	FP					inthdr;		/* ݃nhAhX				*/

	/* Cvgˑ̏ */
	B					intmsk;		/* ݃}XN							*/
	B					intpri;		/* ݃x							*/

} T_INTCB;

static const T_INTCB intcb_initializer = {0};

static T_INTCB intcbs[TNUM_INT];

ER int_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_INT;cnt++)
	{
		intcbs[cnt] = intcb_initializer;
	}

	return E_OK;
}

void int_terminate(void)
{
}

ER int_event(void)
{
	INT cnt;
	T_INTCB *p_intcb;

	for(cnt = 0;cnt < TNUM_INT;cnt++)
	{
		p_intcb = &(intcbs[cnt]);

		depend_EnterCriticalSection();

		if(0 != p_intcb->intno)
		{
			(p_intcb->inthdr)();
			p_intcb->intatr = 0;
		}

		depend_LeaveCriticalSection();
	}

	return E_OK;
}

ER set_int(UINT intno)
{
	ER result;

	if(ISVALID_INTNO(intno))
	{
		T_INTCB *p_intcb;

		p_intcb = &(intcbs[intno]);

		depend_EnterCriticalSection();

		if(0 != p_intcb->intno)
		{
			p_intcb->intatr = 1;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_PAR;
	}

	return result;
}


/* ݃nh` */
ER def_int(UINT dintno, T_DINT *pk_dint)
{
	ER result;

	if(ISVALID_INTNO(dintno))
	{
		T_INTCB *p_intcb;

		p_intcb = &(intcbs[dintno]);

		depend_EnterCriticalSection();

		if(ISVALID_PTR(pk_dint))
		{
			if(ISVALID_INTATR(intatr))
			{
				if(0 == p_intcb->intno)
				{
					*p_intcb = intcb_initializer;

					p_intcb->intno = dintno;

					p_intcb->intatr = pk_dint->intatr;
					p_intcb->inthdr = pk_dint->inthdr;

					result = E_OK;
				}
				else
				{
					result = E_OBJ;
				}
			}
			else
			{
				result = E_RSATR;
			}
		}
		else
		{
			*p_intcb = intcb_initializer;

			result = E_OK;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

void ret_int(void)
{
}

void ret_wup(ID tskid)
{

}

/* ݂ƃfBXpb`̋֎~ */
ER loc_cpu(void)
{
	return E_NOSPT;
}

/* ݂ƃfBXpb`̋ */
ER unl_cpu(void)
{
	return E_NOSPT;
}

/* ݋֎~ */
ER dis_int(UINT eintno)
{
	return E_NOSPT;
}

/* ݋ */
ER ena_int(UINT eintno)
{
	return E_NOSPT;
}
