#include "flg.h"
#include "it3_debug.h"
#include "it3_common.h"
#include "it3_config.h"

#include "que_ctl.h"
#include "tsk.h"
#include "kernel.h"

#define	ISVALID_FLGID(flgid)	((0 < flgid) && (flgid < TNUM_FLG))
#define	ISVALID_FLGATR(flgatr)	(TRUE)		/* l̓`FbNȂ */
#define	ISVALID_WFMODE(wfmode)	(0 == ((wfmode) & ~(TWF_ORW | TWF_CLR)))
#define	ISVALID_TMOUT(tmout)	((0 < (tmout)) || (TMO_FEVR == (tmout)) || (TMO_POL == (tmout)))

typedef struct S_FLGCB
{
	ID			flgid;							/**< CxgtOID			*/
	VP			exinf;							/**< g					*/
	ATR			flgatr;							/**< 					*/
	UINT		flgptn;							/**< tOp^[				*/

	T_LST		wtsklst;						/**< ҂^XNXg				*/

//	T_TCB		*head;							/**< 擪TCBւ̃|C^			*/
//	VH			wtskmode;						/**< ҂					*/
//	ID			wtskcnt;						/**< ҂^XN				*/
//	VB			dmy[4];							/**< _~[						*/

} T_FLGCB;

static const T_FLGCB flgcb_initializer = {0};

static T_FLGCB flgcb[TNUM_FLG];

/* CxgtO҂L[Ƀ^XNǉ */
static void add_flgq(T_FLGCB *p_flgcb, T_TCB *p_tcb)
{
	IT3_ASSERT(p_flgcb);
	IT3_ASSERT(p_tcb);

	if(TA_TPRI & p_flgcb->flgatr)
	{
		T_LST *p_insert_pos;

		p_insert_pos = p_flgcb->wtsklst.p_next;

		while(&(p_flgcb->wtsklst) != p_insert_pos)
		{
			if(p_tcb->tskpri < ((T_TCB *)p_insert_pos)->tskpri)
			{
				break;
			}

			p_insert_pos = p_insert_pos->p_next;
		}

		lst_insert(p_insert_pos, (T_LST *)p_tcb);
	}
	else
	{
		lst_insert(&(p_flgcb->wtsklst), (T_LST *)p_tcb);
	}

#if 0 // T_LSTֈڍŝŎĝ߂
	T_FLGCB *p_flgq;
	T_TCB *toptcb, *endtcb, *nextcb, *pretcb;

	p_flgq = &flgcb[addtcb->wid];

	toptcb = p_flgq->head;
	if(NULL != toptcb)
	{
		/*-------------------- ̃^XN --------------------*/
		if( p_flgq->wtskmode == TA_TFIFO )	/* ҂ FIFO */
		{
			/* ԌɂȂ */
			endtcb       = toptcb->prev;
			addtcb->prev = endtcb;
			addtcb->next = toptcb;
			toptcb->prev = addtcb;
			endtcb->next = addtcb;
		}
		else								/* ҂ D揇 */
		{
			/* }ꏊTĂȂ */
			endtcb = toptcb->prev;
			nextcb = toptcb;

			do
			{
				if( addtcb->pri < nextcb->pri )
				{
					pretcb = nextcb->prev;

					addtcb->prev = pretcb;
					addtcb->next = nextcb;
					nextcb->prev = addtcb;
					pretcb->next = addtcb;

					if( nextcb == toptcb )
					{
						p_flgq->head = addtcb;
					}

					break;
				}

				nextcb = nextcb->next;
			} while((nextcb != toptcb) && (p_flgq->head != NULL));

			if( nextcb == toptcb )
			{
				addtcb->prev = endtcb;
				addtcb->next = toptcb;
				toptcb->prev = addtcb;
				endtcb->next = addtcb;
			}
		}

		(p_flgq->wtskcnt)++;				/* ҂^XNZ */
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_flgq->head   = addtcb;
		addtcb->next = addtcb;
		addtcb->prev = addtcb;

		p_flgq->wtskcnt = 1;					/* ҂^XN͂P */
	}

	return;
#endif
}

/* CxgtO҂L[^XN폜 */
void del_flgq(T_FLGCB *p_flgcb, T_TCB *p_tcb)
{
	lst_delete((T_LST *)p_tcb);

#if 0 // T_LSTֈڍŝŎĝ߂
	T_FLGCB	*p_flgq;
	T_TCB	*pretcb, *nextcb;

	p_flgq = &flgcb[deltcb->wid];

	if( (pretcb = deltcb->prev) != deltcb )
	{
		/*-------------------- ̃^XN --------------------*/
		nextcb       = deltcb->next;
		pretcb->next = nextcb;
		nextcb->prev = pretcb;
		if( p_flgq->head == deltcb )
		{
			p_flgq->head = nextcb;
		}

		( p_flgq->wtskcnt )--;		/* ҂^XNZ */
	}
	else
	{
		/*-------------------- ̃^XNȂ --------------------*/
		p_flgq->head = NULL;

		p_flgq->wtskcnt = 0;			/* ҂^XN͂O */
	}

	/*deltcb->prev = NULL;*/
	/*deltcb->next = NULL;*/

	return;
#endif
}

/**
 * @brief	EʐM@\iCxgtOj
 */
ER flg_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_FLG;cnt++)
	{
		flgcb[cnt] = flgcb_initializer;
	}

	return E_OK;
}

/**
 * @brief	EʐM@\iCxgtOjI
 */
void flg_terminate(void)
{
}

/*----------------- AʐM@\iCxgtOj---------------------*/
/* CxgtO */
ER cre_flg(ID flgid, T_CFLG *pk_cflg)
{
	ER result;

	if(ISVALID_FLGID(flgid))
	{
		if(ISVALID_PTR(pk_cflg))
		{
			T_FLGCB *p_flgcb;

			p_flgcb = &(flgcb[flgid]);

			depend_EnterCriticalSection();

			if(0 == p_flgcb->flgid)
			{
				*p_flgcb = flgcb_initializer;

				p_flgcb->flgid = flgid;

				p_flgcb->exinf = pk_cflg->exinf;
				p_flgcb->flgatr = pk_cflg->flgatr;
				p_flgcb->flgptn = pk_cflg->iflgptn;			/* CxgtOl	*/

				lst_init(&(p_flgcb->wtsklst));

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* CxgtO폜 */
ER del_flg(ID flgid)
{
	ER result;

	if(ISVALID_FLGID(flgid))
	{
		T_FLGCB *p_flgcb;

		p_flgcb = &(flgcb[flgid]);

		depend_EnterCriticalSection();

		if(0 != p_flgcb->flgid)
		{
			T_TCB *p_tcb;

			/*----- ҂Ă^XN̑҂ -----*/
			while(! lst_empty(&(p_flgcb->wtsklst)))
			{
				p_tcb = (T_TCB *)(p_flgcb->wtsklst.p_next);

				del_flgq(p_flgcb, p_tcb);						/* FLGQ  TCB O */

				if(WTIM & p_tcb->tskwait)					/* ^CAEg */
				{
					T_TCBTMO *p_tcbtmo = &(tcbtmoq[p_tcb->tskid]);
					del_timq(p_tcbtmo);	/* TIMQ  TCB O */
					p_tcbtmo->sts = 0;
				}

				/* G[R[h҂IuWFNg̍폜 */
				*(p_tcb->p_wercd) = E_DLT;

				p_tcb->tskstat &= ~(TTS_WAI);
				p_tcb->tskwait &= ~(WTIM | TTW_FLG);
				p_tcb->wid = 0;
				if(0 == (TTS_SUS & tcb->tskstat))
				{
					p_tcb->tskstat = TTS_RDY;				/* ^XNԂ READY  */
					p_tcb->tskwait = 0;
					p_tcb->wid = 0;
					add_rdq(p_tcb);						/* RDQ  TCB Ȃ */
				}
			}

			*p_flgcb = flgcb_initializer;

			/* fBXpb`܂ő҂ */
			tsk_wait_dispatch();

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* CxgtÕZbg */
ER set_flg(ID flgid, UINT setptn)
{
	ER result;

	result = iset_flg(flgid, setptn);
	if(E_OK == result)
	{
		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
	}

	return result;
}

/* CxgtÕZbg(^XNƗp) */
ER iset_flg(ID flgid, UINT setptn)
{
	ER result;

	if(ISVALID_FLGID(flgid))
	{
		T_FLGCB *p_flgcb;
		T_TCB *p_tcb, *p_next_tcb;
		UINT ptn;

		p_flgcb = &(flgcb[flgid]);

		depend_EnterCriticalSection();

		p_flgcb->flgptn |= setptn;

		p_tcb = (T_TCB *)(p_flgcb->wtsklst.p_next);

		while(&(p_flgcb->wtsklst) != (T_LST *)p_tcb)
		{
			p_next_tcb = (T_TCB *)(((T_LST *)p_tcb)->p_next);

			ptn = p_flgcb->flgptn & p_tcb->wait.wflg.waiptn;

			if(	((0 != (p_tcb->wait.wflg.wfmode & TWF_ANDW)) && (p_tcb->wait.wflg.waiptn == ptn)) ||
				((0 != (p_tcb->wait.wflg.wfmode & TWF_ORW))  && (0 != ptn))	)
			{
				/*  */

				*(UW *)p_tcb->arg = p_flgcb->flgptn;	/* ҂tOp^[ */

				if(0 != (p_tcb->wait.wflg.wfmode & TWF_CLR))	/* NAw肠 */
				{
					p_flgcb->flgptn &= ~(p_tcb->wait.wflg.waiptn);
				}

				del_flgq(p_flgcb, p_tcb);		/* FLGQ  TCB O       */
				p_tcb->wait.wflg.wfmode = 0;		/* TCB ̑҂p^[NA */

				if(WTIM & p_tcb->tskstat)		/* ^CAEg */
				{
					T_TCBTMO *p_tcbtmo = &(tcbtmoq[p_tcb->tskid]);
					del_timq(p_tcbtmo);				/* TIMQ  TCB O */
					p_tcbtmo->sts = 0;
				}

				if(TTS_SUS == p_tcb->tskstat)
				{
					/* d҂ */
					p_tcb->tskstat = TTS_SUS;			/* ^XNԂ SUSPEND  */
				}
				else
				{
					/* bZ[W҂ */
					add_rdq(p_tcb);					/* RDQ  TCB Ȃ */
					p_tcb->tskstat = TTS_RDY;			/* ^XNԂ READY  */
				}
			}

			p_tcb = p_next_tcb;
		}

		depend_LeaveCriticalSection();

		result = E_OK;
	}
	else
	{
		result = E_ID;
	}

	return result;
#if 0
	T_FLGCB *p_flgq;
	T_TCB *p_tcb, *p_next_tcb;
	UH wtskcnt;
	INT i;
	UW ptn;

	/* p[^`FbN */
	if(! ISVALID_FLGID(flgid))
	{
		return E_ID;
	}

	p_flgq = &(flgcb[flgid]);

	/* CxgtO̒lݒ */
	p_flgq->flgptn |= setptn;

	p_tcb = p_flgq->head;
	wtskcnt = p_flgq->wtskcnt;	/* CxgtO҂^XN̐ */

	for(i = 0;i < wtskcnt;i++)
	{
		p_next_tcb = p_tcb->next;

		ptn = p_flgq->flgptn & p_tcb->waiptn;

		if(	((0 != (p_tcb->wfmode & TWF_ANDW)) && (p_tcb->waiptn == ptn)) ||
			((0 != (p_tcb->wfmode & TWF_ORW))  && (0 != ptn))	)
		{
			/*  */

			*(UW *)p_tcb->arg = p_flgq->flgptn;	/* ҂tOp^[ */

			if(0 != (p_tcb->wfmode & TWF_CLR))	/* NAw肠 */
			{
				p_flgq->flgptn &= ~(p_tcb->waiptn);
			}

			del_flgq(p_flgq, p_tcb);		/* FLGQ  TCB O       */
			p_tcb->wfmode = 0;		/* TCB ̑҂p^[NA */

			if(WTIM & p_tcb->tskstat)		/* ^CAEg */
			{
				T_TCBTMO *p_tcbtmo = &(tcbtmoq[p_tcb->tskid]);
				del_timq(p_tcbtmo);				/* TIMQ  TCB O */
				p_tcbtmo->sts = 0;
			}

			if(TTS_SUS == p_tcb->tskstat)
			{
				/* d҂ */
				p_tcb->tskstat = TTS_SUS;			/* ^XNԂ SUSPEND  */
			}
			else
			{
				/* bZ[W҂ */
				add_rdq(p_tcb);					/* RDQ  TCB Ȃ */
				p_tcb->tskstat = TTS_RDY;			/* ^XNԂ READY  */
			}
		}

		p_tcb = p_next_tcb;
	}

	return E_OK;
#endif
}

/* CxgtÕNA */
ER clr_flg(ID flgid, UINT clrptn)
{
	ER result;

	if(ISVALID_FLGID(flgid))
	{
		T_FLGCB *p_flgcb;

		p_flgcb = &(flgcb[flgid]);

		depend_EnterCriticalSection();

		if(0 != p_flgcb->flgid)
		{
			p_flgcb->flgptn &= clrptn;
			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* CxgtO҂ */
ER wai_flg(UINT *p_flgptn, ID flgid, UINT waiptn, UINT wfmode)
{
	return twai_flg(p_flgptn, flgid, waiptn, wfmode, TMO_FEVR);

#if 0 // TODO ߂
	T_FLGCB *p_flgq;
	T_TCB *p_tcb;
	ER ercd;
	UINT ptn;

	/* p[^`FbN */
	if(! ISVALID_FLGID(flgid))
	{
		return E_ID;
	}

	if(0 == waiptn)
	{
		/* waiptn s */
		return  E_PAR;
	}

	if(0 != (wfmode & ~(TWF_ANDW | TWF_ORW | TWF_CLR)))
	{
		/* wfmode s */
		return E_PAR;
	}

	p_flgq = &(flgcb[flgid]);
	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	/* ^XN̑҂ƈv邩? */
	ptn = p_flgq->flgptn & waiptn;	/* tOp^[ */

	if(	((0 != (wfmode & TWF_ANDW)) && (ptn == waiptn)) ||
		((0 != (wfmode & TWF_ORW))  && (ptn != 0))	)
	{
		*p_flgptn = p_flgq->flgptn;	/* ҂tOp^[ */

		if(0 != (TWF_CLR & wfmode))	/* NAw肠? */
		{
			/* rbgp^[NA */
			p_flgq->flgptn &= ~(waiptn);
		}
	}
	else
	{
		/* TCBRDQO */
		del_rdq(p_tcb);

		/* ^XNԂWAITɂ */
		p_tcb->tskstat = TTS_WAI;
		p_tcb->tskwait = TTW_FLG;
		p_tcb->wid = flgid;

		/* waiptn,wfmodeTCBɐݒ */
		p_tcb->waiptn = waiptn;
		p_tcb->wfmode = wfmode;

		/* ۑ */
		p_tcb->arg = (VP)p_flgptn;

		if(TA_TFIFO == p_flgq->wtskmode)		/* ҂sFIFO? */
		{
			/* TCBFLGQɂȂ */
			add_flgq(p_flgq, p_tcb);
		}
		else
		{
			/* D揇ʂ̍}ʒu */
			/* FLGQ̌ʒuTCBȂ */
			add_flgq(p_flgq, p_tcb);
		}
	}

	/* fBXpb`܂ő҂ */
	tsk_wait_dispatch();

	return E_OK;
#endif
}

/* CxgtO҂(|[O) */
ER pol_flg(UINT *p_flgptn, ID flgid, UINT waiptn, UINT wfmode)
{
	return twai_flg(p_flgptn, flgid, waiptn, wfmode, TMO_POL);

#if 0 // TODO 
	ER ercd;
	T_FLGCB *p_flgq;
	T_TCB *p_tcb;
	UINT ptn;

	/* p[^`FbN */
	if(! ISVALID_FLGID(flgid))
	{
		return E_ID;
	}

	if(0 != (wfmode & ~(TWF_ANDW | TWF_ORW | TWF_CLR)))
	{
		/* wfmode s */
		return E_PAR;
	}

	if(0 == waiptn)
	{
		/* waiptn s */
		return E_PAR;
	}

	p_flgq = &(flgcb[flgid]);
	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	/*-------------------- CxgtO𓾂 ---------------------*/
	ptn = p_flgq->flgptn & waiptn;

	if(	((0 != (wfmode & TWF_ANDW)) && (ptn == waiptn)) ||
		((0 != (wfmode & TWF_ORW))  && (ptn != 0))	)
	{
		/*  */

		*p_flgptn = p_flgq->flgptn;	/* ҂tOp^[ */

		if(0 != (wfmode & TWF_CLR))				/* NAw肠? */
		{
			p_flgq->flgptn &= ~(waiptn);
		}
	}
	else
	{
		return E_TMOUT;
	}

	return E_OK;
#endif
}

/* CxgtO҂(^CAEgL)) */
ER twai_flg(UINT *p_flgptn, ID flgid, UINT waiptn, UINT wfmode, TMO tmout)
{
	ER result;

	if(ISVALID_FLGID(flgid))
	{
		if((0 != waiptn) && ISVALID_WFMODE(wfmode) && ISVALID_TMOUT(tmout))
		{
			T_FLGCB *p_flgcb;
			ER ret;
			T_TCB *p_tcb;

			p_flgcb = &(flgcb[flgid]);

			ret = tsk_get_tcb(TSK_SELF, &p_tcb);
			if(E_OK == ret)
			{
				depend_EnterCriticalSection();

				if(	((TWF_ORW & wfmode) && ((waiptn & p_flgcb->flgptn) != 0)) ||
					((waiptn & p_flgcb->flgptn) == waiptn))
				{
					if(p_flgptn)
					{
						*p_flgptn = p_flgcb->flgptn;
					}

					if(0 != (TWF_CLR & wfmode))				/* NAw肠? */
					{
						p_flgcb->flgptn = 0;
					}

					result = E_OK;
				}
				else
				{
					if(TMO_POL == tmout)
					{
						result = E_TMOUT;
					}
					else if(TMO_FEVR == tmout)
					{
						del_rdq(p_tcb);							/* RDQ  TCB O */

						p_tcb->tskstat = TTS_WAI;
						p_tcb->tskwait = TTW_FLG;
						p_tcb->wid = flgid;

						p_tcb->arg = (VB *)p_flgptn;			/* ߂lp̃AhXۑ */
						p_tcb->wait.wflg.waiptn = waiptn;					/* ҂p^[ݒ */
						p_tcb->wait.wflg.wfmode = wfmode;					/* ҂[hݒ */

						add_flgq(p_flgcb, p_tcb);						/* FLGQ  TCB Ȃ */

						/* fBXpb`܂ő҂ */
						tsk_wait_dispatch();

						result = E_OK;
					}
					else
					{
						T_TCBTMO *p_tcbtmo = &(tcbtmoq[p_tcb->tskid]);

						del_rdq(p_tcb);							/* RDQ  TCB O */
						p_tcb->tskstat = TTS_WAI;
						p_tcb->tskwait = WTIM | TTW_FLG;
						p_tcb->wid = flgid;	/* tO ID ݒ */

						p_tcb->arg = (VB *)p_flgptn;	/* ߂lp̃AhXۑ */
						p_tcb->wait.wflg.waiptn = waiptn;		/* ҂p^[ݒ */
						p_tcb->wait.wflg.wfmode = wfmode;		/* ҂[hݒ */

						p_tcbtmo->sts = p_tcb->tskstat;
						p_tcbtmo->tmout = timq.time + tmout; /* ^CAEgݒ */

						add_flgq(p_flgcb, p_tcb);		/* FLGQ  TCB Ȃ */
						add_timq(p_tcb);	/* ԑ҂sɂȂ */

						/* fBXpb`܂ő҂ */
						tsk_wait_dispatch();

						result = E_OK;
					}
				}

				depend_LeaveCriticalSection();
			}
			else
			{
				result = ret;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;

#if 0 // TODO ς
	ER ercd;
//	UINT wfmode = pararr[0];
//	TMO tmout  = pararr[1];

	T_FLGCB *p_flgq;
	T_TCB *p_tcb;

//	if (DSPENA == OFF) return E_CTX;	/* ReLXgG[ */

	/*----- p[^G[ -----*/
	if(! ISVALID_FLGID(flgid))
	{
		return E_ID;							/* s ID ԍ */
	}

	if(0 == waiptn)
	{
		return E_PAR;	/* p[^G[ */
	}

	p_flgq = &(flgcb[flgid]);
	ercd = tsk_get_tcb(TSK_SELF, &p_tcb);
	if(E_OK != ercd)
	{
		return ercd;
	}

	/*----- CxgtO҂ -----*/
	if(	((TWF_ORW & wfmode) && ((waiptn & p_flgq->flgptn) != 0)) ||
		((waiptn & p_flgq->flgptn) == waiptn))
	{
		/*  */
		*p_flgptn = p_flgq->flgptn;	/* ҂tOp^[ */

		if(0 != (TWF_CLR & wfmode))				/* NAw肠? */
		{
			p_flgq->flgptn = 0;
		}

		return E_OK;
	}

	if(TMO_POL == tmout)
	{
		return E_TMOUT;
	}
	else if(TMO_FEVR == tmout)
	{
		del_rdq(p_tcb);							/* RDQ  TCB O */
		p_tcb->tskstat = TTS_WAI;
		p_tcb->tskwait = TTW_FLG;
		p_tcb->wid = flgid;						/* tO ID ݒ */

		p_tcb->arg = (VB *)p_flgptn;			/* ߂lp̃AhXۑ */
		p_tcb->waiptn = waiptn;					/* ҂p^[ݒ */
		p_tcb->wfmode = wfmode;					/* ҂[hݒ */

		add_flgq(p_flgq, p_tcb);						/* FLGQ  TCB Ȃ */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
		return E_OK;
	}
	else
	{
		T_TCBTMO *p_tcbtmo = &(tcbtmoq[p_tcb->tskid]);

		del_rdq(p_tcb);							/* RDQ  TCB O */
		p_tcb->tskstat = TTS_WAI;
		p_tcb->tskwait = WTIM | TTW_FLG;
		p_tcb->wid = flgid;	/* tO ID ݒ */

		p_tcb->arg = (VB *)p_flgptn;	/* ߂lp̃AhXۑ */
		p_tcb->waiptn = waiptn;		/* ҂p^[ݒ */
		p_tcb->wfmode = wfmode;		/* ҂[hݒ */

		p_tcbtmo->sts = p_tcb->sts;
		p_tcbtmo->tmout = timq.time + tmout; /* ^CAEgݒ */

		add_flgq(p_flgq, p_tcb);		/* FLGQ  TCB Ȃ */
		add_timq(p_tcb);	/* ԑ҂sɂȂ */

		/* fBXpb`܂ő҂ */
		tsk_wait_dispatch();
		return E_OK;
	}
#endif
}

/* CxgtOԎQ */
ER ref_flg(T_RFLG *pk_rflg, ID flgid)
{
	ER result;

	if(ISVALID_FLGID(flgid))
	{
		if(ISVALID_PTR(pk_rflg))
		{
			T_FLGCB *p_flgcb;

			p_flgcb = &(flgcb[flgid]);

			depend_EnterCriticalSection();

			if(0 != p_flgcb->flgid)
			{
				pk_rflg->exinf = p_flgcb->exinf;
				pk_rflg->wtsk = (lst_empty(&(p_flgcb->wtsklst))) ? FALSE : ((T_TCB *)(p_flgcb->wtsklst.p_next))->tskid;
				pk_rflg->flgptn = p_flgcb->flgptn;

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}
