﻿//Jungle Javascript library
//4.3.0 BETA by NANDENJIN laboratory
//copyright(c)2012-2014 Kazumi Inada&NANDENJIN Laboratory All rights reserved.

var jg={};

jg.ver="4.3.0 BETA";

//ウィンドウ
jg.win={};
jg.win.refreshSize=function(){
	if(window.innerWidth){
		jg.win.width=window.innerWidth;
		jg.win.height=window.innerHeight;
	}else if(document.documentElement&&document.documentElement.clientWidth!==0){
		jg.win.width=document.documentElement.clientWidth;
		jg.win.height=document.documentElement.clientHeight;
	}else if(document.body){
		jg.win.width=document.body.clientWidth;
		jg.win.height=document.body.clientHeight;
	}else{
		jg.win.width=0;
		jg.win.height=0;
	}
};


//要素制御
jg.elm=function(t){
	var e,f;
	try{
		if(t.match(/#(.+)/)){
			e=document.getElementById(RegExp.$1);
			f=0;
		}else if(t.match(/\.(.+)/)){
			e=document.getElementsByClassName(RegExp.$1);
			f=1;
		}else if(t.match(/(.+)/)){
			e=document.getElementsByTagName(RegExp.$1);
			f=1;
		}else if("innerHTML" in t){
			e=t;
			f=0;
		}else{
			console.error("jungle.js:ターゲット文字列 "+t+" は有効ではありません");
			e=null;
			f=-1;
		}
	}catch(error){
		console.log("Jungle.js:Elementの取得に失敗しました : "+error);
		e=null;
		f=-1;
	}
	return e;
};

jg.fitImage=function(bw,bh,sw,sh,posX,posY){
	var r={
		iw:0,
		ih:0,
		ix:0,
		iy:0,
		dw:sw,
		dh:sh,
		dx:0,
		dy:0,
		cx:0,
		cy:0,
		cw:0,
		ch:0
	};
	if(sw/bw*bh>sh){
		r.iw=sw;
		r.ih=sw/bw*bh;
		r.ix=0;
		r.cw=bw;
		r.ch=sh/sw*bw;
		if(!posY||posY=="center"||posY===""){
			r.cy=(bh-sh/sw*bw)/2;
		}else if(posY=="top"){
			r.cy=0;
		}else if(posY=="bottom"){
			r.cy=bh-sh/sw*bw;
		}else{
			console.warn("Jungle.js:fitImage:縦方向の位置設定に対してtop,bottom,center以外の値が設定されているようです。");
			r.cy=0;
		}
	}else{
		r.ih=sh;
		r.iw=sh/bh*bw;
		r.iy=0;
		r.ch=bh;
		r.cw=sw/sh*bh;
		if(!posX||posX=="center"||posX===""){
			r.cx=(bw-sw/sh*bh)/2;
		}else if(posX=="left"){
			r.cx=0;
		}else if(posX=="right"){
			r.cx=bw-sw/sh*bh;
		}else{
			console.warn("Jungle.js:fitImage:横方向の位置設定に対してleft,right,center以外の値が設定されているようです。");
			r.cy=0;
		}
	}
	r.ix=-(sw/r.cw*r.cx);
	r.iy=-(sh/r.ch*r.cy);
	return r;
};

//Ajax
jg.ajax={};
jg.ajax.q=[];
jg.ajax.request=function(d){
	var q=jg.ajax.q;
	var i=q.length;
	q[i]=new XMLHttpRequest();
	var rType=d.responseType||"text";
	var type=d.type||'GET';
	var async=d.async||true;
	q[i].open(type,d.url,async);
	q[i].setRequestHeader('Content-Type','application/x-www-form-urlencoded');
	q[i].responseType=rType;
	q[i].onload=function(r){
		d.onload(q[i]);
	};
	q[i].onerror=function(r){
		if(d.onerror){
			d.onerror(q[i]);
		}
	};
	q[i].send(d.data||"");
};

//リソース ローダ パック
jg.ResourceLoader=function(t,d){
	var cntA=t.length;var cntB=0;
	//ロード完了チェック
	var checker=function(){
		if(cntB>=cntA&&d.onloadcomplete){
			d.onloadcomplete();
		}
	};
	for(var i=0;i<t.length;i++){
		//画像の読み込み
		if(t[i].src.match(/gif|png|jpg$/i)){
			t[i].obj=new Image();
			t[i].obj.onload=(function(f){
				return function(){
					cntB++;
					if(f.onload){
						f.onload(f.obj,{
							id:f.id,
							length:cntA,
							loaded:cntB
						});
					}
					if(d.onload){
						d.onload(f.obj,{
							id:f.id,
							length:cntA,
							loaded:cntB
						});
					}
					checker();
				};
			})(t[i]);
			t[i].obj.onerror=(function(f){
				return function(){
					if(f.onerror){
						f.onerror(null,{
							id:f.id,
							length:cntA,
							loaded:cntB
						});
					}
					checker();
				};
			})(t[i]);
			t[i].obj.src=t[i].src;
		//オーディオ読み込み
		}else if(t[i].src.match(/mp3|wav|ogg$/i)){
			jg.ajax.request({
				url:t[i].src,
				rType:'arraybuffer',
				onload:(function(f){
					return function(r){
						cntB++;
						if(f.onload){
							f.onload(r.response,{
								id:f.id,
								length:cntA,
								loaded:cntB
							});
						}
						if(d.onload){
							d.onload(r.response,{
								id:f.id,
								length:cntA,
								loaded:cntB
							});
						}
						checker();
					};
				})(t[i]),
				onerror:(function(f){
					return function(){
						if(f.onerror){
							f.onerror(null,{
								id:f.id,
								length:cntA,
								loaded:cntB
							});
						}
					};
					checker();
				})(t[i])
			});
		}
	}
	return t;
};

//ロケーション
jg.loc={};
//サーチデータ
jg.loc.search={};
(function(){
	decodeURIComponent(location.search.substring(1)).split('&').forEach(function(x){
		var a=x.split('=');
		jg.loc.search[a[0]]=a[1];
	});
})();

//オーディオ
jg.audio={};
jg.audio.ctx="";
jg.audio.dst="";
if(webkitAudioContext){
	jg.audio.ctx=new webkitAudioContext();
}else if(AudioContext){
	jg.audio.ctx=new AudioContext();
}else{
	console.warn("Jungle.js:WebAudioAPIは利用不可能です。");
}
if(jg.audio.ctx){
	jg.audio.dst=jg.audio.ctx.destination;
}
jg.audio.Source=function(src,detail){
	if(!detail){
		detail={};
	}
	var bufferData;
	var loop=detail.loop||false;
	var playing=false;
	var s;
	var play=function(playOptions){
		if(!playOptions){
			playOptions={};
		}else{
			loop=playOptions.loop;
		}
		if(s){
			stop();
		}
		s=jg.audio.ctx.createBufferSource();
		s.buffer=bufferData;
		s.loop=loop||false;
		s.connect(jg.audio.dst);
		s.start(0);
	};
	
	var stop=function(){
		if(s){
			s.stop();
		}
	};
	
	jg.ajax.request({
		url:src[0],
		responseType:'arraybuffer',
		onload:function(r){
			jg.audio.ctx.decodeAudioData(r.response,function(buffer){
				bufferData=buffer;
				if(detail.autoplay){
					play();
				}
			},function(){
				console.error('Jungle.js:Audio:Decode Error');					 
			});

		}
	});
	

	return {
		loop:loop,
		play:play,
		stop:stop
	};
};

//ネイティブ　イベント　リスナー
window.addEventListener('load',function(){
	jg.win.refreshSize();
	console.log("Jungle.js version."+jg.ver+"");
});
window.addEventListener('resize',function(){
	jg.win.refreshSize();
});

//2014.01.10 4.0.0 BETA
//jg.elm,jg.winなど基本機能を移植
//2014.01.11 4.1.0 BETA
//jg.fitImage BETAを追加
//2014.01.12 4.1.1 BETA
//
//2014.01.22 4.2.0 BETA
//jg.loc.search追加
//2014.02.12 4.2.2 BETA
//リソースローダパック追加
//2014.03.02 4.3.0 BETA
//オーディオ基本追加