/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser.reduce;

import collection.At;
import context.IContext;
import mapping.Mapping;
import parser.Action;
import parser.Grammar;

/**
 *
 * @author mtomono
 */
abstract public class LeafReduce implements Action {
    
    @Override
    public void init(IContext<?> context, Grammar origin) {
    }
    
    @Override
    public void match(IContext<?> context, int start, int end, Grammar origin) {
        context.stack().peek().add(leaf(context, start, end));
    }
    
    abstract public Object leaf(IContext<?> context, int start, int end);
    
    @Override
    public void fail(IContext<?> context, Grammar origin) {
    }
}
