/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import context.IContext;
import java.util.List;
import java.util.Map;

/**
 *
 * @author mtomono
 */
abstract public class Parser<T> {
    Grammar<T> body;
    public Parser(Grammar<T> body) {
        this.body = body;
    }
    
    abstract public void match(IContext<T> context);
    
    public ParseResult parse(List<T> target) {
        return this.parse(target, null);
    }
    
    public ParseResult parse(List<T> target, Map<String, Object> values) {
        return parse(new IContext<>(target).setValues(values));
    }
    
    public ParseResult parse(IContext<T> context) {
        context.stack().push(new ParseResult());
        match(context);
        return context.stack().pop();
    }
}
