/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import collection.At;
import context.Context;
import context.IContext;
import mapping.Const;
import mapping.Mapping;
import mapping.o;
import mapping.order.EQ;
import mapping.order.MC;
import parser.reduce.ContextReduce;
import parser.reduce.Reduce;

/**
 * Context Node delegates matching of context to Intension<Context<T>>
 * @author mtomono
 */
public class Nod<T> extends Grammar<T>{
    Mapping<? super Context<T>, Boolean> body;
    static public Action ReduceNod = new SeqAction(new ContextReduce(At.NOW), new Reduce());

    public static <T extends Comparable<T>> Nod<T> c(T body) {
        return new Nod<>(new MC<>(new EQ(), At.NOW, new Const<>(body)));
    }
    
    public static <T> Nod<T> c(Mapping<? super T, Boolean> body) {
        return new Nod<>(new o(body, At.NOW));
    }
    
    public Nod(Mapping<? super Context<T>, Boolean> body) {
        this.body = body;
        this.action = ReduceNod;
    }

    @Override
    public boolean match(IContext<T> target) {
        if (!target.hasNext())
            return false;
        target.next();
        if (!this.body.of(target)) {
            return false;
        }
        return true;
    }

    @Override
    public String bodyToString() {
        return this.body.toString();
    }
}
