/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import context.IContext;
import parser.reduce.OmitReduce;
import parser.reduce.RangeReduce;
import parser.reduce.Reduce;

/**
 *
 * @author mtomono
 */
public abstract class Grammar<T> {
    static public Action Reduce = new Reduce();
    static public Action NoReduce = new SeqAction();
    static public Action Range = new SeqAction(new OmitReduce(), new RangeReduce());
    
    Action action = Reduce;

    public Grammar with(Action action) {
        assert action != null;
        this.action = action;
        return this;
    }
    
    abstract public boolean match(IContext<T> target);
    
    public boolean parse(IContext<T> target) {
        int start = target.getNextPosition();
        action.init(target, this);
        int current = target.save();
        if (match(target)) {
            action.match(target, start, target.getNextPosition(), this);
            return true;
        }
        action.fail(target, this);
        target.load(current);
        return false;
    }
    
    abstract public String bodyToString();
    
    @Override
    public String toString() {
        return bodyToString() + "#" + action.getClass().getSimpleName();
    }
}
