/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;
import java.util.*;

/**
 *
 * @author mtomono
 */
public class Level<T extends Comparable<T>> {
    RangeSet<T> body;
    
    protected Level(RangeSet<T> body) {
        this.body = body;
    }
    
    public void add(RangeSet<T> added, Iterator<Level<T>> iter, List<Level<T>> index) {
        RangeSet<T> carriedOver = body.intersect(added);
        if (!carriedOver.isEmpty()) {
            if (iter.hasNext()) {
                iter.next().add(carriedOver, iter, index);
            } else {
                index.add(new Level(carriedOver));
            }
        }
        body = body.union(added);
    }

    public void remove(RangeSet<T> removed, Iterator<Level<T>> iter, List<Level<T>> index) {
        if (iter.hasNext()) {
            Level<T> next = iter.next();
            body = body.mask(removed).union(next.body);
            next.remove(removed, iter, index);
        } else {
            body = body.mask(removed);
        }
        if (body.isEmpty()) {
            index.remove(this);
        }
    }
}
