/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping.order;

import mapping.Mapping;

/**
 * VC stands for Value Compare
 * @author mtomono
 */
public class VC<T extends Comparable<T>> implements Mapping<T, Boolean>{
    Compare<T> body;
    T norm;
    Order order;

    public VC(Compare<T> body, T norm, Order order) {
        this.body = body;
        this.norm = norm;
        this.order = order;
    }
    
    public VC(Compare<T> body, T norm) {
        this(body, norm, Default.order);
    }
    
    @Override
    public Boolean of(T target) {
        return body.compare(order, target, this.norm);
    }

    @Override
    public boolean isReady(T target) {
        return true;
    }
}
