/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping.order;

import mapping.Id;
import mapping.Mapping;

/**
 * MC stands for Mapping Compare
 * @author mtomono
 */
public class MC<S, T extends Comparable<T>> implements Mapping<S, Boolean> {
    Compare<T> body;
    Mapping<? super S, ? extends T> mapping1;
    Mapping<? super S, ? extends T> mapping2;
    Order order;
    
    public MC(Compare<T> body, Mapping<? super S, ? extends T> mapping2) {
        this(body, new Id<T>(), mapping2);
    }

    public MC(Compare<T> body, Mapping<? super S, ? extends T> mapping1, Mapping<? super S, ? extends T> mapping2, Order order) {
        this.body = body;
        this.mapping1 = mapping1;
        this.mapping2 = mapping2;
        this.order = order;
    }
    
    public MC(Compare<T> body, Mapping<? super S, ? extends T> mapping1, Mapping<? super S, ? extends T> mapping2) {
        this(body, mapping1, mapping2, Default.order);
    }
    
    @Override
    public boolean isReady(S target) {
        return mapping1.isReady(target) && mapping2.isReady(target);
    }
    
    protected boolean ifNotReady(S target) {
        return true;
    }
    
    
    @Override
    public Boolean of(S target) {
        if (isReady(target)) 
            return body.compare(order, mapping1.of(target), mapping2.of(target));
        else
            return ifNotReady(target);
    }
    
    @Override
    public String toString() {
        return mapping1.toString() + body.toString() + mapping2.toString();
    }
}
