/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping.identity;

import mapping.Mapping;

/**
 * Equality by Mapping
 * in contrast to MC(Mapping Compare), this rather identifies than compares.
 * @author mtomono
 */
public class ME<T> implements Mapping<T, Boolean> {
    Mapping<? super T, ?> mapping1;
    Mapping<? super T, ?> mapping2;
    BCheck check;
    public ME(BCheck check, Mapping<? super T, ?> mapping1, Mapping<? super T, ?> mapping2) {
        this.check = check;
        this.mapping1 = mapping1;
        this.mapping2 = mapping2;
    }
    
    @Override
    public Boolean of(T target) {
        return check.identify(mapping1.of(target), mapping2.of(target));
    }

    @Override
    public boolean isReady(T target) {
        return mapping1.isReady(target) && mapping2.isReady(target);
    }
}
