/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mapping;

import java.util.Map;

/**
 * a mapping explicitly defined by a map.
 * @author mtomono
 */
public class MapMapping<IN, OUT> implements Mapping<IN, OUT> {
    Map<? super IN, ? extends OUT> map;

    public MapMapping(Map<? super IN, ? extends OUT> map) {
        this.map = map;
    }
    @Override
    public OUT of(IN target) {
        return map.get(target);
    }

    @Override
    public boolean isReady(IN target) {
        return map.containsKey(target);
    }
    
}
